/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.cs.melt.copper.compiletime.spec.grammarbeans;

import edu.umn.cs.melt.copper.compiletime.spec.grammarbeans.CopperASTBean;
import edu.umn.cs.melt.copper.compiletime.spec.grammarbeans.CopperElementName;
import edu.umn.cs.melt.copper.compiletime.spec.grammarbeans.CopperElementReference;
import edu.umn.cs.melt.copper.compiletime.spec.grammarbeans.CopperElementType;
import edu.umn.cs.melt.copper.compiletime.spec.grammarbeans.GrammarElement;
import edu.umn.cs.melt.copper.compiletime.spec.grammarbeans.visitors.CopperASTBeanVisitor;
import edu.umn.cs.melt.copper.runtime.logging.CopperException;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;

public class Grammar
extends CopperASTBean {
    private static final long serialVersionUID = 881954662689009409L;
    protected Hashtable<CopperElementName, GrammarElement> grammarElements = new Hashtable();
    protected Set<CopperElementReference> grammarLayout = null;
    private Hashtable<CopperElementType, Set<CopperElementName>> types = new Hashtable();

    public Grammar() {
        this(CopperElementType.GRAMMAR);
    }

    protected Grammar(CopperElementType type) {
        super(type);
        for (CopperElementType t : CopperElementType.values()) {
            this.types.put(t, new HashSet());
        }
    }

    public boolean isPlaceholder() {
        return this.location == null || this.grammarElements.isEmpty();
    }

    @Override
    public boolean isComplete() {
        return super.isComplete() && this.grammarElements != null;
    }

    @Override
    public Set<String> whatIsMissing() {
        Set<String> rv = super.whatIsMissing();
        if (this.grammarElements == null) {
            rv.add("grammarElements");
        }
        return rv;
    }

    public GrammarElement getGrammarElement(CopperElementName element) {
        return this.grammarElements.get(element);
    }

    public Set<CopperElementName> getGrammarElements() {
        return this.grammarElements.keySet();
    }

    public Set<CopperElementName> getElementsOfType(CopperElementType type) {
        return this.types.get((Object)type);
    }

    public boolean addGrammarElement(GrammarElement element) throws CopperException {
        if (element.getName() == null) {
            throw new CopperException("Attempted to add a grammar element before setting its name");
        }
        if (this.grammarElements.containsKey(element.getName())) {
            throw new CopperException("Element " + element.getName() + " already exists in grammar " + this.getDisplayName());
        }
        this.grammarElements.put(element.getName(), element);
        this.types.get((Object)element.getType()).add(element.getName());
        return true;
    }

    public Set<CopperElementReference> getGrammarLayout() {
        return this.grammarLayout;
    }

    public void setGrammarLayout(Set<CopperElementReference> grammarLayout) {
        this.grammarLayout = grammarLayout;
    }

    @Override
    public <RT, E extends Exception> RT acceptVisitor(CopperASTBeanVisitor<RT, E> visitor) throws E {
        return visitor.visitGrammar(this);
    }
}

