/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.cs.melt.copper.legacy.compiletime.concretesyntax.oldxml;

import edu.umn.cs.melt.copper.legacy.compiletime.abstractsyntax.grammar.GrammarSource;
import edu.umn.cs.melt.copper.legacy.compiletime.abstractsyntax.grammar.Symbol;
import edu.umn.cs.melt.copper.legacy.compiletime.abstractsyntax.grammar.Terminal;
import edu.umn.cs.melt.copper.legacy.compiletime.abstractsyntax.intermediate.IntermediateConsNode;
import edu.umn.cs.melt.copper.legacy.compiletime.abstractsyntax.intermediate.IntermediateNode;
import edu.umn.cs.melt.copper.legacy.compiletime.abstractsyntax.intermediate.IntermediateSymbolNode;
import edu.umn.cs.melt.copper.legacy.compiletime.abstractsyntax.intermediate.IntermediateSymbolSort;
import edu.umn.cs.melt.copper.legacy.compiletime.abstractsyntax.intermediate.syntaxtranslator.AttributeConsolidator;
import edu.umn.cs.melt.copper.legacy.compiletime.abstractsyntax.intermediate.syntaxtranslator.MasterController;
import edu.umn.cs.melt.copper.legacy.compiletime.abstractsyntax.regex.CharacterSet;
import edu.umn.cs.melt.copper.legacy.compiletime.abstractsyntax.regex.Choice;
import edu.umn.cs.melt.copper.legacy.compiletime.abstractsyntax.regex.Concatenation;
import edu.umn.cs.melt.copper.legacy.compiletime.abstractsyntax.regex.EmptyString;
import edu.umn.cs.melt.copper.legacy.compiletime.abstractsyntax.regex.KleeneStar;
import edu.umn.cs.melt.copper.legacy.compiletime.abstractsyntax.regex.MacroHole;
import edu.umn.cs.melt.copper.legacy.compiletime.abstractsyntax.regex.ParsedRegex;
import edu.umn.cs.melt.copper.legacy.compiletime.concretesyntax.oldxml.CustomRegexParser;
import edu.umn.cs.melt.copper.legacy.compiletime.logging.CompilerLogMessageSort;
import edu.umn.cs.melt.copper.legacy.compiletime.logging.CompilerLogger;
import edu.umn.cs.melt.copper.runtime.auxiliary.Pair;
import edu.umn.cs.melt.copper.runtime.io.InputPosition;
import edu.umn.cs.melt.copper.runtime.logging.CopperException;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.LinkedList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XMLGrammarParser {
    private static DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
    private static DocumentBuilder parser = null;
    private static InputPosition pos = null;
    private static CustomRegexParser regexParser = null;

    public static InputPosition getPos() {
        InputPosition oldPos = pos;
        pos = InputPosition.advance(pos, ' ');
        return oldPos;
    }

    public static void formalError(CompilerLogger logger, Node n, String need, String neededName, String neededSort) throws CopperException {
        if (logger.isLoggable(CompilerLogMessageSort.ERROR)) {
            logger.logErrorMessage(CompilerLogMessageSort.ERROR, pos, "'" + n.getNodeName() + "' node " + need + " '" + neededName + "' " + neededSort);
        }
    }

    public static GrammarSource parseGrammar(ArrayList<Pair<String, Reader>> files, CompilerLogger logger) throws IOException, CopperException {
        if (parser == null) {
            try {
                parser = dbFactory.newDocumentBuilder();
            }
            catch (ParserConfigurationException ex) {
                if (logger.isLoggable(CompilerLogMessageSort.ERROR)) {
                    logger.logErrorMessage(CompilerLogMessageSort.ERROR, null, ex.getMessage());
                }
                return null;
            }
        }
        Hashtable<String, Node> nodes = new Hashtable<String, Node>();
        for (Pair<String, Reader> pair : files) {
            Document d = null;
            try {
                d = parser.parse(new InputSource(pair.second()));
            }
            catch (SAXException ex) {
                if (logger.isLoggable(CompilerLogMessageSort.ERROR)) {
                    logger.logErrorMessage(CompilerLogMessageSort.ERROR, null, ex.getMessage());
                }
                return null;
            }
            for (int i = 0; i < d.getChildNodes().getLength(); ++i) {
                if (!(d.getChildNodes().item(i) instanceof Element)) continue;
                nodes.put(pair.first(), d.getChildNodes().item(i));
            }
        }
        regexParser = new CustomRegexParser(logger);
        IntermediateNode allNodes = null;
        for (String file : nodes.keySet()) {
            pos = InputPosition.initialPos(file);
            if (allNodes == null) {
                allNodes = XMLGrammarParser.visitDOMNode((Node)nodes.get(file), null, logger);
                continue;
            }
            allNodes = IntermediateConsNode.cons(XMLGrammarParser.visitDOMNode((Node)nodes.get(file), null, logger), allNodes);
        }
        AttributeConsolidator attributeConsolidator = new AttributeConsolidator(logger);
        allNodes.acceptVisitor(attributeConsolidator, null);
        return MasterController.buildAST(logger, attributeConsolidator.consolidatedNodes);
    }

    public static IntermediateNode visitDOMNode(Node n, String inheritance, CompilerLogger logger) throws CopperException {
        if (n.getNodeName().equals("copperspec")) {
            return XMLGrammarParser.visitCopperSpecNode(n, inheritance, logger);
        }
        if (n.getNodeName().equals("preamble")) {
            return XMLGrammarParser.visitPreambleNode(n, inheritance, logger);
        }
        if (n.getNodeName().equals("nonterm")) {
            return XMLGrammarParser.visitNontermNode(n, inheritance, logger);
        }
        if (n.getNodeName().equals("start")) {
            return XMLGrammarParser.visitStartNode(n, inheritance, logger);
        }
        if (n.getNodeName().equals("layout")) {
            return XMLGrammarParser.visitLayoutNode(n, inheritance, logger);
        }
        if (n.getNodeName().equals("prefix")) {
            return XMLGrammarParser.visitPrefixNode(n, inheritance, logger);
        }
        if (n.getNodeName().equals("term")) {
            return XMLGrammarParser.visitTermNode(n, inheritance, logger);
        }
        if (n.getNodeName().equals("prod")) {
            return XMLGrammarParser.visitProdNode(n, inheritance, logger);
        }
        if (n.getNodeName().equals("termclass")) {
            return XMLGrammarParser.visitTermClassNode(n, inheritance, logger);
        }
        if (n.getNodeName().equals("disambig_func")) {
            return XMLGrammarParser.visitDisambigFuncNode(n, inheritance, logger);
        }
        if (n.getNodeName().equals("attribute")) {
            return XMLGrammarParser.visitAttributeNode(n, inheritance, logger);
        }
        if (n.getNodeName().equals("operator")) {
            return XMLGrammarParser.visitOperatorNode(n, inheritance, logger);
        }
        if (n.getNodeName().equals("regex")) {
            return XMLGrammarParser.visitRegexNode(n, inheritance, logger);
        }
        if (n.getNodeName().equals("pp") || n.getNodeName().equals("class") || n.getNodeName().equals("precedence")) {
            return null;
        }
        if (n.getNodeName().startsWith("#")) {
            return null;
        }
        if (logger.isLoggable(CompilerLogMessageSort.ERROR)) {
            logger.logErrorMessage(CompilerLogMessageSort.ERROR, null, "Invalid DOM node type '" + n.getNodeName() + "'");
        }
        return null;
    }

    public static IntermediateNode visitCopperSpecNode(Node n, String inheritance, CompilerLogger logger) throws CopperException {
        int i;
        if (!n.hasChildNodes() || n.getChildNodes().getLength() == 0) {
            return null;
        }
        if (n.getChildNodes().getLength() == 1) {
            return XMLGrammarParser.visitDOMNode(n.getFirstChild(), null, logger);
        }
        if (n.getAttributes().getNamedItem("id") == null) {
            XMLGrammarParser.formalError(logger, n, "missing", "id", "attribute");
            return null;
        }
        if (n.getAttributes().getNamedItem("type") == null) {
            XMLGrammarParser.formalError(logger, n, "missing", "type", "attribute");
            return null;
        }
        String grammarId = n.getAttributes().getNamedItem("id").getTextContent();
        String spectype = n.getAttributes().getNamedItem("type").getTextContent();
        String postParseCode = "";
        IntermediateSymbolNode grammarNameNode = new IntermediateSymbolNode(IntermediateSymbolSort.GRAMMAR_NAME, Symbol.symbol(grammarId), Pair.cons("location", Pair.cons(XMLGrammarParser.getPos(), null)), Pair.cons("spectype", Pair.cons(XMLGrammarParser.getPos(), spectype)));
        IntermediateSymbolNode postParseCodeNode = new IntermediateSymbolNode(IntermediateSymbolSort.DIRECTIVE, Symbol.symbol(" postParseCode "), Pair.cons("location", Pair.cons(XMLGrammarParser.getPos(), null)), Pair.cons("code", Pair.cons(XMLGrammarParser.getPos(), postParseCode)));
        IntermediateNode rv = null;
        ArrayList<IntermediateNode> nodes = new ArrayList<IntermediateNode>();
        nodes.add(grammarNameNode);
        nodes.add(postParseCodeNode);
        for (i = 0; i < n.getChildNodes().getLength(); ++i) {
            nodes.add(XMLGrammarParser.visitDOMNode(n.getChildNodes().item(i), null, logger));
        }
        for (i = nodes.size() - 1; i >= 0; --i) {
            rv = rv == null ? (IntermediateNode)nodes.get(i) : IntermediateConsNode.cons(nodes.get(i), rv);
        }
        return rv;
    }

    public static IntermediateNode visitPreambleNode(Node n, String inheritance, CompilerLogger logger) throws CopperException {
        if (!n.getParentNode().getNodeName().equals("copperspec")) {
            XMLGrammarParser.formalError(logger, n, "missing", "copperspec", "parent");
            return null;
        }
        String code = "";
        if (n.getAttributes().getNamedItem("code") != null) {
            code = n.getAttributes().getNamedItem("code").getTextContent();
        } else {
            for (int i = 0; i < n.getChildNodes().getLength(); ++i) {
                if (!n.getChildNodes().item(i).getNodeName().equals("code")) continue;
                if (code.equals("")) {
                    code = n.getChildNodes().item(i).getTextContent();
                    continue;
                }
                XMLGrammarParser.formalError(logger, n, "has too many", "code", "children");
                return null;
            }
            if (code == null) {
                XMLGrammarParser.formalError(logger, n, "missing", "code", "attribute or child");
                return null;
            }
        }
        return new IntermediateSymbolNode(IntermediateSymbolSort.DIRECTIVE, Symbol.symbol(" startCode "), Pair.cons("location", Pair.cons(XMLGrammarParser.getPos(), null)), Pair.cons("code", Pair.cons(XMLGrammarParser.getPos(), code)));
    }

    public static IntermediateNode visitAttributeNode(Node n, String inheritance, CompilerLogger logger) throws CopperException {
        if (!n.getParentNode().getNodeName().equals("copperspec")) {
            XMLGrammarParser.formalError(logger, n, "missing", "copperspec", "parent");
            return null;
        }
        String code = "";
        if (n.getAttributes().getNamedItem("code") != null) {
            code = n.getAttributes().getNamedItem("code").getTextContent();
        } else {
            for (int i = 0; i < n.getChildNodes().getLength(); ++i) {
                if (!n.getChildNodes().item(i).getNodeName().equals("code")) continue;
                if (code.equals("")) {
                    code = n.getChildNodes().item(i).getTextContent();
                    continue;
                }
                XMLGrammarParser.formalError(logger, n, "has too many", "code", "children");
                return null;
            }
            if (code == null) {
                XMLGrammarParser.formalError(logger, n, "missing", "code", "attribute or child");
                return null;
            }
        }
        String type = "java.lang.Object";
        if (n.getAttributes().getNamedItem("type") != null) {
            type = n.getAttributes().getNamedItem("type").getTextContent();
        } else {
            for (int i = 0; i < n.getChildNodes().getLength(); ++i) {
                if (!n.getChildNodes().item(i).getNodeName().equals("type")) continue;
                if (type.equals("java.lang.Object")) {
                    type = n.getChildNodes().item(i).getTextContent();
                    continue;
                }
                XMLGrammarParser.formalError(logger, n, "has too many", "type", "children");
                return null;
            }
            if (type == null) {
                XMLGrammarParser.formalError(logger, n, "missing", "type", "attribute or child");
                return null;
            }
        }
        if (n.getAttributes().getNamedItem("id") == null) {
            XMLGrammarParser.formalError(logger, n, "missing", "id", "attribute");
            return null;
        }
        String id = n.getAttributes().getNamedItem("id").getTextContent();
        if (n.getAttributes().getNamedItem("type") != null) {
            type = n.getAttributes().getNamedItem("type").getTextContent();
        }
        return new IntermediateSymbolNode(IntermediateSymbolSort.PARSER_ATTRIBUTE, Symbol.symbol(id), Pair.cons("location", Pair.cons(XMLGrammarParser.getPos(), null)), Pair.cons("type", Pair.cons(XMLGrammarParser.getPos(), type)), Pair.cons("code", Pair.cons(XMLGrammarParser.getPos(), code)));
    }

    public static String visitCodeNode(Node n, String inheritance, CompilerLogger logger) throws CopperException {
        String parentName = n.getParentNode().getNodeName();
        if (!(parentName.equals("preamble") || parentName.equals("term") || parentName.equals("prod") || parentName.equals("disambig_func"))) {
            XMLGrammarParser.formalError(logger, n, "missing", "preamble', 'term', 'prod', or 'disambig_func", "parent");
            return null;
        }
        return n.getTextContent();
    }

    public static IntermediateNode visitNontermNode(Node n, String inheritance, CompilerLogger logger) throws CopperException {
        String parentName = n.getParentNode().getNodeName();
        if (!(parentName.equals("copperspec") || parentName.equals("lhs") || parentName.equals("rhs") || parentName.equals("start"))) {
            XMLGrammarParser.formalError(logger, n, "missing", "copperspec', 'lhs', 'rhs', or 'start", "parent");
            return null;
        }
        if (n.getAttributes().getNamedItem("id") == null) {
            XMLGrammarParser.formalError(logger, n, "missing", "id", "attribute");
            return null;
        }
        String id = n.getAttributes().getNamedItem("id").getTextContent();
        String type = "java.lang.Object";
        if (n.getAttributes().getNamedItem("type") != null) {
            type = n.getAttributes().getNamedItem("type").getTextContent();
        }
        String displayName = null;
        for (int i = 0; i < n.getChildNodes().getLength(); ++i) {
            if (!n.getChildNodes().item(i).getNodeName().equals("pp")) continue;
            if (displayName == null) {
                displayName = n.getChildNodes().item(i).getTextContent();
                continue;
            }
            XMLGrammarParser.formalError(logger, n, "has too many", "pp", "children");
            return null;
        }
        return new IntermediateSymbolNode(IntermediateSymbolSort.NON_TERMINAL, Symbol.symbol(id), Pair.cons("location", Pair.cons(XMLGrammarParser.getPos(), null)), Pair.cons("type", Pair.cons(XMLGrammarParser.getPos(), type)), displayName == null ? null : Pair.cons("displayname", Pair.cons(XMLGrammarParser.getPos(), displayName)));
    }

    public static IntermediateNode visitTermNode(Node n, String inheritance, CompilerLogger logger) throws CopperException {
        IntermediateSymbolNode termSym;
        String parentName = n.getParentNode().getNodeName();
        if (!(parentName.equals("copperspec") || parentName.equals("layout") || parentName.equals("prefix") || parentName.equals("lhs") || parentName.equals("rhs") || parentName.equals("disambig_func"))) {
            XMLGrammarParser.formalError(logger, n, "missing", "copperspec', 'layout', 'prefix', 'lhs', 'rhs', or 'disambig_func", "parent");
            return null;
        }
        if (n.getAttributes().getNamedItem("id") == null) {
            XMLGrammarParser.formalError(logger, n, "missing", "id", "attribute");
            return null;
        }
        String id = n.getAttributes().getNamedItem("id").getTextContent();
        ParsedRegex regexP = null;
        if (n.getAttributes().getNamedItem("regex") != null) {
            String regex = n.getAttributes().getNamedItem("regex").getTextContent();
            regexParser.setToParse(regex);
            regexP = regexParser.parse();
        }
        String type = "java.lang.Object";
        if (n.getAttributes().getNamedItem("type") != null) {
            type = n.getAttributes().getNamedItem("type").getTextContent();
        }
        String code = "";
        if (n.getAttributes().getNamedItem("code") != null) {
            code = n.getAttributes().getNamedItem("code").getTextContent();
        } else {
            for (int i = 0; i < n.getChildNodes().getLength(); ++i) {
                if (!n.getChildNodes().item(i).getNodeName().equals("code")) continue;
                if (code.equals("")) {
                    code = n.getChildNodes().item(i).getTextContent();
                    continue;
                }
                XMLGrammarParser.formalError(logger, n, "has too many", "code", "children");
                return null;
            }
            if (code == null) {
                XMLGrammarParser.formalError(logger, n, "missing", "code", "attribute or child");
                return null;
            }
        }
        String displayName = null;
        for (int i = 0; i < n.getChildNodes().getLength(); ++i) {
            if (!n.getChildNodes().item(i).getNodeName().equals("pp")) continue;
            if (displayName == null) {
                displayName = n.getChildNodes().item(i).getTextContent();
                continue;
            }
            XMLGrammarParser.formalError(logger, n, "has too many", "pp", "children");
            return null;
        }
        IntermediateNode rv = termSym = new IntermediateSymbolNode(IntermediateSymbolSort.TERMINAL, Symbol.symbol(id), Pair.cons("location", Pair.cons(XMLGrammarParser.getPos(), null)), Pair.cons("type", Pair.cons(XMLGrammarParser.getPos(), type)), regexP != null ? Pair.cons("regex", Pair.cons(XMLGrammarParser.getPos(), regexP)) : null, Pair.cons("code", Pair.cons(XMLGrammarParser.getPos(), code)), displayName == null ? null : Pair.cons("displayname", Pair.cons(XMLGrammarParser.getPos(), displayName)));
        if (n.hasChildNodes()) {
            for (int i = 0; i < n.getChildNodes().getLength(); ++i) {
                if (n.getChildNodes().item(i).getNodeName().equals("classes")) {
                    for (int j = 0; j < n.getChildNodes().item(i).getChildNodes().getLength(); ++j) {
                        rv = IntermediateConsNode.cons(XMLGrammarParser.visitDOMNode(n.getChildNodes().item(i).getChildNodes().item(j), id, logger), rv);
                    }
                    continue;
                }
                if (n.getChildNodes().item(i).getNodeName().equals("submits")) {
                    LinkedList<String> submitList = XMLGrammarParser.visitTermOrClassListNode(n.getChildNodes().item(i), id, logger);
                    termSym.attributes.put("submits", Pair.cons(XMLGrammarParser.getPos(), submitList));
                    continue;
                }
                if (n.getChildNodes().item(i).getNodeName().equals("dominates")) {
                    LinkedList<String> dominateList = XMLGrammarParser.visitTermOrClassListNode(n.getChildNodes().item(i), id, logger);
                    termSym.attributes.put("dominates", Pair.cons(XMLGrammarParser.getPos(), dominateList));
                    continue;
                }
                if (n.getChildNodes().item(i).getNodeName().equals("code")) continue;
                rv = IntermediateConsNode.cons(XMLGrammarParser.visitDOMNode(n.getChildNodes().item(i), id, logger), rv);
            }
        }
        return rv;
    }

    public static IntermediateNode visitStartNode(Node n, String inheritance, CompilerLogger logger) throws CopperException {
        if (!n.getParentNode().getNodeName().equals("copperspec")) {
            XMLGrammarParser.formalError(logger, n, "missing", "copperspec", "parent");
            return null;
        }
        int nontermNodeCount = 0;
        IntermediateNode ntName = null;
        LinkedList<String> layoutList = new LinkedList<String>();
        for (int i = 0; i < n.getChildNodes().getLength(); ++i) {
            LinkedList<String> layoutListPart;
            if (n.getChildNodes().item(i).getNodeName().equals("nonterm")) {
                ntName = XMLGrammarParser.visitDOMNode(n.getChildNodes().item(i), null, logger);
                ++nontermNodeCount;
                continue;
            }
            if (!n.getChildNodes().item(i).getNodeName().equals("layout") || (layoutListPart = XMLGrammarParser.visitTermListNode(n.getChildNodes().item(i), null, logger)) == null) continue;
            layoutList.addAll(XMLGrammarParser.visitTermListNode(n.getChildNodes().item(i), null, logger));
        }
        if (nontermNodeCount == 0) {
            XMLGrammarParser.formalError(logger, n, "missing", "nonterm", "child");
            return null;
        }
        if (nontermNodeCount > 1) {
            XMLGrammarParser.formalError(logger, n, "has more than one", "nonterm", "child");
            return null;
        }
        if (layoutList != null) {
            ((IntermediateSymbolNode)ntName).attributes.put("startLayout", Pair.cons(XMLGrammarParser.getPos(), layoutList));
        }
        ((IntermediateSymbolNode)ntName).attributes.put("isStart", Pair.cons(XMLGrammarParser.getPos(), true));
        return ntName;
    }

    public static IntermediateNode visitOperatorNode(Node n, String inheritance, CompilerLogger logger) throws CopperException {
        if (!n.getParentNode().getNodeName().equals("term")) {
            XMLGrammarParser.formalError(logger, n, "missing", "term", "parent");
            return null;
        }
        String operatorClass = null;
        int operatorPrecedence = -1;
        int operatorAssociativity = -1;
        for (int i = 0; i < n.getChildNodes().getLength(); ++i) {
            if (n.getChildNodes().item(i).getNodeName().equals("opclass")) {
                if (operatorClass != null) {
                    XMLGrammarParser.formalError(logger, n, "has too many", "opclass", "children");
                    return null;
                }
                if (n.getChildNodes().item(i).getAttributes().getNamedItem("id") == null) {
                    XMLGrammarParser.formalError(logger, n.getChildNodes().item(i), "missing", "id", "attribute");
                    return null;
                }
                operatorClass = n.getChildNodes().item(i).getAttributes().getNamedItem("id").getTextContent();
            } else if (n.getChildNodes().item(i).getNodeName().equals("precedence")) {
                if (operatorPrecedence != -1) {
                    XMLGrammarParser.formalError(logger, n, "has too many", "precedence", "children");
                    return null;
                }
                try {
                    operatorPrecedence = Integer.parseInt(n.getChildNodes().item(i).getTextContent());
                }
                catch (NumberFormatException ex) {
                    XMLGrammarParser.formalError(logger, n.getChildNodes().item(i), "has invalid", "numerical", "content");
                }
            }
            if (!n.getChildNodes().item(i).getNodeName().equals("associativity")) continue;
            if (operatorAssociativity != -1) {
                XMLGrammarParser.formalError(logger, n, "has too many", "associativity", "children");
                return null;
            }
            String assocString = n.getChildNodes().item(i).getTextContent();
            if (assocString.equals("nonassoc")) {
                operatorAssociativity = 1;
                continue;
            }
            if (assocString.equals("left")) {
                operatorAssociativity = 2;
                continue;
            }
            if (assocString.equals("right")) {
                operatorAssociativity = 3;
                continue;
            }
            XMLGrammarParser.formalError(logger, n.getChildNodes().item(i), "has", "invalid", "associativity");
        }
        IntermediateNode rv = IntermediateConsNode.cons(new IntermediateSymbolNode(IntermediateSymbolSort.TERMINAL_CLASS, Symbol.symbol(operatorClass), Pair.cons("location", Pair.cons(XMLGrammarParser.getPos(), null))), new IntermediateSymbolNode(IntermediateSymbolSort.TERMINAL, Symbol.symbol(inheritance), Pair.cons("operatorClass", Pair.cons(XMLGrammarParser.getPos(), operatorClass)), Pair.cons("operatorPrecedence", Pair.cons(XMLGrammarParser.getPos(), operatorPrecedence)), Pair.cons("operatorAssociativity", Pair.cons(XMLGrammarParser.getPos(), Pair.cons(XMLGrammarParser.getPos(), operatorAssociativity)))));
        return rv;
    }

    public static IntermediateNode visitLayoutNode(Node n, String inheritance, CompilerLogger logger) throws CopperException {
        if (!n.hasChildNodes() || n.getChildNodes().getLength() == 0) {
            return null;
        }
        if (n.getChildNodes().getLength() == 1) {
            return XMLGrammarParser.visitDOMNode(n.getFirstChild(), null, logger);
        }
        IntermediateNode rv = XMLGrammarParser.visitDOMNode(n.getFirstChild(), null, logger);
        for (int i = 1; i < n.getChildNodes().getLength(); ++i) {
            rv = new IntermediateConsNode(XMLGrammarParser.visitDOMNode(n.getChildNodes().item(i), null, logger), rv);
        }
        return rv;
    }

    public static IntermediateNode visitProdNode(Node n, String inheritance, CompilerLogger logger) throws CopperException {
        int precedence;
        String precClass;
        String id;
        block26: {
            if (!n.getParentNode().getNodeName().equals("copperspec")) {
                XMLGrammarParser.formalError(logger, n, "missing", "copperspec", "parent");
                return null;
            }
            if (n.getAttributes().getNamedItem("id") == null) {
                XMLGrammarParser.formalError(logger, n, "missing", "id", "attribute");
                return null;
            }
            if (n.getAttributes().getNamedItem("class") == null && ((Element)n).getElementsByTagName("class").getLength() != 1) {
                if (n.getAttributes().getNamedItem("class") == null && ((Element)n).getElementsByTagName("class").getLength() == 0) {
                    XMLGrammarParser.formalError(logger, n, "missing", "class", "child");
                } else {
                    XMLGrammarParser.formalError(logger, n, "has too many", "class", "children");
                }
                return null;
            }
            if (n.getAttributes().getNamedItem("precedence") == null && ((Element)n).getElementsByTagName("precedence").getLength() != 1) {
                if (n.getAttributes().getNamedItem("precedence") == null && ((Element)n).getElementsByTagName("precedence").getLength() == 0) {
                    XMLGrammarParser.formalError(logger, n, "missing", "precedence", "child");
                } else {
                    XMLGrammarParser.formalError(logger, n, "has too many", "precedence", "children");
                }
                return null;
            }
            id = n.getAttributes().getNamedItem("id").getTextContent();
            precClass = n.getAttributes().getNamedItem("class") != null ? n.getAttributes().getNamedItem("class").getTextContent() : ((Element)n).getElementsByTagName("class").item(0).getTextContent();
            precedence = 0;
            try {
                String precString = n.getAttributes().getNamedItem("precedence") != null ? n.getAttributes().getNamedItem("precedence").getTextContent() : ((Element)n).getElementsByTagName("precedence").item(0).getTextContent();
                precedence = Integer.parseInt(precString);
            }
            catch (NumberFormatException ex) {
                if (!logger.isLoggable(CompilerLogMessageSort.ERROR)) break block26;
                logger.logErrorMessage(CompilerLogMessageSort.ERROR, pos, "Expected numeric precedence declaration on production '" + id + "'; got '" + n.getAttributes().getNamedItem("precedence").getTextContent() + "'");
            }
        }
        String code = "";
        if (n.getAttributes().getNamedItem("code") != null) {
            code = n.getAttributes().getNamedItem("code").getTextContent();
        } else {
            for (int i = 0; i < n.getChildNodes().getLength(); ++i) {
                if (!n.getChildNodes().item(i).getNodeName().equals("code")) continue;
                if (code.equals("")) {
                    code = n.getChildNodes().item(i).getTextContent();
                    continue;
                }
                XMLGrammarParser.formalError(logger, n, "has too many", "code", "children");
                return null;
            }
            if (code == null) {
                XMLGrammarParser.formalError(logger, n, "missing", "code", "attribute or child");
                return null;
            }
        }
        String operatorNode = null;
        LinkedList<String> layoutNode = new LinkedList<String>();
        String lhsNode = null;
        LinkedList<String> rhsNode = null;
        int lhsNodeCount = 0;
        int rhsNodeCount = 0;
        for (int i = 0; i < n.getChildNodes().getLength(); ++i) {
            if (n.getChildNodes().item(i).getNodeName().equals("operator")) {
                operatorNode = XMLGrammarParser.visitProdOperatorNode(n.getChildNodes().item(i), id, logger);
                continue;
            }
            if (n.getChildNodes().item(i).getNodeName().equals("layout")) {
                LinkedList<String> layoutNodeP = XMLGrammarParser.visitTermListNode(n.getChildNodes().item(i), id, logger);
                if (layoutNodeP == null) continue;
                layoutNode.addAll(layoutNodeP);
                continue;
            }
            if (n.getChildNodes().item(i).getNodeName().equals("lhs")) {
                lhsNode = XMLGrammarParser.visitLHSNode(n.getChildNodes().item(i), id, logger);
                ++lhsNodeCount;
                continue;
            }
            if (!n.getChildNodes().item(i).getNodeName().equals("rhs")) continue;
            rhsNode = XMLGrammarParser.visitRHSNode(n.getChildNodes().item(i), id, logger);
            ++rhsNodeCount;
        }
        if (layoutNode.isEmpty()) {
            layoutNode = null;
        }
        if (lhsNodeCount == 0) {
            XMLGrammarParser.formalError(logger, n, "missing", "lhs", "child");
            return null;
        }
        if (lhsNodeCount > 1) {
            XMLGrammarParser.formalError(logger, n, "has more than one", "lhs", "child");
            return null;
        }
        if (rhsNodeCount == 0) {
            XMLGrammarParser.formalError(logger, n, "missing", "rhs", "child");
            return null;
        }
        if (rhsNodeCount > 1) {
            XMLGrammarParser.formalError(logger, n, "has more than one", "rhs", "child");
            return null;
        }
        String displayName = null;
        for (int i = 0; i < n.getChildNodes().getLength(); ++i) {
            if (!n.getChildNodes().item(i).getNodeName().equals("pp")) continue;
            if (displayName == null) {
                displayName = n.getChildNodes().item(i).getTextContent();
                continue;
            }
            XMLGrammarParser.formalError(logger, n, "has too many", "pp", "children");
            return null;
        }
        IntermediateSymbolNode precClassNode = new IntermediateSymbolNode(IntermediateSymbolSort.TERMINAL_CLASS, Symbol.symbol(precClass), Pair.cons("location", Pair.cons(XMLGrammarParser.getPos(), null)));
        IntermediateSymbolNode prodNode = new IntermediateSymbolNode(IntermediateSymbolSort.PRODUCTION, Symbol.symbol(id), Pair.cons("location", Pair.cons(XMLGrammarParser.getPos(), null)), Pair.cons("class", Pair.cons(XMLGrammarParser.getPos(), precClass)), Pair.cons("precedence", Pair.cons(XMLGrammarParser.getPos(), precedence)), operatorNode == null ? null : Pair.cons("operator", Pair.cons(XMLGrammarParser.getPos(), operatorNode)), layoutNode == null ? null : Pair.cons("layout", Pair.cons(XMLGrammarParser.getPos(), layoutNode)), Pair.cons("code", Pair.cons(XMLGrammarParser.getPos(), code)), Pair.cons("LHS", Pair.cons(XMLGrammarParser.getPos(), lhsNode)), Pair.cons("RHS", Pair.cons(XMLGrammarParser.getPos(), rhsNode)), displayName == null ? null : Pair.cons("displayname", Pair.cons(XMLGrammarParser.getPos(), displayName)));
        return new IntermediateConsNode(precClassNode, prodNode);
    }

    public static String visitProdOperatorNode(Node n, String inheritance, CompilerLogger logger) throws CopperException {
        int termNodeIndex = -1;
        for (int i = 0; i < n.getChildNodes().getLength(); ++i) {
            if (n.getChildNodes().item(i).getNodeName().equals("term")) {
                if (termNodeIndex == -1) {
                    termNodeIndex = i;
                    continue;
                }
                XMLGrammarParser.formalError(logger, n, "has more than one", "term", "child");
                return null;
            }
            if (n.getChildNodes().item(i).getNodeName().startsWith("#")) continue;
            XMLGrammarParser.formalError(logger, n, "has invalid", n.getChildNodes().item(i).getNodeName(), "child");
            return null;
        }
        if (n.getChildNodes().item(termNodeIndex).getAttributes().getNamedItem("id") == null) {
            XMLGrammarParser.formalError(logger, n.getChildNodes().item(termNodeIndex), "missing", "id", "attribute");
            return null;
        }
        return n.getChildNodes().item(termNodeIndex).getAttributes().getNamedItem("id").getTextContent();
    }

    public static String visitLHSNode(Node n, String inheritance, CompilerLogger logger) throws CopperException {
        int nontermNodeIndex = -1;
        for (int i = 0; i < n.getChildNodes().getLength(); ++i) {
            if (n.getChildNodes().item(i).getNodeName().equals("nonterm")) {
                if (nontermNodeIndex == -1) {
                    nontermNodeIndex = i;
                    continue;
                }
                XMLGrammarParser.formalError(logger, n, "has more than one", "nonterm", "child");
                return null;
            }
            if (n.getChildNodes().item(i).getNodeName().startsWith("#")) continue;
            XMLGrammarParser.formalError(logger, n, "has invalid", n.getChildNodes().item(i).getNodeName(), "child");
            return null;
        }
        if (n.getChildNodes().item(nontermNodeIndex).getAttributes().getNamedItem("id") == null) {
            XMLGrammarParser.formalError(logger, n.getChildNodes().item(nontermNodeIndex), "missing", "id", "attribute");
            return null;
        }
        return n.getChildNodes().item(nontermNodeIndex).getAttributes().getNamedItem("id").getTextContent();
    }

    public static LinkedList<String> visitRHSNode(Node n, String inheritance, CompilerLogger logger) throws CopperException {
        LinkedList<String> rv = new LinkedList<String>();
        for (int i = 0; i < n.getChildNodes().getLength(); ++i) {
            if (n.getChildNodes().item(i).getNodeName().equals("term") || n.getChildNodes().item(i).getNodeName().equals("nonterm") || n.getChildNodes().item(i).getNodeName().equals("symbol")) {
                if (n.getChildNodes().item(i).getAttributes().getNamedItem("id") == null) {
                    XMLGrammarParser.formalError(logger, n.getChildNodes().item(i), "missing", "id", "attribute");
                    return null;
                }
                rv.add(n.getChildNodes().item(i).getAttributes().getNamedItem("id").getTextContent());
                continue;
            }
            if (n.getChildNodes().item(i).getNodeName().startsWith("#")) continue;
            XMLGrammarParser.formalError(logger, n, "has invalid", n.getChildNodes().item(i).getNodeName(), "child");
            return null;
        }
        return rv;
    }

    public static IntermediateNode visitDisambigFuncNode(Node n, String inheritance, CompilerLogger logger) throws CopperException {
        if (n.getAttributes().getNamedItem("id") == null) {
            XMLGrammarParser.formalError(logger, n, "missing", "id", "attribute");
        }
        String id = n.getAttributes().getNamedItem("id").getTextContent();
        String code = "";
        if (n.getAttributes().getNamedItem("code") != null) {
            code = n.getAttributes().getNamedItem("code").getTextContent();
        } else {
            for (int i = 0; i < n.getChildNodes().getLength(); ++i) {
                if (!n.getChildNodes().item(i).getNodeName().equals("code")) continue;
                if (code.equals("")) {
                    code = n.getChildNodes().item(i).getTextContent();
                    continue;
                }
                XMLGrammarParser.formalError(logger, n, "has too many", "code", "children");
                return null;
            }
            if (code == null) {
                XMLGrammarParser.formalError(logger, n, "missing", "code", "attribute or child");
                return null;
            }
        }
        LinkedList<String> members = new LinkedList<String>();
        for (int i = 0; i < n.getChildNodes().getLength(); ++i) {
            if (n.getChildNodes().item(i).getNodeName().equals("term")) {
                if (n.getChildNodes().item(i).getAttributes().getNamedItem("id") == null) {
                    XMLGrammarParser.formalError(logger, n.getChildNodes().item(i), "missing", "id", "attribute");
                    return null;
                }
                members.add(n.getChildNodes().item(i).getAttributes().getNamedItem("id").getTextContent());
                continue;
            }
            if (n.getChildNodes().item(i).getNodeName().equals("code") || n.getChildNodes().item(i).getNodeName().startsWith("#")) continue;
            XMLGrammarParser.formalError(logger, n, "has invalid", n.getChildNodes().item(i).getNodeName(), "child");
            return null;
        }
        return new IntermediateSymbolNode(IntermediateSymbolSort.DISAMBIGUATION_GROUP, Symbol.symbol(id), Pair.cons("location", Pair.cons(XMLGrammarParser.getPos(), null)), Pair.cons("code", Pair.cons(XMLGrammarParser.getPos(), code)), Pair.cons("members", Pair.cons(XMLGrammarParser.getPos(), members)));
    }

    public static LinkedList<String> visitTermListNode(Node n, String inheritance, CompilerLogger logger) throws CopperException {
        LinkedList<String> members = new LinkedList<String>();
        for (int i = 0; i < n.getChildNodes().getLength(); ++i) {
            if (n.getChildNodes().item(i).getNodeName().equals("term")) {
                if (n.getChildNodes().item(i).getAttributes().getNamedItem("id") == null) {
                    XMLGrammarParser.formalError(logger, n.getChildNodes().item(i), "missing", "id", "attribute");
                    return null;
                }
                members.add(n.getChildNodes().item(i).getAttributes().getNamedItem("id").getTextContent());
                continue;
            }
            if (n.getChildNodes().item(i).getNodeName().startsWith("#")) continue;
            XMLGrammarParser.formalError(logger, n, "has invalid", n.getChildNodes().item(i).getNodeName(), "child");
            return null;
        }
        return members;
    }

    public static LinkedList<String> visitTermOrClassListNode(Node n, String inheritance, CompilerLogger logger) throws CopperException {
        LinkedList<String> members = new LinkedList<String>();
        for (int i = 0; i < n.getChildNodes().getLength(); ++i) {
            if (n.getChildNodes().item(i).getNodeName().equals("term")) {
                if (n.getChildNodes().item(i).getAttributes().getNamedItem("id") == null) {
                    XMLGrammarParser.formalError(logger, n.getChildNodes().item(i), "missing", "id", "attribute");
                    return null;
                }
                members.add(n.getChildNodes().item(i).getAttributes().getNamedItem("id").getTextContent());
                continue;
            }
            if (n.getChildNodes().item(i).getNodeName().equals("termclass")) {
                if (n.getChildNodes().item(i).getAttributes().getNamedItem("id") == null) {
                    XMLGrammarParser.formalError(logger, n.getChildNodes().item(i), "missing", "id", "attribute");
                    return null;
                }
                members.add(n.getChildNodes().item(i).getAttributes().getNamedItem("id").getTextContent());
                continue;
            }
            if (n.getChildNodes().item(i).getNodeName().startsWith("#")) continue;
            XMLGrammarParser.formalError(logger, n, "has invalid", n.getChildNodes().item(i).getNodeName(), "child");
            return null;
        }
        return members;
    }

    public static IntermediateNode visitTermClassNode(Node n, String inheritance, CompilerLogger logger) throws CopperException {
        if (n.getAttributes().getNamedItem("id") == null) {
            XMLGrammarParser.formalError(logger, n, "missing", "id", "attribute");
            return null;
        }
        String id = n.getAttributes().getNamedItem("id").getTextContent();
        LinkedList<String> ids = new LinkedList<String>();
        ids.add(id);
        return IntermediateConsNode.cons(new IntermediateSymbolNode(IntermediateSymbolSort.TERMINAL_CLASS, Symbol.symbol(id), Pair.cons("location", Pair.cons(XMLGrammarParser.getPos(), null))), new IntermediateSymbolNode(IntermediateSymbolSort.TERMINAL, Symbol.symbol(inheritance), Pair.cons("location", Pair.cons(XMLGrammarParser.getPos(), null)), Pair.cons("classes", Pair.cons(XMLGrammarParser.getPos(), ids))));
    }

    public static IntermediateNode visitPrefixNode(Node n, String inheritance, CompilerLogger logger) throws CopperException {
        int termNodeIndex = -1;
        for (int i = 0; i < n.getChildNodes().getLength(); ++i) {
            if (n.getChildNodes().item(i).getNodeName().equals("term")) {
                if (termNodeIndex == -1) {
                    termNodeIndex = i;
                    continue;
                }
                XMLGrammarParser.formalError(logger, n, "has more than one", "term", "child");
                return null;
            }
            if (n.getChildNodes().item(i).getNodeName().startsWith("#")) continue;
            XMLGrammarParser.formalError(logger, n, "has invalid", n.getChildNodes().item(i).getNodeName(), "child");
            return null;
        }
        if (n.getChildNodes().item(termNodeIndex).getAttributes().getNamedItem("id") == null) {
            XMLGrammarParser.formalError(logger, n.getChildNodes().item(termNodeIndex), "missing", "id", "attribute");
            return null;
        }
        return new IntermediateSymbolNode(IntermediateSymbolSort.TERMINAL, Symbol.symbol(inheritance), Pair.cons("location", Pair.cons(XMLGrammarParser.getPos(), null)), Pair.cons("prefix", Pair.cons(XMLGrammarParser.getPos(), n.getChildNodes().item(termNodeIndex).getAttributes().getNamedItem("id").getTextContent())));
    }

    public static IntermediateNode visitRegexNode(Node n, String inheritance, CompilerLogger logger) throws CopperException {
        if (!n.getParentNode().getNodeName().equals("term")) {
            XMLGrammarParser.formalError(logger, n, "missing", "term", "parent");
            return null;
        }
        ParsedRegex pr = null;
        for (int i = 0; i < n.getChildNodes().getLength(); ++i) {
            ParsedRegex buffer = XMLGrammarParser.visitRegexInteriorNode(n.getChildNodes().item(i), inheritance, logger);
            if (buffer != null && pr != null) {
                XMLGrammarParser.formalError(logger, n, "has too many", "regex", "children");
                return null;
            }
            if (buffer == null) continue;
            pr = buffer;
        }
        return new IntermediateSymbolNode(IntermediateSymbolSort.TERMINAL, Symbol.symbol(inheritance), Pair.cons("location", Pair.cons(XMLGrammarParser.getPos(), null)), Pair.cons("regex", Pair.cons(XMLGrammarParser.getPos(), pr)));
    }

    public static ParsedRegex visitRegexInteriorNode(Node n, String inheritance, CompilerLogger logger) throws CopperException {
        if (n.getNodeName().equals("string")) {
            return XMLGrammarParser.visitRegexStringNode(n, inheritance, logger);
        }
        if (n.getNodeName().equals("concat")) {
            return XMLGrammarParser.visitRegexConcatNode(n, inheritance, logger);
        }
        if (n.getNodeName().equals("choice")) {
            return XMLGrammarParser.visitRegexChoiceNode(n, inheritance, logger);
        }
        if (n.getNodeName().equals("opt")) {
            return XMLGrammarParser.visitRegexOptNode(n, inheritance, logger);
        }
        if (n.getNodeName().equals("kleenestar")) {
            return XMLGrammarParser.visitRegexKleeneStarNode(n, inheritance, logger);
        }
        if (n.getNodeName().equals("plus")) {
            return XMLGrammarParser.visitRegexPlusNode(n, inheritance, logger);
        }
        if (n.getNodeName().equals("emptystring")) {
            return XMLGrammarParser.visitRegexEmptyStringNode(n, inheritance, logger);
        }
        if (n.getNodeName().equals("charset")) {
            return XMLGrammarParser.visitRegexCharsetNode(n, inheritance, logger);
        }
        if (n.getNodeName().equals("macro")) {
            return XMLGrammarParser.visitRegexMacroNode(n, inheritance, logger);
        }
        if (n.getNodeName().equals("dot")) {
            return XMLGrammarParser.visitRegexWildcardNode(n, inheritance, logger);
        }
        if (n.getNodeName().startsWith("#")) {
            return null;
        }
        if (logger.isLoggable(CompilerLogMessageSort.ERROR)) {
            logger.logErrorMessage(CompilerLogMessageSort.ERROR, null, "Invalid regex interior node type '" + n.getNodeName() + "'");
        }
        return null;
    }

    private static ParsedRegex visitRegexMacroNode(Node n, String inheritance, CompilerLogger logger) throws CopperException {
        int termNodeIndex = -1;
        for (int i = 0; i < n.getChildNodes().getLength(); ++i) {
            if (n.getChildNodes().item(i).getNodeName().equals("term")) {
                if (termNodeIndex == -1) {
                    termNodeIndex = i;
                    continue;
                }
                XMLGrammarParser.formalError(logger, n, "has more than one", "term", "child");
                return null;
            }
            if (n.getChildNodes().item(i).getNodeName().startsWith("#")) continue;
            XMLGrammarParser.formalError(logger, n, "has invalid", n.getChildNodes().item(i).getNodeName(), "child");
            return null;
        }
        if (n.getChildNodes().item(termNodeIndex).getAttributes().getNamedItem("id") == null) {
            XMLGrammarParser.formalError(logger, n.getChildNodes().item(termNodeIndex), "missing", "id", "attribute");
            return null;
        }
        return new MacroHole(new Terminal(n.getChildNodes().item(termNodeIndex).getAttributes().getNamedItem("id").getTextContent()));
    }

    private static ParsedRegex visitRegexPlusNode(Node n, String inheritance, CompilerLogger logger) throws CopperException {
        ParsedRegex pr = null;
        for (int i = 0; i < n.getChildNodes().getLength(); ++i) {
            ParsedRegex buffer = XMLGrammarParser.visitRegexInteriorNode(n.getChildNodes().item(i), inheritance, logger);
            if (buffer != null && pr != null) {
                XMLGrammarParser.formalError(logger, n, "has too many", "regex", "children");
            }
            if (buffer == null) continue;
            pr = buffer;
        }
        return new Concatenation(pr, new KleeneStar(pr.clone()));
    }

    private static ParsedRegex visitRegexOptNode(Node n, String inheritance, CompilerLogger logger) throws CopperException {
        ParsedRegex pr = null;
        for (int i = 0; i < n.getChildNodes().getLength(); ++i) {
            ParsedRegex buffer = XMLGrammarParser.visitRegexInteriorNode(n.getChildNodes().item(i), inheritance, logger);
            if (buffer != null && pr != null) {
                XMLGrammarParser.formalError(logger, n, "has too many", "regex", "children");
            }
            if (buffer == null) continue;
            pr = buffer;
        }
        return new Choice(pr, new EmptyString());
    }

    private static ParsedRegex visitRegexKleeneStarNode(Node n, String inheritance, CompilerLogger logger) throws CopperException {
        ParsedRegex pr = null;
        for (int i = 0; i < n.getChildNodes().getLength(); ++i) {
            ParsedRegex buffer = XMLGrammarParser.visitRegexInteriorNode(n.getChildNodes().item(i), inheritance, logger);
            if (buffer != null && pr != null) {
                XMLGrammarParser.formalError(logger, n, "has too many", "regex", "children");
            }
            if (buffer == null) continue;
            pr = buffer;
        }
        return new KleeneStar(pr);
    }

    private static ParsedRegex visitRegexEmptyStringNode(Node n, String inheritance, CompilerLogger logger) {
        return new EmptyString();
    }

    private static ParsedRegex visitRegexStringNode(Node n, String inheritance, CompilerLogger logger) {
        return ParsedRegex.simpleStringRegex(n.getTextContent());
    }

    private static ParsedRegex visitRegexConcatNode(Node n, String inheritance, CompilerLogger logger) throws CopperException {
        LinkedList<ParsedRegex> subexps = new LinkedList<ParsedRegex>();
        for (int i = 0; i < n.getChildNodes().getLength(); ++i) {
            ParsedRegex pr = XMLGrammarParser.visitRegexInteriorNode(n.getChildNodes().item(i), inheritance, logger);
            if (pr == null) continue;
            subexps.add(pr);
        }
        ParsedRegex[] subexpsA = new ParsedRegex[subexps.size()];
        int i = 0;
        for (ParsedRegex se : subexps) {
            subexpsA[i++] = se;
        }
        return new Concatenation(subexpsA);
    }

    private static ParsedRegex visitRegexChoiceNode(Node n, String inheritance, CompilerLogger logger) throws CopperException {
        LinkedList<ParsedRegex> subexps = new LinkedList<ParsedRegex>();
        for (int i = 0; i < n.getChildNodes().getLength(); ++i) {
            ParsedRegex pr = XMLGrammarParser.visitRegexInteriorNode(n.getChildNodes().item(i), inheritance, logger);
            if (pr == null) continue;
            subexps.add(pr);
        }
        ParsedRegex[] subexpsA = new ParsedRegex[subexps.size()];
        int i = 0;
        for (ParsedRegex se : subexps) {
            subexpsA[i++] = se;
        }
        return new Choice(subexpsA);
    }

    private static ParsedRegex visitRegexCharsetNode(Node n, String inheritance, CompilerLogger logger) throws CopperException {
        CharacterSet union;
        LinkedList<CharacterSet> constituents = new LinkedList<CharacterSet>();
        for (int i = 0; i < n.getChildNodes().getLength(); ++i) {
            CharacterSet pr = XMLGrammarParser.visitRegexInteriorCharsetNode(n.getChildNodes().item(i), inheritance, logger);
            if (pr == null) continue;
            constituents.add(pr);
        }
        if (constituents.size() == 0) {
            if (logger.isLoggable(CompilerLogMessageSort.ERROR)) {
                logger.logErrorMessage(CompilerLogMessageSort.ERROR, null, "Empty character set");
            }
            return null;
        }
        if (constituents.size() == 1) {
            union = (CharacterSet)constituents.getFirst();
        } else {
            union = CharacterSet.instantiate(0, new char[0]);
            for (CharacterSet cs : constituents) {
                union = CharacterSet.union(union, cs);
            }
        }
        if (n.hasAttributes() && n.getAttributes().getNamedItem("invert") != null) {
            union = union.invertSet();
        }
        return union;
    }

    private static CharacterSet visitRegexInteriorCharsetNode(Node n, String inheritance, CompilerLogger logger) throws CopperException {
        if (n.getNodeName().equals("loosechar")) {
            return XMLGrammarParser.visitRegexLooseCharNode(n, inheritance, logger);
        }
        if (n.getNodeName().equals("range")) {
            return XMLGrammarParser.visitRegexCharRangeNode(n, inheritance, logger);
        }
        if (n.getNodeName().startsWith("#")) {
            return null;
        }
        if (logger.isLoggable(CompilerLogMessageSort.ERROR)) {
            logger.logErrorMessage(CompilerLogMessageSort.ERROR, null, "Invalid character set interior node type '" + n.getNodeName() + "'");
        }
        return null;
    }

    private static CharacterSet visitRegexLooseCharNode(Node n, String inheritance, CompilerLogger logger) {
        return CharacterSet.instantiate(0, n.getTextContent().toCharArray());
    }

    private static CharacterSet visitRegexCharRangeNode(Node n, String inheritance, CompilerLogger logger) throws CopperException {
        char lower = '\u0000';
        char upper = '\uffff';
        for (int i = 0; i < n.getChildNodes().getLength(); ++i) {
            if (n.getChildNodes().item(i).getNodeName().equals("lower")) {
                if (lower == '\u0000') {
                    if (n.getChildNodes().item(i).getTextContent().length() == 0) {
                        XMLGrammarParser.formalError(logger, n.getChildNodes().item(i), "missing", "#text", "content");
                    }
                    lower = n.getChildNodes().item(i).getTextContent().charAt(0);
                } else {
                    XMLGrammarParser.formalError(logger, n, "has too many", "lower", "children");
                    return null;
                }
            }
            if (!n.getChildNodes().item(i).getNodeName().equals("upper")) continue;
            if (upper == '\uffff') {
                if (n.getChildNodes().item(i).getTextContent().length() == 0) {
                    XMLGrammarParser.formalError(logger, n.getChildNodes().item(i), "missing", "#text", "content");
                }
                upper = n.getChildNodes().item(i).getTextContent().charAt(0);
                continue;
            }
            XMLGrammarParser.formalError(logger, n, "has too many", "upper", "children");
            return null;
        }
        return CharacterSet.instantiate(1, '+', lower, upper);
    }

    private static ParsedRegex visitRegexWildcardNode(Node n, String inheritance, CompilerLogger logger) {
        return CharacterSet.instantiate(0, '\n').invertSet();
    }
}

