/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.cs.melt.copper.compiletime.builders;

import edu.umn.cs.melt.copper.compiletime.lrdfa.LR0DFA;
import edu.umn.cs.melt.copper.compiletime.lrdfa.LR0ItemSet;
import edu.umn.cs.melt.copper.compiletime.lrdfa.LRLookaheadAndLayoutSets;
import edu.umn.cs.melt.copper.compiletime.mda.MDAResults;
import edu.umn.cs.melt.copper.compiletime.spec.numeric.ContextSets;
import edu.umn.cs.melt.copper.compiletime.spec.numeric.ParserSpec;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.TreeMap;

public class ModularDeterminismAnalyzer {
    private boolean checkILSubsets;
    private ParserSpec hostSpec;
    private ParserSpec fullSpec;
    private ContextSets hostContextSets;
    private ContextSets fullContextSets;
    private LR0DFA hostDFA;
    private LR0DFA fullDFA;
    private LRLookaheadAndLayoutSets hostLookaheadSets;
    private LRLookaheadAndLayoutSets fullLookaheadSets;

    public static MDAResults build(boolean checkILSubsets, ParserSpec hostSpec, ParserSpec fullSpec, ContextSets hostContextSets, ContextSets fullContextSets, LR0DFA hostDFA, LR0DFA fullDFA, LRLookaheadAndLayoutSets hostLookaheadSets, LRLookaheadAndLayoutSets fullLookaheadSets) {
        return new ModularDeterminismAnalyzer(checkILSubsets, hostSpec, fullSpec, hostContextSets, fullContextSets, hostDFA, fullDFA, hostLookaheadSets, fullLookaheadSets).analyze();
    }

    private ModularDeterminismAnalyzer(boolean checkILSubsets, ParserSpec hostSpec, ParserSpec fullSpec, ContextSets hostContextSets, ContextSets fullContextSets, LR0DFA hostDFA, LR0DFA fullDFA, LRLookaheadAndLayoutSets hostLookaheadSets, LRLookaheadAndLayoutSets fullLookaheadSets) {
        this.checkILSubsets = checkILSubsets;
        this.hostSpec = hostSpec;
        this.fullSpec = fullSpec;
        this.hostContextSets = hostContextSets;
        this.fullContextSets = fullContextSets;
        this.hostDFA = hostDFA;
        this.fullDFA = fullDFA;
        this.hostLookaheadSets = hostLookaheadSets;
        this.fullLookaheadSets = fullLookaheadSets;
    }

    public MDAResults analyze() {
        int statenum;
        ArrayList<Byte> errorTypes = new ArrayList<Byte>();
        ArrayList<BitSet> hostSets = new ArrayList<BitSet>();
        ArrayList<BitSet> fullSets = new ArrayList<BitSet>();
        ArrayList<Integer> hostStates = new ArrayList<Integer>();
        ArrayList<Integer> fullStates = new ArrayList<Integer>();
        ArrayList<BitSet> locations = new ArrayList<BitSet>();
        TreeMap<Integer, Integer> hostStatePartition = new TreeMap<Integer, Integer>();
        BitSet extensionStatePartition = new BitSet();
        BitSet newHostStatePartition = new BitSet();
        BitSet spillage = new BitSet();
        BitSet ntsWithFollowSpillage = new BitSet();
        int nt = this.hostSpec.nonterminals.nextSetBit(0);
        while (nt >= 0) {
            spillage.clear();
            spillage.or(this.fullContextSets.getFollow(nt));
            spillage.andNot(this.hostContextSets.getFollow(nt));
            spillage.andNot(this.fullSpec.bridgeConstructs);
            if (!spillage.isEmpty()) {
                ntsWithFollowSpillage.set(nt);
                errorTypes.add((byte)2);
                hostSets.add(this.hostContextSets.getFollow(nt));
                BitSet fullSetWithoutBridgeConstructs = new BitSet();
                fullSetWithoutBridgeConstructs.or(this.fullContextSets.getFollow(nt));
                fullSetWithoutBridgeConstructs.andNot(this.fullSpec.bridgeConstructs);
                fullSets.add(fullSetWithoutBridgeConstructs);
                hostStates.add(nt);
                fullStates.add(nt);
                locations.add(new BitSet());
            }
            nt = this.hostSpec.nonterminals.nextSetBit(nt + 1);
        }
        BitSet encounteredStates = new BitSet();
        LinkedList<Integer> fringe = new LinkedList<Integer>();
        hostStatePartition.put(1, 1);
        fringe.offer(1);
        while (!fringe.isEmpty()) {
            int statenum2 = (Integer)fringe.poll();
            int hostStatenum = (Integer)hostStatePartition.get(statenum2);
            encounteredStates.set(statenum2);
            int X = this.hostDFA.getTransitionLabels(hostStatenum).nextSetBit(0);
            while (X >= 0) {
                int J = this.hostDFA.getTransition(hostStatenum, X);
                int JPrime = this.fullDFA.getTransition(statenum2, X);
                hostStatePartition.put(JPrime, J);
                if (!encounteredStates.get(JPrime)) {
                    fringe.offer(JPrime);
                }
                X = this.hostDFA.getTransitionLabels(hostStatenum).nextSetBit(X + 1);
            }
        }
        Iterator statenum2 = hostStatePartition.keySet().iterator();
        while (statenum2.hasNext()) {
            statenum = (Integer)statenum2.next();
            int hostStatenum = (Integer)hostStatePartition.get(statenum);
            LR0ItemSet hostItems = this.hostDFA.getItemSet(hostStatenum);
            LR0ItemSet fullItems = this.fullDFA.getItemSet(statenum);
            int hostItemCounter = 0;
            int fullItemCounter = 0;
            while (hostItemCounter < hostItems.size()) {
                while (fullItemCounter < fullItems.size() && fullItems.getProduction(fullItemCounter) != hostItems.getProduction(hostItemCounter) || fullItems.getPosition(fullItemCounter) != hostItems.getPosition(hostItemCounter)) {
                    if (!this.fullSpec.bridgeConstructs.get(fullItems.getProduction(fullItemCounter))) {
                        System.err.println("Non-bridge-production syntax addition in host state " + statenum + ", item " + fullItemCounter + " -- bug in MDA");
                    }
                    ++fullItemCounter;
                }
                spillage.clear();
                spillage.or(this.fullLookaheadSets.getLookahead(statenum, fullItemCounter));
                spillage.andNot(this.hostLookaheadSets.getLookahead(hostStatenum, hostItemCounter));
                spillage.andNot(this.fullSpec.bridgeConstructs);
                if (!spillage.isEmpty()) {
                    if (!ntsWithFollowSpillage.get(this.hostSpec.pr.getLHS(hostItems.getProduction(hostItemCounter)))) {
                        errorTypes.add((byte)0);
                    } else {
                        errorTypes.add((byte)1);
                    }
                    hostSets.add(this.hostLookaheadSets.getLookahead(hostStatenum, hostItemCounter));
                    BitSet fullSetWithoutBridgeConstructs = new BitSet();
                    fullSetWithoutBridgeConstructs.or(this.fullLookaheadSets.getLookahead(statenum, fullItemCounter));
                    fullSetWithoutBridgeConstructs.andNot(this.fullSpec.bridgeConstructs);
                    fullSets.add(fullSetWithoutBridgeConstructs);
                    hostStates.add(hostStatenum);
                    fullStates.add(statenum);
                    locations.add(new BitSet());
                    ((BitSet)locations.get(locations.size() - 1)).set(fullItemCounter);
                }
                ++hostItemCounter;
                ++fullItemCounter;
            }
            while (fullItemCounter < fullItems.size()) {
                if (!this.fullSpec.bridgeConstructs.get(fullItems.getProduction(fullItemCounter))) {
                    System.err.println("Non-bridge-production syntax addition in host state " + statenum + ", item " + fullItemCounter + " -- bug in MDA");
                }
                ++fullItemCounter;
            }
        }
        BitSet extAndNewHostStates = new BitSet();
        extAndNewHostStates.set(1, this.fullDFA.size());
        extAndNewHostStates.andNot(encounteredStates);
        statenum = extAndNewHostStates.nextSetBit(0);
        while (statenum >= 0) {
            LR0ItemSet state = this.fullDFA.getItemSet(statenum);
            for (int item = 0; item < state.size(); ++item) {
                if (this.isHostOwned(state.getProduction(item)) || this.fullSpec.bridgeConstructs.get(state.getProduction(item)) && state.getPosition(item) == 0) continue;
                extensionStatePartition.set(statenum);
                break;
            }
            if (!extensionStatePartition.get(statenum)) {
                newHostStatePartition.set(statenum);
            }
            statenum = extAndNewHostStates.nextSetBit(statenum + 1);
        }
        if (this.checkILSubsets) {
            TreeMap<Integer, Integer> itemMap = new TreeMap<Integer, Integer>();
            int statenum3 = newHostStatePartition.nextSetBit(0);
            while (statenum3 >= 0) {
                boolean isISubset = false;
                Iterator fullItems = hostStatePartition.values().iterator();
                block10: while (fullItems.hasNext()) {
                    int possibleSuperset = (Integer)fullItems.next();
                    if (!this.isISubset(statenum3, possibleSuperset, itemMap)) continue;
                    isISubset = true;
                    for (int fullItem : itemMap.keySet()) {
                        int hostItem = itemMap.get(fullItem);
                        spillage.clear();
                        spillage.or(this.hostLookaheadSets.getLookahead(possibleSuperset, hostItem));
                        spillage.andNot(this.fullLookaheadSets.getLookahead(statenum3, fullItem));
                        if (spillage.isEmpty()) continue;
                        errorTypes.add((byte)4);
                        hostSets.add(new BitSet());
                        fullSets.add(new BitSet());
                        hostStates.add(-1);
                        fullStates.add(statenum3);
                        locations.add(new BitSet());
                        ((BitSet)locations.get(locations.size() - 1)).set(possibleSuperset);
                        continue block10;
                    }
                }
                if (!isISubset) {
                    errorTypes.add((byte)3);
                    hostSets.add(new BitSet());
                    fullSets.add(new BitSet());
                    hostStates.add(-1);
                    fullStates.add(statenum3);
                    locations.add(new BitSet());
                }
                statenum3 = newHostStatePartition.nextSetBit(statenum3 + 1);
            }
        }
        byte[] errorTypesA = new byte[errorTypes.size()];
        for (int i = 0; i < errorTypes.size(); ++i) {
            errorTypesA[i] = (Byte)errorTypes.get(i);
        }
        BitSet[] hostSetsA = new BitSet[hostSets.size()];
        hostSets.toArray(hostSetsA);
        BitSet[] fullSetsA = new BitSet[fullSets.size()];
        fullSets.toArray(fullSetsA);
        int[] hostStatesA = new int[hostStates.size()];
        for (int i = 0; i < hostStates.size(); ++i) {
            hostStatesA[i] = (Integer)hostStates.get(i);
        }
        int[] fullStatesA = new int[fullStates.size()];
        for (int i = 0; i < fullStates.size(); ++i) {
            fullStatesA[i] = (Integer)fullStates.get(i);
        }
        BitSet[] locationsA = new BitSet[locations.size()];
        locations.toArray(locationsA);
        MDAResults rv = new MDAResults(errorTypesA, hostSetsA, fullSetsA, hostStatesA, fullStatesA, locationsA, hostStatePartition, encounteredStates, extensionStatePartition, newHostStatePartition);
        return rv;
    }

    private boolean isHostOwned(int element) {
        return this.fullSpec.owners[element] == this.fullSpec.owners[this.fullSpec.pr.getRHSSym(this.fullSpec.getStartProduction(), 0)];
    }

    private boolean isISubset(int subset, int superset, TreeMap<Integer, Integer> itemMap) {
        LR0ItemSet hostItems = this.hostDFA.getItemSet(superset);
        LR0ItemSet fullItems = this.fullDFA.getItemSet(subset);
        int hostItemCounter = 0;
        itemMap.clear();
        for (int fullItemCounter = 0; fullItemCounter < fullItems.size(); ++fullItemCounter) {
            while (hostItemCounter < hostItems.size() && (hostItems.getProduction(hostItemCounter) != fullItems.getProduction(fullItemCounter) || hostItems.getPosition(hostItemCounter) != fullItems.getPosition(fullItemCounter))) {
                ++hostItemCounter;
            }
            if (hostItemCounter == hostItems.size() || fullItems.size() - fullItemCounter > hostItems.size() - hostItemCounter) {
                return false;
            }
            itemMap.put(fullItemCounter, hostItemCounter);
            ++hostItemCounter;
        }
        return true;
    }
}

