/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.cs.melt.copper.main;

import java.util.Hashtable;
import java.util.Set;
import java.util.TreeSet;

public enum CopperDumpType {
    PLAIN{

        @Override
        String usageMessage() {
            return "A plain-text format similar to JavaCUP's.";
        }
    }
    ,
    XML{

        @Override
        String usageMessage() {
            return "XML format.";
        }
    }
    ,
    HTML{

        @Override
        String usageMessage() {
            return "An HTML-based format with all references to grammar\n\t\t  and parse table elements hyperlinked.";
        }
    }
    ,
    XML_SPEC{

        @Override
        String usageMessage() {
            return "A reproduction of the grammar specification in\n\t\t  Copper's XML skin (intended primarily as a method of\n\t\t  translating grammars from other skins).";
        }
    };

    private static Hashtable<String, CopperDumpType> fromStringTable;

    static void initTable() {
        if (fromStringTable != null) {
            return;
        }
        fromStringTable = new Hashtable();
        fromStringTable.put("plain", PLAIN);
        fromStringTable.put("xml", XML);
        fromStringTable.put("html", HTML);
        fromStringTable.put("xmlspec", XML_SPEC);
    }

    static boolean contains(String s) {
        return fromStringTable.containsKey(s);
    }

    static Set<String> strings() {
        CopperDumpType.initTable();
        return new TreeSet<String>(fromStringTable.keySet());
    }

    static CopperDumpType fromString(String s) {
        return fromStringTable.get(s);
    }

    abstract String usageMessage();

    static {
        fromStringTable = null;
    }
}

