/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.cs.melt.ide.eclipse.property;

import edu.umn.cs.melt.ide.eclipse.property.IPropertyPageTab;
import edu.umn.cs.melt.ide.impl.SVRegistry;
import edu.umn.cs.melt.ide.silver.property.ProjectProperties;
import edu.umn.cs.melt.ide.silver.property.Property;
import edu.umn.cs.melt.ide.silver.property.ui.IPropertyControlsProvider;
import edu.umn.cs.melt.ide.silver.property.ui.PropertyControl;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.PropertyPage;

public class TabCommons
implements IPropertyPageTab {
    private IPropertyControlsProvider provider = SVRegistry.get().getProjectProperties();
    private List<PropertyControl> controls;
    private PropertyPage page;

    @Override
    public void fillInTabItem(Composite panel) {
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        panel.setLayout((Layout)layout);
        ProjectProperties props = this.getProperties();
        if (this.controls == null) {
            this.controls = this.provider.getPropertyControls(panel);
            for (PropertyControl control : this.controls) {
                Control info = control.getInfoControl();
                Control input = control.getInputControl();
                Property p = props.get(control.getKey());
                if (p != null) {
                    control.setValue(p.getSValue());
                }
                info.setLayoutData((Object)new GridData());
                input.setLayoutData((Object)new GridData(768));
            }
        }
    }

    @Override
    public boolean performOk() {
        if (!this.provider.validateAll()) {
            return false;
        }
        ProjectProperties props = this.getProperties();
        if (this.controls != null && props != null) {
            for (PropertyControl control : this.controls) {
                Property p = control.getProperty();
                if (p == null) continue;
                props.set(p);
            }
            IProject project = (IProject)this.page.getElement().getAdapter(IProject.class);
            try {
                project.refreshLocal(1, null);
            }
            catch (CoreException coreException) {}
        }
        return true;
    }

    @Override
    public void performDefaults() {
        ProjectProperties props = this.getProperties();
        if (this.controls != null && props != null) {
            for (PropertyControl control : this.controls) {
                Property p = control.getProperty();
                if (p == null) continue;
                control.setValue(p.getDefault());
            }
        }
    }

    @Override
    public void setPropertyPage(PropertyPage page) {
        this.page = page;
    }

    private ProjectProperties getProperties() {
        IProject project = (IProject)this.page.getElement().getAdapter(IProject.class);
        if (project != null) {
            return ProjectProperties.getPropertyPersister(project.getLocation().toString());
        }
        return null;
    }

    @Override
    public String getName() {
        return "Common";
    }
}

