/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.cs.melt.ide.util;

import common.OriginContext;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public final class ReflectedCall<T> {
    private Method method;

    private static String to_sv_class(String silver_function) {
        int i = silver_function.lastIndexOf(":");
        String before = silver_function.substring(0, i);
        String after = silver_function.substring(i + 1, silver_function.length());
        return String.valueOf(before.replace(":", ".")) + ".P" + after;
    }

    private static Class[] sv_args(int arity) {
        Object[] arg_types = new Class[arity + 1];
        Arrays.fill(arg_types, Object.class);
        arg_types[0] = OriginContext.class;
        return arg_types;
    }

    public ReflectedCall(String silver_function, int arity) throws CoreException {
        this(ReflectedCall.to_sv_class(silver_function), "invoke", ReflectedCall.sv_args(arity));
    }

    public ReflectedCall(String class_name, String method_name, Class[] arg_types) throws CoreException {
        try {
            Class<?> cls = Class.forName(class_name);
            this.method = cls.getMethod(method_name, arg_types);
        }
        catch (ClassNotFoundException e) {
            throw new CoreException((IStatus)new Status(4, "edu.umn.cs.melt.eclipse", "Cannot find " + class_name, (Throwable)e));
        }
        catch (NoSuchMethodException e) {
            throw new CoreException((IStatus)new Status(4, "edu.umn.cs.melt.eclipse", "Cannot find valid invocation for " + method_name, (Throwable)e));
        }
    }

    public T invoke(Object[] args) {
        try {
            return (T)this.method.invoke(null, args);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException("Reflected call failed", e);
        }
    }

    public T invokeOn(Object obj, Object[] args) {
        try {
            return (T)this.method.invoke(obj, args);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException("Reflected call failed", e);
        }
    }

    public static Object newInstance(String class_name) throws CoreException {
        try {
            return Class.forName(class_name).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException e) {
            throw new CoreException((IStatus)new Status(4, "edu.umn.cs.melt.eclipse", "Cannot find " + class_name, (Throwable)e));
        }
        catch (NoSuchMethodException e) {
            throw new CoreException((IStatus)new Status(4, "edu.umn.cs.melt.eclipse", "Cannot find valid invocation for 0-arg constructor", (Throwable)e));
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new CoreException((IStatus)new Status(4, "edu.umn.cs.melt.eclipse", "Cannot invoke constructor", (Throwable)e));
        }
    }
}

