/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.cs.melt.copper.legacy.compiletime.abstractsyntax.regex;

import edu.umn.cs.melt.copper.compiletime.auxiliary.SetOfCharsSyntax;
import edu.umn.cs.melt.copper.compiletime.scannerdfa.GeneralizedNFA;
import edu.umn.cs.melt.copper.legacy.compiletime.abstractsyntax.grammar.GrammarSource;
import edu.umn.cs.melt.copper.legacy.compiletime.abstractsyntax.grammar.Symbol;
import edu.umn.cs.melt.copper.legacy.compiletime.abstractsyntax.regex.ParsedRegex;
import edu.umn.cs.melt.copper.legacy.compiletime.abstractsyntax.regex.ParsedRegexVisitor;
import edu.umn.cs.melt.copper.legacy.compiletime.finiteautomaton.oldnfa.NFA;
import edu.umn.cs.melt.copper.legacy.compiletime.finiteautomaton.oldnfa.NFAState;
import edu.umn.cs.melt.copper.runtime.auxiliary.Pair;
import java.util.BitSet;
import java.util.HashSet;
import java.util.Iterator;

public class Choice
extends ParsedRegex {
    private HashSet<ParsedRegex> subexps;

    public Choice(ParsedRegex ... subexps) {
        this.NFANumber = nextNFANumber++;
        this.subexps = new HashSet();
        for (ParsedRegex pr : subexps) {
            if (pr instanceof Choice) {
                for (ParsedRegex prc : ((Choice)pr).subexps) {
                    this.subexps.add(prc);
                }
                continue;
            }
            this.subexps.add(pr);
        }
    }

    @Override
    public NFA generateAutomaton(Symbol forRegex) {
        NFAState firstState = new NFAState(Symbol.symbol(this.NFANumber + "-1"), null);
        HashSet<NFAState> states = new HashSet<NFAState>();
        states.add(firstState);
        for (ParsedRegex sexp : this.subexps) {
            NFA baseNFA = sexp.generateAutomaton(forRegex);
            states.addAll(baseNFA.getStates());
            firstState.addTransition(Character.valueOf(NFAState.EmptyChar), baseNFA.getStartState());
        }
        NFA rv = new NFA(states, firstState);
        return rv;
    }

    @Override
    public Pair<Integer, BitSet> generateAutomaton(GeneralizedNFA nfa) {
        int newStartState = nfa.addState();
        BitSet accepts = new BitSet();
        for (ParsedRegex sexp : this.subexps) {
            Pair<Integer, BitSet> subs = sexp.generateAutomaton(nfa);
            accepts.or(subs.second());
            nfa.addEpsilonTransition(newStartState, subs.first());
        }
        return Pair.cons(newStartState, accepts);
    }

    @Override
    public HashSet<SetOfCharsSyntax> getTransitionLabels() {
        HashSet<SetOfCharsSyntax> rv = new HashSet<SetOfCharsSyntax>();
        for (ParsedRegex sexp : this.subexps) {
            rv.addAll(sexp.getTransitionLabels());
        }
        return rv;
    }

    @Override
    public Choice fillMacroHoles(GrammarSource fillers) {
        ParsedRegex[] newSubexps = new ParsedRegex[this.subexps.size()];
        int i = 0;
        for (ParsedRegex subexp : this.subexps) {
            newSubexps[i++] = subexp.fillMacroHoles(fillers);
        }
        return new Choice(newSubexps);
    }

    @Override
    public Choice clone() {
        ParsedRegex[] newSubexps = new ParsedRegex[this.subexps.size()];
        int i = 0;
        for (ParsedRegex subexp : this.subexps) {
            newSubexps[i++] = subexp.clone();
        }
        return new Choice(newSubexps);
    }

    public String toString() {
        String rv = "";
        Iterator<ParsedRegex> it = this.subexps.iterator();
        while (it.hasNext()) {
            String part = it.next().toString();
            if (part.length() > 1 && part.charAt(0) != '[') {
                rv = rv + '(';
            }
            rv = rv + part;
            if (part.length() > 1 && part.charAt(0) != '[') {
                rv = rv + ')';
            }
            if (!it.hasNext()) continue;
            rv = rv + '|';
        }
        return rv;
    }

    public Iterable<ParsedRegex> getConstituents() {
        return this.subexps;
    }

    @Override
    public <SYNTYPE, INHTYPE, E extends Exception> SYNTYPE acceptVisitor(ParsedRegexVisitor<SYNTYPE, INHTYPE, E> visitor, INHTYPE inheritance) throws E {
        return visitor.visitChoice(this, inheritance);
    }
}

