/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.cs.melt.copper.compiletime.logging;

import edu.umn.cs.melt.copper.compiletime.logging.CompilerLogHandler;
import edu.umn.cs.melt.copper.compiletime.logging.CompilerLogMessage;
import edu.umn.cs.melt.copper.runtime.logging.CopperException;
import java.io.PrintStream;
import java.util.ArrayList;

public class PrintCompilerLogHandler
implements CompilerLogHandler {
    private PrintStream out;
    private ArrayList<CompilerLogMessage> messageQueue;
    private int marker;

    public PrintCompilerLogHandler(PrintStream out) {
        this.out = out;
        this.messageQueue = new ArrayList();
        this.marker = 0;
    }

    public PrintStream getOut() {
        return this.out;
    }

    @Override
    public void handleMessage(CompilerLogMessage message) {
        this.messageQueue.add(message);
    }

    @Override
    public void handleErrorMessage(CompilerLogMessage message) throws CopperException {
        this.handleMessage(message);
        this.flush();
    }

    @Override
    public void flush() throws CopperException {
        boolean fail = false;
        while (this.marker < this.messageQueue.size()) {
            CompilerLogMessage m = this.messageQueue.get(this.marker);
            if (m.getType() == 6 || m.getType() == 5 || this.marker > 0 && (this.messageQueue.get(this.marker - 1).getType() == 6 || this.messageQueue.get(this.marker - 1).getType() == 5)) {
                this.out.println();
            }
            this.out.println(m);
            if (this.messageQueue.get(this.marker).isFatalError()) {
                fail = true;
            }
            ++this.marker;
        }
        if (fail) {
            throw new CopperException("Error(s) raised in compilation");
        }
    }
}

