/*
 * Decompiled with CFR 0.152.
 */
package zmq;

import zmq.Address;
import zmq.Ctx;
import zmq.FQ;
import zmq.IOThread;
import zmq.LB;
import zmq.Msg;
import zmq.Options;
import zmq.Pipe;
import zmq.SessionBase;
import zmq.SocketBase;

public class Dealer
extends SocketBase {
    private final FQ fq;
    private final LB lb;
    private boolean prefetched = false;
    private Msg prefetched_msg;

    public Dealer(Ctx parent_, int tid_, int sid_) {
        super(parent_, tid_, sid_);
        this.options.type = 5;
        this.fq = new FQ();
        this.lb = new LB();
        this.options.recv_identity = true;
    }

    @Override
    protected void xattach_pipe(Pipe pipe_, boolean icanhasall_) {
        assert (pipe_ != null);
        this.fq.attach(pipe_);
        this.lb.attach(pipe_);
    }

    @Override
    protected boolean xsend(Msg msg_) {
        return this.lb.send(msg_, this.errno);
    }

    @Override
    protected Msg xrecv() {
        return this.xxrecv();
    }

    private Msg xxrecv() {
        Msg msg_ = null;
        if (this.prefetched) {
            msg_ = this.prefetched_msg;
            this.prefetched = false;
            this.prefetched_msg = null;
            return msg_;
        }
        do {
            if ((msg_ = this.fq.recv(this.errno)) != null) continue;
            return null;
        } while ((msg_.flags() & 0x40) != 0);
        return msg_;
    }

    @Override
    protected boolean xhas_in() {
        if (this.prefetched) {
            return true;
        }
        this.prefetched_msg = this.xxrecv();
        if (this.prefetched_msg == null) {
            return false;
        }
        this.prefetched = true;
        return true;
    }

    @Override
    protected boolean xhas_out() {
        return this.lb.has_out();
    }

    @Override
    protected void xread_activated(Pipe pipe_) {
        this.fq.activated(pipe_);
    }

    @Override
    protected void xwrite_activated(Pipe pipe_) {
        this.lb.activated(pipe_);
    }

    @Override
    protected void xterminated(Pipe pipe_) {
        this.fq.terminated(pipe_);
        this.lb.terminated(pipe_);
    }

    public static class DealerSession
    extends SessionBase {
        public DealerSession(IOThread io_thread_, boolean connect_, SocketBase socket_, Options options_, Address addr_) {
            super(io_thread_, connect_, socket_, options_, addr_);
        }
    }
}

