/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.cs.melt.copper.compiletime.checkers;

import edu.umn.cs.melt.copper.compiletime.auxiliary.SetOfCharsSyntax;
import edu.umn.cs.melt.copper.compiletime.logging.CompilerLevel;
import edu.umn.cs.melt.copper.compiletime.logging.CompilerLogger;
import edu.umn.cs.melt.copper.compiletime.logging.messages.MalformedRegexMessage;
import edu.umn.cs.melt.copper.compiletime.logging.messages.NonterminalNonterminalMessage;
import edu.umn.cs.melt.copper.compiletime.logging.messages.UselessNonterminalMessage;
import edu.umn.cs.melt.copper.compiletime.spec.grammarbeans.CharacterSetRegex;
import edu.umn.cs.melt.copper.compiletime.spec.grammarbeans.ChoiceRegex;
import edu.umn.cs.melt.copper.compiletime.spec.grammarbeans.ConcatenationRegex;
import edu.umn.cs.melt.copper.compiletime.spec.grammarbeans.EmptyStringRegex;
import edu.umn.cs.melt.copper.compiletime.spec.grammarbeans.KleeneStarRegex;
import edu.umn.cs.melt.copper.compiletime.spec.grammarbeans.MacroHoleRegex;
import edu.umn.cs.melt.copper.compiletime.spec.grammarbeans.Regex;
import edu.umn.cs.melt.copper.compiletime.spec.grammarbeans.visitors.RegexBeanVisitor;
import edu.umn.cs.melt.copper.compiletime.spec.numeric.GrammarStatistics;
import edu.umn.cs.melt.copper.compiletime.spec.numeric.PSSymbolTable;
import edu.umn.cs.melt.copper.compiletime.spec.numeric.ParserSpec;
import edu.umn.cs.melt.copper.runtime.logging.CopperException;
import java.util.BitSet;

public class GrammarWellFormednessChecker {
    public static boolean check(CompilerLogger logger, GrammarStatistics stats, PSSymbolTable symbolTable, ParserSpec spec, boolean reportUselessWarnings) throws CopperException {
        int p;
        int nt;
        boolean passed = true;
        BitSet encountered = new BitSet();
        BitSet fringe = new BitSet();
        BitSet newFringe = new BitSet();
        BitSet uselessNTs = new BitSet();
        fringe.set(spec.getStartNonterminal());
        while (!fringe.isEmpty()) {
            int fringeNT = fringe.nextSetBit(0);
            while (fringeNT >= 0) {
                if (spec.nt.getProductions(fringeNT).isEmpty()) {
                    uselessNTs.set(fringeNT);
                } else {
                    encountered.set(fringeNT);
                    int p2 = spec.nt.getProductions(fringeNT).nextSetBit(0);
                    while (p2 >= 0) {
                        for (int i = 0; i < spec.pr.getRHSLength(p2); ++i) {
                            int rhsSym = spec.pr.getRHSSym(p2, i);
                            if (!spec.nonterminals.get(rhsSym) || encountered.get(rhsSym)) continue;
                            newFringe.set(rhsSym);
                        }
                        p2 = spec.nt.getProductions(fringeNT).nextSetBit(p2 + 1);
                    }
                }
                fringeNT = fringe.nextSetBit(fringeNT + 1);
            }
            fringe.clear();
            fringe.or(newFringe);
            newFringe.clear();
        }
        BitSet newUseless = new BitSet();
        newUseless.or(spec.nonterminals);
        newUseless.andNot(encountered);
        uselessNTs.or(newUseless);
        int nt2 = uselessNTs.nextSetBit(0);
        while (nt2 >= 0) {
            if (logger.isLoggable(CompilerLevel.REGULAR)) {
                logger.log(new UselessNonterminalMessage(symbolTable.getNonTerminal(nt2)));
            }
            nt2 = uselessNTs.nextSetBit(nt2 + 1);
        }
        stats.uselessNTs = uselessNTs;
        if (!passed) {
            return false;
        }
        boolean setChanged = true;
        fringe.clear();
        fringe.or(spec.nonterminals);
        fringe.andNot(uselessNTs);
        while (setChanged) {
            setChanged = false;
            nt = fringe.nextSetBit(0);
            while (nt >= 0) {
                boolean hasTerminal = false;
                p = spec.nt.getProductions(nt).nextSetBit(0);
                while (p >= 0) {
                    boolean isTerminal = true;
                    for (int i = 0; i < spec.pr.getRHSLength(p); ++i) {
                        int rhsSym = spec.pr.getRHSSym(p, i);
                        if (spec.terminals.get(rhsSym) || uselessNTs.get(rhsSym) || !fringe.get(rhsSym)) continue;
                        isTerminal = false;
                        break;
                    }
                    if (hasTerminal |= isTerminal) break;
                    p = spec.nt.getProductions(nt).nextSetBit(p + 1);
                }
                if (hasTerminal) {
                    fringe.clear(nt);
                    setChanged = true;
                }
                nt = fringe.nextSetBit(nt + 1);
            }
        }
        nt = encountered.nextSetBit(0);
        while (nt >= 0) {
            p = spec.nt.getProductions(nt).nextSetBit(0);
            while (p >= 0) {
                for (int i = 0; i < spec.pr.getRHSLength(p); ++i) {
                    int rhsSym = spec.pr.getRHSSym(p, i);
                    if (!spec.nonterminals.get(rhsSym) || !spec.nt.getProductions(rhsSym).isEmpty()) continue;
                    fringe.set(nt);
                }
                p = spec.nt.getProductions(nt).nextSetBit(p + 1);
            }
            nt = encountered.nextSetBit(nt + 1);
        }
        stats.nonTerminalNTs = fringe;
        nt = fringe.nextSetBit(0);
        while (nt >= 0) {
            passed = false;
            if (nt != spec.getStartNonterminal() && logger.isLoggable(CompilerLevel.QUIET)) {
                logger.log(new NonterminalNonterminalMessage(symbolTable.getNonTerminal(nt)));
            }
            nt = fringe.nextSetBit(nt + 1);
        }
        stats.malformedRegexTerminals = new BitSet();
        int t = spec.terminals.nextSetBit(0);
        while (t >= 0) {
            boolean regexPassed;
            Regex r = spec.t.getRegex(t);
            if (r != null && !(regexPassed = r.acceptVisitor(new RegexBeanVisitor<Boolean, CopperException>(){

                @Override
                public Boolean visitChoiceRegex(ChoiceRegex bean) throws CopperException {
                    boolean passed = true;
                    for (Regex subexp : bean.getSubexps()) {
                        passed &= subexp.acceptVisitor(this).booleanValue();
                    }
                    return passed;
                }

                @Override
                public Boolean visitConcatenationRegex(ConcatenationRegex bean) throws CopperException {
                    boolean passed = true;
                    for (Regex subexp : bean.getSubexps()) {
                        passed &= subexp.acceptVisitor(this).booleanValue();
                    }
                    return passed;
                }

                @Override
                public Boolean visitKleeneStarRegex(KleeneStarRegex bean) throws CopperException {
                    return bean.getSubexp().acceptVisitor(this);
                }

                @Override
                public Boolean visitEmptyStringRegex(EmptyStringRegex bean) throws CopperException {
                    return true;
                }

                @Override
                public Boolean visitCharacterSetRegex(CharacterSetRegex bean, SetOfCharsSyntax chars) throws CopperException {
                    return bean.isComplete();
                }

                @Override
                public Boolean visitMacroHoleRegex(MacroHoleRegex bean) throws CopperException {
                    throw new UnsupportedOperationException("Undefined macro '" + bean.getMacroName() + "'");
                }
            }).booleanValue())) {
                stats.malformedRegexTerminals.set(t);
                spec.t.setRegex(t, new ChoiceRegex());
                if (logger.isLoggable(CompilerLevel.QUIET)) {
                    logger.log(new MalformedRegexMessage(symbolTable.getTerminal(t)));
                }
                passed = false;
            }
            t = spec.terminals.nextSetBit(t + 1);
        }
        return passed;
    }
}

