/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.cs.melt.copper.compiletime.checkers;

import edu.umn.cs.melt.copper.compiletime.auxiliary.SymbolTable;
import edu.umn.cs.melt.copper.compiletime.logging.CompilerLevel;
import edu.umn.cs.melt.copper.compiletime.logging.CompilerLogger;
import edu.umn.cs.melt.copper.compiletime.logging.messages.CyclicPrecedenceRelationMessage;
import edu.umn.cs.melt.copper.compiletime.scannerdfa.SingleScannerDFAAnnotations;
import edu.umn.cs.melt.copper.compiletime.spec.grammarbeans.CopperASTBean;
import edu.umn.cs.melt.copper.runtime.logging.CopperException;
import java.util.BitSet;

public class PrecedenceCycleChecker {
    private CompilerLogger logger;
    private SymbolTable<CopperASTBean> symbolTable;
    private SingleScannerDFAAnnotations scannerDFAAnnotations;

    private PrecedenceCycleChecker(CompilerLogger logger, SymbolTable<CopperASTBean> symbolTable, SingleScannerDFAAnnotations scannerDFAAnnotations) {
        this.logger = logger;
        this.symbolTable = symbolTable;
        this.scannerDFAAnnotations = scannerDFAAnnotations;
    }

    public static boolean check(CompilerLogger logger, SymbolTable<CopperASTBean> symbolTable, SingleScannerDFAAnnotations scannerDFAAnnotations) throws CopperException {
        return new PrecedenceCycleChecker(logger, symbolTable, scannerDFAAnnotations).checkCycles();
    }

    private boolean checkCycles() throws CopperException {
        if (this.logger.isLoggable(CompilerLevel.QUIET)) {
            for (BitSet bs : this.scannerDFAAnnotations.circularDependencies) {
                this.logger.log(new CyclicPrecedenceRelationMessage(this.symbolTable, bs));
            }
        }
        return this.scannerDFAAnnotations.circularDependencies.length == 0;
    }
}

