/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.cs.melt.copper.legacy.compiletime.engines.lalr;

import edu.umn.cs.melt.copper.legacy.compiletime.parsetree.plain.ParseTree;
import edu.umn.cs.melt.copper.legacy.compiletime.parsetree.plain.ParseTreeNode;
import edu.umn.cs.melt.copper.legacy.compiletime.parsetree.plain.ParseTreeProdNode;
import edu.umn.cs.melt.copper.legacy.compiletime.parsetree.plain.ParseTreeTermNode;
import edu.umn.cs.melt.copper.legacy.compiletime.parsetree.plain.ParseTreeVisitor;
import edu.umn.cs.melt.copper.runtime.auxiliary.internal.QuotedStringFormatter;
import edu.umn.cs.melt.copper.runtime.logging.CopperParserException;
import java.io.PrintStream;

public class LALRParseTreePrettyPrinter
implements ParseTreeVisitor<String, Object, CopperParserException> {
    private int depthPad = 0;
    private PrintStream out;
    private boolean isPretty;

    public static String run(boolean isPretty, ParseTree parseTree, PrintStream out) throws CopperParserException {
        return parseTree.getRoot().acceptVisitor(new LALRParseTreePrettyPrinter(isPretty, out), null);
    }

    public LALRParseTreePrettyPrinter(boolean isPretty, PrintStream out) {
        this.isPretty = isPretty;
        this.out = out;
    }

    @Override
    public String visitTermNode(ParseTreeTermNode node, Object inheritance) throws CopperParserException {
        if (this.isPretty) {
            for (int i = 0; i < this.depthPad; ++i) {
                this.out.print(' ');
            }
            this.out.print("( ");
            this.out.print(node.getToken().getId());
            this.out.print(" \"");
            this.out.print(QuotedStringFormatter.formatOutputLexeme(node.getToken().getLexeme()));
            this.out.print("\" \"");
            this.out.print(QuotedStringFormatter.formatOutputLexeme(node.getVirtualLocation().toString()));
            this.out.print("\" )");
        } else {
            this.out.print("(Bridge_TERMINAL1 \"");
            this.out.print(QuotedStringFormatter.formatOutputLexeme(node.getToken().getLexeme()));
            this.out.print("\" ");
            this.out.print(QuotedStringFormatter.formatOutputLexeme(String.valueOf(node.getVirtualLocation().getLine())));
            this.out.print(" ");
            this.out.print(QuotedStringFormatter.formatOutputLexeme(String.valueOf(node.getVirtualLocation().getColumn())));
            this.out.print(")");
        }
        return null;
    }

    @Override
    public String visitProdNode(ParseTreeProdNode node, Object inheritance) throws CopperParserException {
        if (this.isPretty) {
            int i;
            for (int i2 = 0; i2 < this.depthPad; ++i2) {
                this.out.print(' ');
            }
            this.out.print("( ");
            this.out.print(node.getProd().getName());
            this.out.print("\n");
            ParseTreeNode[] children = node.getChildren();
            ++this.depthPad;
            for (i = 0; i < children.length; ++i) {
                children[i].acceptVisitor(this, null);
                this.out.print('\n');
            }
            --this.depthPad;
            for (i = 0; i < this.depthPad; ++i) {
                this.out.print(' ');
            }
            this.out.print(")");
        } else {
            this.out.print("(");
            this.out.print(node.getProd().getName());
            ParseTreeNode[] children = node.getChildren();
            if (children.length > 0) {
                this.out.print(' ');
            }
            for (int i = 0; i < children.length; ++i) {
                children[i].acceptVisitor(this, null);
                if (i >= children.length - 1) continue;
                this.out.print(' ');
            }
            this.out.print(")");
        }
        return null;
    }
}

