/*
 * Decompiled with CFR 0.152.
 */
package common;

import common.Debug;
import common.DecoratedNode;
import common.FileCoordinate;
import common.OriginContext;
import common.TopNode;
import common.Tracked;
import common.Util;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import silver.core.Alocation;
import silver.core.Init;
import silver.core.NLocation;
import silver.core.NMaybe;
import silver.core.PgetParsedOriginLocation;
import silver.core.Pjust;

public class NodeContextMessage {
    private int numIndex;
    private int translationX;
    private int higherOrderY;
    private String textRepr;
    private String prodName;
    private String filename;
    private FileCoordinate fcStart;
    private FileCoordinate fcEnd;
    private boolean isRedex;
    private boolean isContractum;
    private int contractumOf;
    private boolean isAttributeRoot;
    private int attributeOf;

    public String GetSection0() {
        return Integer.toString(this.numIndex);
    }

    public String GetSection1() {
        String res = "";
        boolean firstSet = false;
        if (this.translationX > 0) {
            res = res + "TRANSLATION-" + this.translationX;
            firstSet = true;
        }
        if (this.higherOrderY > 0) {
            if (firstSet) {
                res = res + " & ";
            }
            res = res + "HIGHER-ORDER-" + this.higherOrderY;
        }
        return res;
    }

    public String GetSection2() {
        return this.textRepr;
    }

    public String GetSection3() {
        String res = "prod: " + this.prodName + "\n" + this.filename + " lines: " + this.fcStart.getRow() + ":" + this.fcStart.getCol() + " -> " + this.fcEnd.getRow() + ":" + this.fcEnd.getCol();
        return res;
    }

    public String GetSection4() {
        String res = "";
        if (this.isRedex) {
            res = res + "*is-redex\n";
        }
        if (this.isContractum) {
            res = res + "*is-contractum of " + this.contractumOf + "\n";
        }
        if (this.isAttributeRoot) {
            res = res + "*is-attribute_root\n";
        }
        return res;
    }

    public NodeContextMessage(DecoratedNode node, int numIndex) {
        this.numIndex = numIndex;
        this.prodName = node.getNode().getName();
        this.fillInRowsAndCols(node);
        this.setLabels(node);
        this.initializeHeaders(node);
        if (this.translationX > 0 || this.higherOrderY > 0 || this.isAttributeRoot || this.isContractum) {
            this.prettyPrint(node);
        } else {
            this.pullFilelines();
        }
    }

    private void initializeHeaders(DecoratedNode node) {
        this.translationX = this.getIsTranslation(node);
        this.higherOrderY = this.getIsAttribute(node);
    }

    private void fillInRowsAndCols(DecoratedNode node) {
        this.fcStart = this.getStartCoordinates(node);
        this.fcEnd = this.getEndCoordinates(node);
        this.filename = this.getFilename(node);
    }

    private void setLabels(DecoratedNode node) {
        this.isRedex = this.getIsRedex(node);
        this.isContractum = this.getIsContractum(node);
        this.isAttributeRoot = this.getIsAttributeRoot(node);
        this.contractumOf = this.numIndex - 1;
        this.attributeOf = this.numIndex - 1;
    }

    private void prettyPrint(DecoratedNode node) {
        this.textRepr = Util.getPrettyPrint(node);
    }

    private void pullFilelines() {
        try (BufferedReader br = new BufferedReader(new FileReader(this.filename));){
            int row;
            int col = 1;
            String res = "";
            for (row = 1; row < this.fcStart.getRow(); ++row) {
                String string = br.readLine();
            }
            while (col < this.fcStart.getCol()) {
                int n = br.read();
                ++col;
            }
            while (row < this.fcEnd.getRow()) {
                res = res + br.readLine();
                res = res + '\n';
                ++row;
            }
            while (col <= this.fcEnd.getCol()) {
                char c = (char)br.read();
                res = res + Character.toString(c);
                ++col;
            }
            br.close();
            this.textRepr = res;
        }
        catch (IOException e) {
            System.out.println("ERROR READING FROM FILE " + this.filename);
            e.printStackTrace();
        }
    }

    public String toString() {
        return this.GetSection0() + "\n" + this.GetSection1() + "\n" + this.GetSection2() + "\n" + this.GetSection3() + "\n" + this.GetSection4();
    }

    public boolean getIsRedex(DecoratedNode dn) {
        if (dn.getNode() == null) {
            return false;
        }
        return dn.getNode().hasForward();
    }

    public boolean getIsContractum(DecoratedNode dn) {
        if (dn.getNode() == null) {
            return false;
        }
        return dn.getForwardParent() != null;
    }

    public DecoratedNode getRedex(DecoratedNode dn) {
        return this.getRedexHelper(dn);
    }

    private DecoratedNode getRedexHelper(DecoratedNode dn) {
        if (dn == null || this.isRoot(dn)) {
            return null;
        }
        if (this.getIsRedex(dn)) {
            return dn;
        }
        return this.getRedexHelper(dn.getParent());
    }

    public DecoratedNode getContractum(DecoratedNode dn) {
        return this.getContractumHelper(dn);
    }

    private DecoratedNode getContractumHelper(DecoratedNode dn) {
        if (dn == null || this.isRoot(dn)) {
            return null;
        }
        if (this.getIsContractum(dn)) {
            return dn;
        }
        return this.getContractumHelper(dn.getParent());
    }

    public String getFilename(DecoratedNode dn) {
        NMaybe maybeLoc;
        if (dn.getNode() == null) {
            return "<top>";
        }
        NLocation loc = null;
        if (dn.getNode() instanceof Alocation) {
            loc = ((Alocation)dn.getNode()).getAnno_silver_core_location();
        } else if (dn.getNode() instanceof Tracked && (maybeLoc = PgetParsedOriginLocation.invoke((OriginContext)OriginContext.FFI_CONTEXT, (Object)dn.getNode())) instanceof Pjust) {
            loc = (NLocation)maybeLoc.getChild(0);
        }
        if (loc != null) {
            String file = loc.synthesized(Init.silver_core_filename__ON__silver_core_Location).toString();
            return file;
        }
        return "<NO-FILE-FOUND>";
    }

    public FileCoordinate getStartCoordinates(DecoratedNode dn) {
        NMaybe maybeLoc;
        if (dn.getNode() == null) {
            return new FileCoordinate(-2, -2);
        }
        NLocation loc = null;
        if (dn.getNode() instanceof Alocation) {
            loc = ((Alocation)dn.getNode()).getAnno_silver_core_location();
        } else if (dn.getNode() instanceof Tracked && (maybeLoc = PgetParsedOriginLocation.invoke((OriginContext)OriginContext.FFI_CONTEXT, (Object)dn.getNode())) instanceof Pjust) {
            loc = (NLocation)maybeLoc.getChild(0);
        }
        if (loc != null) {
            int line = (Integer)loc.synthesized(Init.silver_core_line__ON__silver_core_Location);
            int col = (Integer)loc.synthesized(Init.silver_core_column__ON__silver_core_Location);
            return new FileCoordinate(line, col);
        }
        return new FileCoordinate(-1, -1);
    }

    public FileCoordinate getEndCoordinates(DecoratedNode dn) {
        NMaybe maybeLoc;
        if (dn.getNode() == null) {
            return new FileCoordinate(-2, -2);
        }
        NLocation loc = null;
        if (dn.getNode() instanceof Alocation) {
            loc = ((Alocation)dn.getNode()).getAnno_silver_core_location();
        } else if (dn.getNode() instanceof Tracked && (maybeLoc = PgetParsedOriginLocation.invoke((OriginContext)OriginContext.FFI_CONTEXT, (Object)dn.getNode())) instanceof Pjust) {
            loc = (NLocation)maybeLoc.getChild(0);
        }
        if (loc != null) {
            int line = (Integer)loc.synthesized(Init.silver_core_endLine__ON__silver_core_Location);
            int col = (Integer)loc.synthesized(Init.silver_core_endColumn__ON__silver_core_Location);
            return new FileCoordinate(line, col);
        }
        return new FileCoordinate(-1, -1);
    }

    public boolean isRoot(DecoratedNode dn) {
        return dn.getParent() == null || dn.getParent() instanceof TopNode || dn.getParent().getParent() == null || dn.getParent().getParent() instanceof TopNode;
    }

    public boolean getIsAttributeRoot(DecoratedNode dn) {
        if (dn != null && !this.isRoot(dn)) {
            Map<String, Object> map = Debug.allAttributesThunkMap(dn.getParent());
            Collection<Object> values = map.values();
            for (Object obj : values) {
                if (Util.demand(obj) != dn) continue;
                return true;
            }
        }
        return false;
    }

    public int getIsAttribute(DecoratedNode dn) {
        if (dn == null || this.isRoot(dn)) {
            return 0;
        }
        if (this.getIsAttributeRoot(dn)) {
            return 1 + this.getIsAttribute(dn.getParent());
        }
        return this.getIsAttribute(dn.getParent());
    }

    public int getIsTranslation(DecoratedNode dn) {
        if (dn == null || this.isRoot(dn)) {
            return 0;
        }
        if (this.getIsContractum(dn)) {
            return 1 + this.getIsTranslation(dn.getParent());
        }
        return this.getIsTranslation(dn.getParent());
    }

    public int getTranslationX() {
        return this.translationX;
    }

    public int getHigherOrderY() {
        return this.higherOrderY;
    }

    public String getTextRepr() {
        return this.textRepr;
    }

    public String getProdName() {
        return this.prodName;
    }

    public String getFilenmae() {
        return this.filename;
    }

    public FileCoordinate getFileCoordianteStart() {
        return this.fcStart;
    }

    public FileCoordinate getFileCoordianteEnd() {
        return this.fcEnd;
    }

    public boolean isRedex() {
        return this.isRedex;
    }

    public boolean isContractum() {
        return this.isContractum;
    }

    public int getContractumOf() {
        return this.contractumOf;
    }

    public boolean isAttributeRoot() {
        return this.isAttributeRoot;
    }

    public int getAttributeOf() {
        return this.attributeOf;
    }
}

