/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.cs.melt.ide.wizard;

import edu.umn.cs.melt.ide.imp.builders.Nature;
import edu.umn.cs.melt.ide.impl.SVRegistry;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URI;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;

public class NewProjectWizard
extends Wizard
implements INewWizard,
IExecutableExtension {
    private WizardNewProjectCreationPage page1;
    private IConfigurationElement configElement;

    public NewProjectWizard() {
        this.setWindowTitle(SVRegistry.get().name());
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public void addPages() {
        super.addPages();
        String name = SVRegistry.get().name();
        this.page1 = new WizardNewProjectCreationPage("New " + name + " Project Wizard");
        this.page1.setTitle(String.valueOf(name) + " Project");
        this.page1.setDescription("Create new " + name + " project");
        this.addPage((IWizardPage)this.page1);
    }

    public boolean performFinish() {
        String name = this.page1.getProjectName();
        URI location = null;
        if (!this.page1.useDefaults()) {
            location = this.page1.getLocationURI();
        }
        this.createProject(name, location);
        BasicNewProjectResourceWizard.updatePerspective((IConfigurationElement)this.configElement);
        return true;
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        this.configElement = config;
    }

    private void createProject(String projectName, URI location) {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        if (!project.exists()) {
            URI projectLocation = location;
            IProjectDescription desc = project.getWorkspace().newProjectDescription(project.getName());
            if (location != null && location.equals(ResourcesPlugin.getWorkspace().getRoot().getLocationURI())) {
                projectLocation = null;
            }
            desc.setLocationURI(projectLocation);
            try {
                project.create(desc, null);
                if (!project.isOpen()) {
                    project.open(null);
                }
                project.getFile("project.properties").create((InputStream)new ByteArrayInputStream(SVRegistry.get().getInitialProjectProperties().getBytes()), true, null);
            }
            catch (CoreException e) {
                this.page1.setErrorMessage(e.getMessage());
                e.printStackTrace();
                return;
            }
        }
        try {
            Nature.addToProject(project, SVRegistry.get().getNatureId());
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }
}

