/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.cs.melt.copper.legacy.compiletime.semantics.lalr1;

import edu.umn.cs.melt.copper.legacy.compiletime.abstractsyntax.grammar.GrammarSource;
import edu.umn.cs.melt.copper.legacy.compiletime.abstractsyntax.grammar.GrammarSymbol;
import edu.umn.cs.melt.copper.legacy.compiletime.abstractsyntax.grammar.NonTerminal;
import edu.umn.cs.melt.copper.legacy.compiletime.abstractsyntax.grammar.Production;
import edu.umn.cs.melt.copper.legacy.compiletime.abstractsyntax.grammar.Terminal;
import edu.umn.cs.melt.copper.legacy.compiletime.logging.CompilerLogMessageSort;
import edu.umn.cs.melt.copper.legacy.compiletime.logging.CompilerLogger;
import edu.umn.cs.melt.copper.runtime.logging.CopperException;
import java.util.HashSet;
import java.util.Iterator;

public class WellFormedGrammarChecker {
    public CompilerLogger logger;

    public WellFormedGrammarChecker(CompilerLogger logger) {
        this.logger = logger;
    }

    public boolean checkWellFormedness(GrammarSource grammar, boolean reportUselessWarnings) throws CopperException {
        boolean passed = true;
        HashSet<NonTerminal> encountered = new HashSet<NonTerminal>();
        HashSet<NonTerminal> fringe = new HashSet<NonTerminal>();
        HashSet<NonTerminal> newFringe = new HashSet<NonTerminal>();
        HashSet<NonTerminal> uselessNTs = new HashSet<NonTerminal>();
        fringe.add(grammar.getStartSym());
        while (!fringe.isEmpty()) {
            for (NonTerminal nonTerminal : fringe) {
                this.logger.logTick(16, ".");
                if (grammar.getP(nonTerminal) == null) {
                    uselessNTs.add(nonTerminal);
                    continue;
                }
                if (grammar.getP(nonTerminal).iterator().hasNext()) {
                    encountered.add(nonTerminal);
                }
                for (Production p : grammar.getP(nonTerminal)) {
                    for (GrammarSymbol rhsSym : p.getRight()) {
                        if (!(rhsSym instanceof NonTerminal) || encountered.contains(rhsSym)) continue;
                        newFringe.add((NonTerminal)rhsSym);
                    }
                }
            }
            fringe = newFringe;
            newFringe = new HashSet();
        }
        for (NonTerminal nonTerminal : grammar.getNT()) {
            if (encountered.contains(nonTerminal)) continue;
            uselessNTs.add(nonTerminal);
            CompilerLogMessageSort sort = CompilerLogMessageSort.WARNING;
            if (!reportUselessWarnings) continue;
            if (this.logger.isLoggable(sort)) {
                this.logger.logMessage(sort, null, "Useless nonterminal '" + nonTerminal + "'");
            }
            grammar.setUselessNonterminalCount(grammar.getUselessNonterminalCount() + 1);
        }
        if (!passed) {
            return false;
        }
        boolean setChanged = true;
        fringe.clear();
        for (NonTerminal nt : grammar.getNT()) {
            fringe.add(nt);
        }
        while (setChanged) {
            setChanged = false;
            Iterator iterator = fringe.iterator();
            while (iterator.hasNext()) {
                NonTerminal nt;
                nt = (NonTerminal)iterator.next();
                if (this.logger.isLoggable(CompilerLogMessageSort.TICK)) {
                    this.logger.logTick(16, ".");
                }
                if (uselessNTs.contains(nt)) {
                    iterator.remove();
                    continue;
                }
                boolean hasTerminal = false;
                for (Production p : grammar.getP(nt)) {
                    boolean isTerminal = true;
                    for (GrammarSymbol rhsSym : p.getRight()) {
                        if (rhsSym instanceof Terminal || uselessNTs.contains(rhsSym) || !fringe.contains(rhsSym)) continue;
                        isTerminal = false;
                        break;
                    }
                    if (!(hasTerminal |= isTerminal)) continue;
                    break;
                }
                if (!hasTerminal) continue;
                iterator.remove();
                setChanged = true;
            }
        }
        for (NonTerminal nt : encountered) {
            if (grammar.getP(nt) == null) continue;
            for (Production p : grammar.getP(nt)) {
                for (GrammarSymbol rhsSym : p.getRight()) {
                    if (!(rhsSym instanceof NonTerminal) || grammar.getP(rhsSym) != null) continue;
                    fringe.add(nt);
                }
            }
        }
        for (NonTerminal nt : fringe) {
            passed = false;
            if (!this.logger.isLoggable(CompilerLogMessageSort.ERROR)) continue;
            this.logger.logMessage(CompilerLogMessageSort.ERROR, null, "Nonterminal '" + nt + "' has no terminal derivations");
        }
        if (!passed) {
            return false;
        }
        return passed;
    }
}

