/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.cs.melt.copper.legacy.ant;

import edu.umn.cs.melt.copper.compiletime.logging.CompilerLevel;
import edu.umn.cs.melt.copper.main.CopperDumpControl;
import edu.umn.cs.melt.copper.main.CopperDumpType;
import edu.umn.cs.melt.copper.main.CopperEngineType;
import edu.umn.cs.melt.copper.main.CopperIOType;
import edu.umn.cs.melt.copper.main.CopperSkinType;
import edu.umn.cs.melt.copper.main.ParserCompiler;
import edu.umn.cs.melt.copper.main.ParserCompilerParameters;
import edu.umn.cs.melt.copper.runtime.auxiliary.Pair;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class CopperAntTask
extends Task {
    private String inputLabel = "<stdin>";
    private String outputLabel = "<stdout>";
    private String fullClassName = "";
    private String logFile = null;
    private String dumpFile = null;
    private boolean isDumpOnlyOnError = false;
    private CopperDumpType dumpType = ParserCompiler.getDefaultDumpType();
    private CopperEngineType engine = ParserCompiler.getDefaultEngine();
    private CopperSkinType skin = ParserCompiler.getDefaultSkin();
    private Reader input = null;
    private File outputFile = null;
    private CompilerLevel quietLevel = ParserCompiler.getDefaultQuietLevel();
    private boolean isWarnUselessNTs = true;
    private boolean isDump = false;
    private ParserCompilerParameters params = null;
    private boolean runMDA = false;

    public void execute() throws BuildException {
        this.params = new ParserCompilerParameters();
        int i = this.fullClassName.lastIndexOf(46);
        if (i != -1) {
            this.params.setPackageName(this.fullClassName.substring(0, i));
            this.params.setParserName(this.fullClassName.substring(i + 1));
        } else if (this.fullClassName.length() != 0) {
            this.params.setParserName(this.fullClassName);
        } else {
            this.params.setParserName("");
        }
        if (!this.isDump) {
            this.params.setDump(CopperDumpControl.OFF);
        } else if (this.isDumpOnlyOnError) {
            this.params.setDump(CopperDumpControl.ERROR_ONLY);
        } else {
            this.params.setDump(CopperDumpControl.ON);
        }
        if (this.logFile != null) {
            this.params.setLogFile(new File(this.logFile));
            if (this.dumpFile == null) {
                this.params.setDumpFile(new File(this.logFile));
            }
        }
        if (this.dumpType != null) {
            this.params.setDumpFormat(this.dumpType);
        }
        if (this.dumpFile != null) {
            this.params.setDumpFile(new File(this.dumpFile));
        }
        this.params.setQuietLevel(this.quietLevel);
        if (this.engine != null) {
            this.params.setUseEngine(this.engine);
        }
        if (this.skin != null) {
            this.params.setUseSkin(this.skin);
        }
        this.params.setWarnUselessNTs(this.isWarnUselessNTs);
        this.params.setRunMDA(this.runMDA);
        System.out.println("Compiling: " + this.inputLabel);
        ArrayList<Pair<String, Object>> files = new ArrayList<Pair<String, Object>>();
        files.add(Pair.cons(this.inputLabel, this.input));
        this.params.setInputs(files);
        if (this.outputFile != null) {
            this.params.setOutputType(CopperIOType.FILE);
            this.params.setOutputFile(this.outputFile);
        } else {
            this.params.setOutputType(CopperIOType.STREAM);
            this.params.setOutputStream(System.out);
        }
        int errorlevel = 1;
        try {
            errorlevel = ParserCompiler.compile(this.params);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (errorlevel != 0) {
            throw new BuildException("Error " + errorlevel);
        }
    }

    public String getInputFile() {
        return this.getInputLabel();
    }

    public void setInputFile(String fileName) throws IOException {
        this.setInputLabel(fileName);
        this.setInput(new FileReader(fileName));
    }

    public String getOutputFile() {
        return this.getOutputLabel();
    }

    public void setOutputFile(String fileName) throws IOException {
        this.setOutputLabel(fileName);
        this.outputFile = new File(fileName);
    }

    public String getLogFile() {
        return this.logFile;
    }

    public void setLogFile(String logFile) {
        this.logFile = logFile;
    }

    public String getDumpFile() {
        return this.dumpFile;
    }

    public void setDumpFile(String dumpFile) {
        this.setDump(true);
        this.dumpFile = dumpFile;
    }

    public String getFullClassName() {
        return this.fullClassName;
    }

    public Reader getInput() {
        return this.input;
    }

    public String getInputLabel() {
        return this.inputLabel;
    }

    public String getOutputLabel() {
        return this.outputLabel;
    }

    protected ParserCompilerParameters getParams() {
        return this.params;
    }

    public boolean isCompileQuiet() {
        return this.quietLevel.equals((Object)CompilerLevel.QUIET);
    }

    public boolean isCompileVerbose() {
        return this.quietLevel.equals((Object)CompilerLevel.VERBOSE);
    }

    public boolean isCompileVeryVerbose() {
        return this.quietLevel.equals((Object)CompilerLevel.VERY_VERBOSE);
    }

    public boolean isDump() {
        return this.isDump;
    }

    public CopperEngineType getEngine() {
        return this.engine;
    }

    public CopperSkinType getSkin() {
        return this.skin;
    }

    public void setFullClassName(String fullClassName) {
        this.fullClassName = fullClassName;
    }

    public void setInput(Reader input) {
        this.input = input;
    }

    public void setInputLabel(String inputLabel) {
        this.inputLabel = inputLabel;
    }

    public void setOutputLabel(String outputLabel) {
        this.outputLabel = outputLabel;
    }

    protected void setParams(ParserCompilerParameters params) {
        this.params = params;
    }

    public void setCompileQuiet(boolean isCompileQuiet) {
        this.quietLevel = isCompileQuiet ? CompilerLevel.QUIET : CompilerLevel.REGULAR;
    }

    public void setCompileVerbose(boolean isCompileVerbose) {
        this.quietLevel = isCompileVerbose ? CompilerLevel.VERBOSE : CompilerLevel.REGULAR;
    }

    public void setCompileVeryVerbose(boolean isCompileVerbose) {
        this.quietLevel = isCompileVerbose ? CompilerLevel.VERY_VERBOSE : CompilerLevel.REGULAR;
    }

    public void setDump(boolean isDump) {
        this.isDump = isDump;
    }

    public void setEngine(CopperEngineType engine) {
        this.engine = engine;
    }

    public void setSkin(CopperSkinType skin) {
        this.skin = skin;
    }

    public boolean isWarnUselessNTs() {
        return this.isWarnUselessNTs;
    }

    public void setWarnUselessNTs(boolean isWarnUselessNTs) {
        this.isWarnUselessNTs = isWarnUselessNTs;
    }

    public CopperDumpType getDumpOutputType() {
        return this.dumpType;
    }

    public void setDumpType(CopperDumpType dumpType) {
        this.dumpType = dumpType;
    }

    public boolean isDumpOnlyOnError() {
        return this.isDumpOnlyOnError;
    }

    public void setDumpOnlyOnError(boolean isDumpOnlyOnError) {
        this.isDumpOnlyOnError = isDumpOnlyOnError;
    }

    public boolean isRunMDA() {
        return this.runMDA;
    }

    public void setRunMDA(boolean runMDA) {
        this.runMDA = runMDA;
    }
}

