/*
 * Decompiled with CFR 0.152.
 */
package zmq;

import java.io.IOException;
import java.net.ConnectException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.nio.channels.SocketChannel;
import zmq.Address;
import zmq.IOObject;
import zmq.IOThread;
import zmq.IPollEvents;
import zmq.Options;
import zmq.Own;
import zmq.SessionBase;
import zmq.SocketBase;
import zmq.StreamEngine;
import zmq.Utils;
import zmq.ZError;

public class TcpConnecter
extends Own
implements IPollEvents {
    private static final int reconnect_timer_id = 1;
    private final IOObject io_object;
    private final Address addr;
    private SocketChannel handle;
    private boolean handle_valid;
    private boolean delayed_start;
    private boolean timer_started;
    private SessionBase session;
    private int current_reconnect_ivl;
    private Address address;
    private SocketBase socket;

    public TcpConnecter(IOThread io_thread_, SessionBase session_, Options options_, Address addr_, boolean delayed_start_) {
        super(io_thread_, options_);
        this.io_object = new IOObject(io_thread_);
        this.addr = addr_;
        this.handle = null;
        this.handle_valid = false;
        this.delayed_start = delayed_start_;
        this.timer_started = false;
        this.session = session_;
        this.current_reconnect_ivl = this.options.reconnect_ivl;
        assert (this.addr != null);
        this.address = this.addr;
        this.socket = session_.get_soket();
    }

    @Override
    public void destroy() {
        assert (!this.timer_started);
        assert (!this.handle_valid);
        assert (this.handle == null);
    }

    @Override
    protected void process_plug() {
        this.io_object.set_handler(this);
        if (this.delayed_start) {
            this.add_reconnect_timer();
        } else {
            this.start_connecting();
        }
    }

    @Override
    public void process_term(int linger_) {
        if (this.timer_started) {
            this.io_object.cancel_timer(1);
            this.timer_started = false;
        }
        if (this.handle_valid) {
            this.io_object.rm_fd(this.handle);
            this.handle_valid = false;
        }
        if (this.handle != null) {
            this.close();
        }
        super.process_term(linger_);
    }

    @Override
    public void in_event() {
    }

    @Override
    public void out_event() {
    }

    @Override
    public void accept_event() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void connect_event() {
        boolean err = false;
        SocketChannel fd = null;
        try {
            fd = this.connect();
        }
        catch (ConnectException e) {
            err = true;
        }
        catch (SocketException e) {
            err = true;
        }
        catch (SocketTimeoutException e) {
            err = true;
        }
        catch (IOException e) {
            throw new ZError.IOException(e);
        }
        this.io_object.rm_fd(this.handle);
        this.handle_valid = false;
        if (err) {
            this.close();
            this.add_reconnect_timer();
            return;
        }
        this.handle = null;
        try {
            Utils.tune_tcp_socket(fd);
            Utils.tune_tcp_keepalives(fd, this.options.tcp_keepalive, this.options.tcp_keepalive_cnt, this.options.tcp_keepalive_idle, this.options.tcp_keepalive_intvl);
        }
        catch (SocketException e) {
            throw new RuntimeException(e);
        }
        StreamEngine engine = null;
        try {
            engine = new StreamEngine(fd, this.options, this.address.toString());
        }
        catch (ZError.InstantiationException e) {
            this.socket.event_connect_delayed(this.address.toString(), -1);
            return;
        }
        this.send_attach(this.session, engine);
        this.terminate();
        this.socket.event_connected(this.address.toString(), fd);
    }

    @Override
    public void timer_event(int id_) {
        this.timer_started = false;
        this.start_connecting();
    }

    private void start_connecting() {
        try {
            boolean rc = this.open();
            if (rc) {
                this.io_object.add_fd(this.handle);
                this.handle_valid = true;
                this.io_object.connect_event();
            } else {
                this.io_object.add_fd(this.handle);
                this.handle_valid = true;
                this.io_object.set_pollconnect(this.handle);
                this.socket.event_connect_delayed(this.address.toString(), -1);
            }
        }
        catch (IOException e) {
            if (this.handle != null) {
                this.close();
            }
            this.add_reconnect_timer();
        }
    }

    private void add_reconnect_timer() {
        int rc_ivl = this.get_new_reconnect_ivl();
        this.io_object.add_timer(rc_ivl, 1);
        this.address.resolve();
        this.socket.event_connect_retried(this.address.toString(), rc_ivl);
        this.timer_started = true;
    }

    private int get_new_reconnect_ivl() {
        int this_interval = this.current_reconnect_ivl + Utils.generate_random() % this.options.reconnect_ivl;
        if (this.options.reconnect_ivl_max > 0 && this.options.reconnect_ivl_max > this.options.reconnect_ivl) {
            this.current_reconnect_ivl *= 2;
            if (this.current_reconnect_ivl >= this.options.reconnect_ivl_max) {
                this.current_reconnect_ivl = this.options.reconnect_ivl_max;
            }
        }
        return this_interval;
    }

    private boolean open() throws IOException {
        assert (this.handle == null);
        this.handle = SocketChannel.open();
        Utils.unblock_socket(this.handle);
        boolean rc = this.handle.connect(this.addr.resolved().address());
        return rc;
    }

    private SocketChannel connect() throws IOException {
        boolean finished = this.handle.finishConnect();
        assert (finished);
        SocketChannel ret = this.handle;
        return ret;
    }

    private void close() {
        assert (this.handle != null);
        try {
            this.handle.close();
            this.socket.event_closed(this.address.toString(), this.handle);
        }
        catch (IOException e) {
            this.socket.event_close_failed(this.address.toString(), ZError.exccode(e));
        }
        this.handle = null;
    }
}

