/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.cs.melt.ide.imp.services;

import common.Node;
import common.Terminal;
import edu.umn.cs.melt.copper.runtime.engines.CopperParser;
import edu.umn.cs.melt.copper.runtime.logging.CopperParserException;
import edu.umn.cs.melt.copper.runtime.logging.CopperSyntaxError;
import edu.umn.cs.melt.ide.copper.SourcePositionLocator;
import edu.umn.cs.melt.ide.imp.services.IdeParseResult;
import edu.umn.cs.melt.ide.util.ReflectedCall;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.imp.language.LanguageRegistry;
import org.eclipse.imp.parser.IParseController;
import org.eclipse.imp.parser.ISourcePositionLocator;
import org.eclipse.imp.parser.ParseControllerBase;
import org.eclipse.imp.parser.SimpleAnnotationTypeInfo;
import org.eclipse.imp.services.IAnnotationTypeInfo;
import org.eclipse.imp.services.ILanguageSyntaxProperties;
import org.eclipse.jface.text.IRegion;

public class ParseController
extends ParseControllerBase
implements IExecutableExtension {
    private SimpleAnnotationTypeInfo fSimpleAnnotationTypeInfo;
    private SourcePositionLocator<Node> locator;
    private IdeParseResult<Node> lastSuccess;
    private CopperParser<? extends Node, CopperParserException> parser;
    private ReflectedCall<List<Terminal>> getTokens;
    private ReflectedCall<Object> reset;

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        String language = config.getAttribute("language");
        IConfigurationElement[] iConfigurationElementArray = config.getChildren("copper");
        if (iConfigurationElementArray.length != 0) {
            IConfigurationElement elem = iConfigurationElementArray[0];
            String parser_class_name = elem.getAttribute("class");
            this.parser = (CopperParser)ReflectedCall.newInstance(parser_class_name);
            this.getTokens = new ReflectedCall(parser_class_name, "getTokens", new Class[0]);
            this.reset = new ReflectedCall(parser_class_name, "reset", new Class[0]);
        }
        this.fLanguage = LanguageRegistry.findLanguage((String)language);
        this.fSimpleAnnotationTypeInfo = new SimpleAnnotationTypeInfo();
        this.locator = new SourcePositionLocator((IParseController)this);
    }

    public IAnnotationTypeInfo getAnnotationTypeInfo() {
        return this.fSimpleAnnotationTypeInfo;
    }

    public ISourcePositionLocator getSourcePositionLocator() {
        return this.locator;
    }

    public ILanguageSyntaxProperties getSyntaxProperties() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object parse(String input, IProgressMonitor monitor) {
        try {
            IdeParseResult<Node> result;
            this.lastSuccess = null;
            this.handler.clearMessages();
            StringReader reader = new StringReader(input);
            CopperParser<? extends Node, CopperParserException> copperParser = this.parser;
            synchronized (copperParser) {
                this.reset.invokeOn(this.parser, null);
                result = new IdeParseResult<Node>((Node)this.parser.parse((Reader)reader, this.getPath().toFile().getName()), this.getTokens.invokeOn(this.parser, null));
            }
            this.lastSuccess = result;
            this.fCurrentAst = result.getTree();
            return this.fCurrentAst;
        }
        catch (CopperSyntaxError e) {
            this.handler.handleSimpleMessage(e.getMessage(), (int)e.getRealCharIndex(), (int)e.getRealCharIndex(), e.getVirtualColumn(), e.getVirtualColumn(), e.getVirtualLine(), e.getVirtualLine());
        }
        catch (CopperParserException e) {
            this.handler.handleSimpleMessage(e.getMessage(), 0, 0, 0, 0, 1, 1);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public Iterator getTokenIterator(IRegion region) {
        if (this.lastSuccess == null) {
            return null;
        }
        return this.lastSuccess.getTokenIterator(region);
    }
}

