/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.cs.melt.ide.silver.property;

import common.ConsCell;
import common.StringCatter;
import edu.umn.cs.melt.ide.silver.property.Property;
import ide.PmakeIdeProperty;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class ProjectProperties {
    private String projectPath;
    private Properties properties;
    private Map<String, Property> map;
    private Signature signature;
    private ConsCell cachedSilverValue;

    public static ProjectProperties getPropertyPersister(String projectPath) {
        return new ProjectProperties(projectPath);
    }

    private ProjectProperties(String projectPath) {
        this.projectPath = projectPath;
    }

    public Property get(String key) {
        this.init();
        return this.map.get(key);
    }

    public void set(Property property) {
        this.init();
        String key = String.valueOf(property.getName()) + Property.SPLITTER + Property.Type.getString(property.getType());
        this.properties.setProperty(key, property.getSValue());
        this.persist();
    }

    public Set<Map.Entry<String, Property>> getAll() {
        this.init();
        return this.map.entrySet();
    }

    private File getPropertiesFile() {
        return new File(this.projectPath, "project.properties");
    }

    /*
     * Unable to fully structure code
     */
    private void init() {
        block20: {
            configFile = this.getPropertiesFile();
            if (this.properties != null) {
                newSig = this.createSignature(configFile);
                if (newSig.equals(this.signature)) {
                    return;
                }
                this.signature = newSig;
            }
            this.cachedSilverValue = null;
            fis = null;
            try {
                this.properties = new Properties();
                fis = new FileInputStream(configFile);
                this.properties.load(fis);
            }
            catch (FileNotFoundException v0) {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException v1) {}
                }
                break block20;
            }
            catch (IOException v2) {
                try {
                    ** if (fis == null) goto lbl-1000
                }
                catch (Throwable var3_3) {
                    if (fis != null) {
                        try {
                            fis.close();
                        }
                        catch (IOException v4) {}
                    }
                    throw var3_3;
                }
lbl-1000:
                // 1 sources

                {
                    try {
                        fis.close();
                    }
                    catch (IOException v3) {}
                }
lbl-1000:
                // 2 sources

                {
                    break block20;
                }
            }
            if (fis == null) break block20;
            try {
                fis.close();
            }
            catch (IOException v5) {}
        }
        this.map = new HashMap<String, Property>();
        set = this.properties.entrySet();
        for (Map.Entry<Object, Object> entry : set) {
            key = (String)entry.getKey();
            value = (String)entry.getValue();
            prop = Property.parseProperty(key, value);
            this.map.put(prop.getName(), prop);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void persist() {
        File configFile = this.getPropertiesFile();
        if (configFile == null) {
            return;
        }
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(configFile);
            this.properties.store(fos, null);
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (fos == null) return;
            try {
                fos.close();
                return;
            }
            catch (IOException iOException) {}
            return;
        }
        catch (IOException iOException) {
            try {
                if (fos == null) return;
            }
            catch (Throwable throwable) {
                if (fos == null) throw throwable;
                try {
                    fos.close();
                    throw throwable;
                }
                catch (IOException iOException2) {}
                throw throwable;
            }
            try {
                fos.close();
                return;
            }
            catch (IOException iOException3) {}
            return;
        }
        if (fos == null) return;
        try {
            fos.close();
            return;
        }
        catch (IOException iOException) {}
    }

    private Signature createSignature(File f) {
        return new Signature(f.length(), f.lastModified());
    }

    public ConsCell serializeToSilverType() {
        if (this.cachedSilverValue != null) {
            return this.cachedSilverValue;
        }
        Set<Map.Entry<String, Property>> set = this.getAll();
        ConsCell result = ConsCell.nil;
        for (Map.Entry<String, Property> entry : set) {
            Property prop = entry.getValue();
            PmakeIdeProperty h = new PmakeIdeProperty((Object)new StringCatter(entry.getKey()), (Object)new StringCatter(prop.getType().name()), (Object)new StringCatter(prop.getSValue()));
            result = new ConsCell((Object)h, (Object)result);
        }
        return result;
    }

    private class Signature {
        long size;
        long modified;

        Signature(long size, long modified) {
            this.size = size;
            this.modified = modified;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            Signature other = (Signature)obj;
            if (this.modified != other.modified) {
                return false;
            }
            return this.size == other.size;
        }
    }
}

