/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.cs.melt.ide.copper.coloring;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Display;

public class TextAttributeProvider {
    private static Map<Display, Map<Integer, Color>> map = new HashMap<Display, Map<Integer, Color>>();
    private static final int[][] BUILT_IN_COLORS;

    static {
        int[][] nArrayArray = new int[16][];
        nArrayArray[0] = new int[]{1, 255, 255, 255};
        int[] nArray = new int[4];
        nArray[0] = 2;
        nArrayArray[1] = nArray;
        int[] nArray2 = new int[4];
        nArray2[0] = 3;
        nArray2[1] = 250;
        nArrayArray[2] = nArray2;
        int[] nArray3 = new int[4];
        nArray3[0] = 4;
        nArray3[1] = 128;
        nArrayArray[3] = nArray3;
        int[] nArray4 = new int[4];
        nArray4[0] = 5;
        nArray4[2] = 255;
        nArrayArray[4] = nArray4;
        int[] nArray5 = new int[4];
        nArray5[0] = 6;
        nArray5[2] = 128;
        nArrayArray[5] = nArray5;
        int[] nArray6 = new int[4];
        nArray6[0] = 7;
        nArray6[1] = 255;
        nArray6[2] = 255;
        nArrayArray[6] = nArray6;
        int[] nArray7 = new int[4];
        nArray7[0] = 8;
        nArray7[1] = 128;
        nArray7[2] = 128;
        nArrayArray[7] = nArray7;
        int[] nArray8 = new int[4];
        nArray8[0] = 9;
        nArray8[3] = 255;
        nArrayArray[8] = nArray8;
        int[] nArray9 = new int[4];
        nArray9[0] = 10;
        nArray9[3] = 128;
        nArrayArray[9] = nArray9;
        int[] nArray10 = new int[4];
        nArray10[0] = 11;
        nArray10[1] = 255;
        nArray10[3] = 255;
        nArrayArray[10] = nArray10;
        int[] nArray11 = new int[4];
        nArray11[0] = 12;
        nArray11[1] = 128;
        nArray11[3] = 128;
        nArrayArray[11] = nArray11;
        int[] nArray12 = new int[4];
        nArray12[0] = 13;
        nArray12[2] = 255;
        nArray12[3] = 255;
        nArrayArray[12] = nArray12;
        int[] nArray13 = new int[4];
        nArray13[0] = 14;
        nArray13[2] = 128;
        nArray13[3] = 128;
        nArrayArray[13] = nArray13;
        nArrayArray[14] = new int[]{15, 192, 192, 192};
        nArrayArray[15] = new int[]{16, 128, 128, 128};
        BUILT_IN_COLORS = nArrayArray;
    }

    public static TextAttribute getAttribute(Display display, int r, int g, int b, boolean isBold, boolean isItalic) {
        Color c;
        if (display == null || r < 0 || r > 255 || g < 0 || g > 255 || b < 0 || b > 255) {
            return null;
        }
        int style = 0;
        if (isBold) {
            style |= 1;
        }
        if (isItalic) {
            style |= 2;
        }
        if ((c = TextAttributeProvider.getCachedColor(display, r, g, b)) != null) {
            return new TextAttribute(c, null, style);
        }
        TextAttributeProvider.addColorToCache(display, r, g, b);
        c = TextAttributeProvider.getCachedColor(display, r, g, b);
        return new TextAttribute(c, null, style);
    }

    public void reset() {
        for (Map.Entry<Display, Map<Integer, Color>> dispMap : map.entrySet()) {
            Map<Integer, Color> colorMap = dispMap.getValue();
            for (Map.Entry<Integer, Color> cMap : colorMap.entrySet()) {
                int key = cMap.getKey();
                Color color = cMap.getValue();
                if (this.isBuiltInColor(key)) continue;
                color.dispose();
            }
            colorMap.clear();
        }
        map.clear();
    }

    private static void addColorToCache(Display display, int r, int g, int b) {
        int key;
        Map<Integer, Color> colorMap = map.get(display);
        if (colorMap == null) {
            map.put(display, TextAttributeProvider.createNewColorMap(display));
            colorMap = map.get(display);
        }
        if (!colorMap.containsKey(key = TextAttributeProvider.generateColorKey(r, g, b).intValue())) {
            colorMap.put(key, new Color((Device)display, r, g, b));
        }
    }

    private static Color getCachedColor(Display display, int r, int g, int b) {
        Map<Integer, Color> colorMap = map.get(display);
        if (colorMap == null) {
            map.put(display, TextAttributeProvider.createNewColorMap(display));
            colorMap = map.get(display);
        }
        return colorMap.get(TextAttributeProvider.generateColorKey(r, g, b));
    }

    private static Map<Integer, Color> createNewColorMap(Display display) {
        HashMap<Integer, Color> colorMap = new HashMap<Integer, Color>();
        TextAttributeProvider.initColorMap(colorMap, display);
        return colorMap;
    }

    private static void initColorMap(Map<Integer, Color> map, Display display) {
        int[][] nArray = BUILT_IN_COLORS;
        int n = BUILT_IN_COLORS.length;
        int n2 = 0;
        while (n2 < n) {
            int[] args = nArray[n2];
            map.put(TextAttributeProvider.generateColorKey(args[1], args[2], args[3]), display.getSystemColor(args[0]));
            ++n2;
        }
    }

    private static Integer generateColorKey(int r, int g, int b) {
        return (r << 16) + (g << 8) + b;
    }

    private boolean isBuiltInColor(int key) {
        int[][] nArray = BUILT_IN_COLORS;
        int n = BUILT_IN_COLORS.length;
        int n2 = 0;
        while (n2 < n) {
            int[] bicolor = nArray[n2];
            if (TextAttributeProvider.generateColorKey(bicolor[1], bicolor[2], bicolor[3]) == key) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

