/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.cs.melt.copper.compiletime.auxiliary.counterexample;

import edu.umn.cs.melt.copper.compiletime.auxiliary.counterexample.StateItem;
import edu.umn.cs.melt.copper.compiletime.lrdfa.LR0DFA;
import edu.umn.cs.melt.copper.compiletime.lrdfa.LR0ItemSet;
import edu.umn.cs.melt.copper.compiletime.lrdfa.LRLookaheadSets;
import edu.umn.cs.melt.copper.compiletime.spec.numeric.ParserSpec;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;

public class TransitionFunctionTables {
    protected Hashtable<StateItem, StateItem[]> trans;
    protected Hashtable<StateItem, Set<StateItem>> revTrans;
    protected int[] prevSymbol;

    public TransitionFunctionTables(LR0DFA dfa, ParserSpec spec, LRLookaheadSets lookaheads) {
        this.prevSymbol = new int[dfa.size()];
        this.trans = new Hashtable();
        this.revTrans = new Hashtable();
        for (int i = 0; i < dfa.size(); ++i) {
            LR0ItemSet srcItemSet = dfa.getItemSet(i);
            block1: for (int j = 0; j < srcItemSet.size(); ++j) {
                int srcProduction = srcItemSet.getProduction(j);
                int srcDotPosition = srcItemSet.getPosition(j);
                int expectedDotPosition = srcDotPosition + 1;
                if (srcDotPosition == spec.pr.getRHSLength(srcProduction)) continue;
                int symbolAfterDot = spec.pr.getRHSSym(srcProduction, srcDotPosition);
                int dstState = dfa.getTransition(i, symbolAfterDot);
                this.prevSymbol[dstState] = symbolAfterDot;
                LR0ItemSet dstItemSet = dfa.getItemSet(dstState);
                for (int k = 0; k < dstItemSet.size(); ++k) {
                    if (srcProduction != dstItemSet.getProduction(k) || expectedDotPosition != dstItemSet.getPosition(k)) continue;
                    StateItem srcStateItem = new StateItem(i, srcProduction, srcItemSet.getPosition(j), lookaheads.getLookahead(i, j));
                    StateItem dstStateItem = new StateItem(dstState, dstItemSet.getProduction(k), dstItemSet.getPosition(k), lookaheads.getLookahead(dstState, k));
                    StateItem[] tran = this.trans.get(srcStateItem);
                    if (tran == null) {
                        tran = new StateItem[spec.terminals.size() + spec.nonterminals.size()];
                        this.trans.put(srcStateItem, tran);
                    }
                    tran[symbolAfterDot] = dstStateItem;
                    Set<StateItem> revTran = this.revTrans.get(dstStateItem);
                    if (revTran == null) {
                        revTran = new HashSet<StateItem>();
                        this.revTrans.put(dstStateItem, revTran);
                    }
                    revTran.add(srcStateItem);
                    continue block1;
                }
            }
        }
    }

    public StateItem getTransition(StateItem stateItem, int symbol) {
        return this.trans.get(stateItem)[symbol];
    }

    public Set<StateItem> getReverseTransitions(StateItem stateItem) {
        return this.revTrans.get(stateItem);
    }
}

