/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.cs.melt.copper.compiletime.builders;

import edu.umn.cs.melt.copper.compiletime.lrdfa.LR0DFA;
import edu.umn.cs.melt.copper.compiletime.lrdfa.LRLookaheadAndLayoutSets;
import edu.umn.cs.melt.copper.compiletime.lrdfa.TransparentPrefixes;
import edu.umn.cs.melt.copper.compiletime.parsetable.LRParseTable;
import edu.umn.cs.melt.copper.compiletime.pipeline.StandardSpecCompilerReturnData;
import edu.umn.cs.melt.copper.compiletime.scannerdfa.GeneralizedDFA;
import edu.umn.cs.melt.copper.compiletime.scannerdfa.SingleScannerDFAAnnotations;
import edu.umn.cs.melt.copper.compiletime.spec.numeric.GrammarStatistics;
import edu.umn.cs.melt.copper.compiletime.spec.numeric.PSSymbolTable;
import edu.umn.cs.melt.copper.compiletime.spec.numeric.ParserSpec;
import java.io.Serializable;
import java.util.BitSet;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class HostFragmentData
implements Serializable {
    private static final long serialVersionUID = 8369557919554024105L;
    public PSSymbolTable symbolTable;
    public ParserSpec fullSpec;
    public String packageDecl;
    public String parserName;
    public LRLookaheadAndLayoutSets lookaheadSets;
    public LRParseTable parseTable;
    public GrammarStatistics stats;
    public TransparentPrefixes prefixes;
    public GeneralizedDFA scannerDFA;
    public SingleScannerDFAAnnotations scannerDFAAnnotations;
    public BitSet[] initNTs;
    public Map<Integer, Map<Integer, Set<Integer>>> laSources;

    public HostFragmentData(StandardSpecCompilerReturnData returnData, LR0DFA parserDFA) {
        this.symbolTable = returnData.symbolTable;
        this.fullSpec = returnData.fullSpec;
        this.packageDecl = returnData.packageDecl;
        this.parserName = returnData.parserName;
        this.lookaheadSets = returnData.lookaheadSets;
        this.parseTable = returnData.parseTable;
        this.stats = returnData.stats;
        this.prefixes = returnData.prefixes;
        this.scannerDFA = returnData.scannerDFA;
        this.scannerDFAAnnotations = returnData.scannerDFAAnnotations;
        this.generateMarkingTerminalMetadata(parserDFA);
    }

    private void generateMarkingTerminalMetadata(LR0DFA parserDFA) {
        this.initNTs = new BitSet[parserDFA.size()];
        this.laSources = new TreeMap<Integer, Map<Integer, Set<Integer>>>();
        for (int state = 0; state < parserDFA.size(); ++state) {
            this.initNTs[state] = parserDFA.getInitNTs(state);
            TreeMap stateLASources = new TreeMap();
            int items = parserDFA.getItemSet(state).size();
            for (int item = 0; item < items; ++item) {
                int production = parserDFA.getItemSet(state).getProduction(item);
                if (this.fullSpec.pr.getRHSLength(production) != parserDFA.getItemSet(state).getPosition(item)) continue;
                BitSet sources = this.lookaheadSets.getItemLASources(state, item);
                int nt = sources.nextSetBit(0);
                while (nt >= 0) {
                    if (stateLASources.get(nt) == null) {
                        stateLASources.put(nt, new HashSet());
                    }
                    ((Set)stateLASources.get(nt)).add(production);
                    nt = sources.nextSetBit(nt + 1);
                }
            }
            this.laSources.put(state, stateLASources);
        }
    }
}

