/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.cs.melt.ide.silver.misc;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.console.MessageConsoleStream;

public class ConsoleLoggingStream {
    private MessageConsoleStream infoStream;
    private MessageConsoleStream errorStream;
    static final Display DISPLAY = Display.getDefault();
    private static final int SCREEN_WIDTH = 80;
    private static Color RED;
    private static ConsoleLoggingStream SINGLETON;

    static {
        SINGLETON = null;
    }

    private ConsoleLoggingStream(MessageConsoleStream infoMCStream, MessageConsoleStream errorMCStream) {
        this.infoStream = infoMCStream;
        this.errorStream = errorMCStream;
        DISPLAY.syncExec(new Runnable(){

            @Override
            public void run() {
                ConsoleLoggingStream.this.errorStream.setColor(RED);
            }
        });
    }

    public void info(String message) {
        this.println(this.infoStream, message);
    }

    public void error(String message) {
        this.println(this.errorStream, message);
    }

    private void println(MessageConsoleStream stream, String message) {
        String[] strings;
        String[] stringArray = strings = this.splitString(message);
        int n = strings.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            stream.println(s);
            ++n2;
        }
    }

    private String[] splitString(String message) {
        int length = message.length();
        int block = length / 80;
        int totalMinusRemainder = block * 80;
        int remainderLength = length - totalMinusRemainder;
        char[] chars = message.toCharArray();
        String[] strings = new String[block + 1];
        int offset = 0;
        int i = 0;
        while (i < block) {
            strings[i] = String.copyValueOf(chars, offset, 80);
            ++i;
            offset += 80;
        }
        strings[block] = String.copyValueOf(chars, offset, remainderLength);
        return strings;
    }

    private static void init() {
        DISPLAY.syncExec(new Runnable(){

            @Override
            public void run() {
                RED = DISPLAY.getSystemColor(3);
            }
        });
    }

    public static ConsoleLoggingStream getStream(MessageConsoleStream infoMCStream, MessageConsoleStream errorMCStream) {
        if (SINGLETON == null) {
            ConsoleLoggingStream.init();
            SINGLETON = new ConsoleLoggingStream(infoMCStream, errorMCStream);
        }
        return SINGLETON;
    }
}

