/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.cs.melt.copper.runtime.io;

public class CircleTokenBuffer<E> {
    private static final double defaultTrimFactor = 1.1;
    private static final int defaultInitialCapacity = 20;
    private int head;
    private int tail;
    private Object[] data;

    public CircleTokenBuffer() {
        this(20);
    }

    public CircleTokenBuffer(int initialCapacity) {
        this.data = new Object[initialCapacity];
        this.head = 0;
        this.tail = 0;
    }

    public E poll() {
        if (this.isEmpty()) {
            return null;
        }
        E rv = this.get(0);
        this.poll(1);
        return rv;
    }

    public void poll(int n) {
        if (n > this.size()) {
            throw new ArrayIndexOutOfBoundsException("Not " + n + " elements in this buffer");
        }
        this.head = (this.head + n) % this.data.length;
        if (this.size() <= this.data.length / 2) {
            int newSize = Math.max((int)((double)this.size() * 1.1) + 1, 20);
            Object[] newData = new Object[newSize];
            for (int i = 0; i < this.size(); ++i) {
                newData[i] = this.get(i);
            }
            this.tail = this.size();
            this.head = 0;
            this.data = newData;
        }
    }

    public void offer(E c) {
        if (this.size() + 1 >= this.data.length) {
            Object[] newData = new Object[this.data.length * 2];
            for (int i = 0; i < this.size(); ++i) {
                newData[i] = this.get(i);
            }
            this.tail = this.size();
            this.head = 0;
            this.data = newData;
        }
        this.data[this.tail] = c;
        this.tail = (this.tail + 1) % this.data.length;
    }

    public E get(int index) {
        if (index < 0 || index >= this.size()) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        return (E)this.data[(this.head + index) % this.data.length];
    }

    public int size() {
        return (this.tail - this.head + this.data.length) % this.data.length;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public String toString() {
        String rv = "[";
        for (int i = 0; i < this.size(); ++i) {
            rv = rv + this.get(i);
            if (i >= this.size() - 1) continue;
            rv = rv + ",";
        }
        rv = rv + "]";
        return rv;
    }
}

