/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.cs.melt.copper.compiletime.spec.grammarbeans;

import edu.umn.cs.melt.copper.compiletime.spec.grammarbeans.CopperElementName;
import edu.umn.cs.melt.copper.compiletime.spec.grammarbeans.CopperElementType;
import edu.umn.cs.melt.copper.compiletime.spec.grammarbeans.DisambiguationFunction;
import edu.umn.cs.melt.copper.compiletime.spec.grammarbeans.Grammar;
import edu.umn.cs.melt.copper.compiletime.spec.grammarbeans.Production;
import edu.umn.cs.melt.copper.compiletime.spec.grammarbeans.Terminal;
import edu.umn.cs.melt.copper.compiletime.spec.grammarbeans.visitors.CopperASTBeanVisitor;
import java.util.HashSet;
import java.util.Set;

public class ExtensionGrammar
extends Grammar {
    private static final long serialVersionUID = -6113945522624561641L;
    protected Set<CopperElementName> markingTerminals = new HashSet<CopperElementName>();
    protected Set<CopperElementName> bridgeProductions = new HashSet<CopperElementName>();
    protected Set<CopperElementName> glueDisambiguationFunctions = new HashSet<CopperElementName>();

    public ExtensionGrammar() {
        super(CopperElementType.EXTENSION_GRAMMAR);
    }

    public void fill(Grammar grammar) {
        this.grammarElements = grammar.grammarElements;
        this.grammarLayout = grammar.grammarLayout;
    }

    public Set<CopperElementName> getMarkingTerminals() {
        return this.markingTerminals;
    }

    public Terminal getMarkingTerminal(CopperElementName name) {
        if (!this.markingTerminals.contains(name)) {
            return null;
        }
        return (Terminal)this.grammarElements.get(name);
    }

    public Set<CopperElementName> getBridgeProductions() {
        return this.bridgeProductions;
    }

    public Production getBridgeProduction(CopperElementName name) {
        if (!this.bridgeProductions.contains(name)) {
            return null;
        }
        return (Production)this.grammarElements.get(name);
    }

    public Set<CopperElementName> getGlueDisambiguationFunctions() {
        return this.glueDisambiguationFunctions;
    }

    public DisambiguationFunction getGlueDisambiguationFunctions(CopperElementName name) {
        if (!this.glueDisambiguationFunctions.contains(name)) {
            return null;
        }
        return (DisambiguationFunction)this.grammarElements.get(name);
    }

    public boolean addMarkingTerminal(CopperElementName terminal) {
        return this.markingTerminals.add(terminal);
    }

    public boolean addBridgeProduction(CopperElementName production) {
        return this.bridgeProductions.add(production);
    }

    public boolean addGlueDisambiguationFunction(CopperElementName function) {
        return this.glueDisambiguationFunctions.add(function);
    }

    @Override
    public boolean isComplete() {
        return super.isComplete() && !this.markingTerminals.isEmpty() && !this.bridgeProductions.isEmpty();
    }

    @Override
    public Set<String> whatIsMissing() {
        Set<String> rv = super.whatIsMissing();
        if (this.markingTerminals.isEmpty()) {
            rv.add("markingTerminals");
        }
        if (this.bridgeProductions.isEmpty()) {
            rv.add("bridgeProductions");
        }
        return rv;
    }

    @Override
    public <RT, E extends Exception> RT acceptVisitor(CopperASTBeanVisitor<RT, E> visitor) throws E {
        return visitor.visitExtensionGrammar(this);
    }
}

