/*
 * Decompiled with CFR 0.152.
 */
package common;

import common.AppTypeRep;
import common.FunctionTypeRep;
import common.NodeFactory;
import common.OriginContext;
import common.TypeRep;
import java.util.LinkedList;
import java.util.List;

public class PartialNodeFactory<T>
extends NodeFactory<T> {
    private final int[] indices;
    private final Object[] args;
    private final NodeFactory<? extends T> ref;

    public PartialNodeFactory(int[] indices, Object[] args, NodeFactory<? extends T> ref) {
        this.indices = indices;
        this.args = args;
        this.ref = ref;
    }

    @Override
    public T invoke(OriginContext originCtx, Object[] restargs, Object[] namedArgs) {
        int fullsize = this.args.length + restargs.length;
        Object[] fullargs = new Object[fullsize];
        int argsindex = 0;
        int restargsindex = 0;
        for (int i = 0; i < fullsize; ++i) {
            fullargs[i] = argsindex < this.args.length && this.indices[argsindex] == i ? this.args[argsindex++] : restargs[restargsindex++];
        }
        return this.ref.invoke(originCtx, fullargs, namedArgs);
    }

    @Override
    public final TypeRep getType() {
        LinkedList<TypeRep> typeArgs = new LinkedList<TypeRep>();
        TypeRep a = this.ref.getType();
        while (a instanceof AppTypeRep) {
            typeArgs.add(0, ((AppTypeRep)a).arg);
            a = ((AppTypeRep)a).cons;
        }
        FunctionTypeRep fnType = (FunctionTypeRep)a;
        List params = typeArgs.subList(0, fnType.params);
        List namedParamTypes = typeArgs.subList(fnType.params, fnType.params + fnType.namedParams.length);
        TypeRep resultType = (TypeRep)typeArgs.get(fnType.params + fnType.namedParams.length);
        LinkedList newArgs = new LinkedList();
        int i = 0;
        int j = 0;
        while (j < fnType.params - this.indices.length) {
            if (i < this.indices.length && this.indices[i] == i + j) {
                ++i;
                continue;
            }
            newArgs.add(params.get(i + j));
            ++j;
        }
        newArgs.addAll(namedParamTypes);
        newArgs.add(resultType);
        TypeRep result = new FunctionTypeRep(fnType.params - this.indices.length, fnType.namedParams);
        for (TypeRep arg : newArgs) {
            result = new AppTypeRep(result, arg);
        }
        return result;
    }

    public final String toString() {
        return "partial application of " + this.ref.toString();
    }
}

