/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.cs.melt.copper.compiletime.builders;

import edu.umn.cs.melt.copper.compiletime.lrdfa.LRLookaheadAndLayoutSets;
import edu.umn.cs.melt.copper.compiletime.lrdfa.TransparentPrefixes;
import edu.umn.cs.melt.copper.compiletime.parsetable.LRParseTable;
import edu.umn.cs.melt.copper.compiletime.scannerdfa.LexicalAmbiguities;
import edu.umn.cs.melt.copper.compiletime.scannerdfa.SingleScannerDFAAnnotations;
import edu.umn.cs.melt.copper.compiletime.spec.numeric.ParserSpec;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;

public class LexicalAmbiguitySetBuilder {
    private ParserSpec spec;
    private LRParseTable parseTable;
    private LRLookaheadAndLayoutSets layouts;
    private TransparentPrefixes prefixes;
    private SingleScannerDFAAnnotations scannerDFAAnnotations;

    private LexicalAmbiguitySetBuilder(ParserSpec spec, LRLookaheadAndLayoutSets layouts, LRParseTable parseTable, TransparentPrefixes prefixes, SingleScannerDFAAnnotations scannerDFAAnnotations) {
        this.spec = spec;
        this.layouts = layouts;
        this.parseTable = parseTable;
        this.prefixes = prefixes;
        this.scannerDFAAnnotations = scannerDFAAnnotations;
    }

    public static LexicalAmbiguities build(ParserSpec spec, LRLookaheadAndLayoutSets layouts, LRParseTable parseTable, TransparentPrefixes prefixes, SingleScannerDFAAnnotations scannerDFAAnnotations) {
        return new LexicalAmbiguitySetBuilder(spec, layouts, parseTable, prefixes, scannerDFAAnnotations).buildLexicalAmbiguitySet();
    }

    private LexicalAmbiguities buildLexicalAmbiguitySet() {
        BitSet unresolved = new BitSet();
        Hashtable<BitSet, Integer> regularDisambiguationFunctions = new Hashtable<BitSet, Integer>();
        Hashtable<BitSet, Integer> subsetDisambiguationFunctions = new Hashtable<BitSet, Integer>();
        Hashtable<BitSet, Integer> ambiguities = new Hashtable<BitSet, Integer>();
        ArrayList<BitSet> locations = new ArrayList<BitSet>();
        ArrayList<Integer> resolutions = new ArrayList<Integer>();
        int ambiguityCount = 0;
        int i = this.spec.disambiguationFunctions.nextSetBit(0);
        while (i >= 0) {
            if (this.spec.df.getApplicableToSubsets(i)) {
                subsetDisambiguationFunctions.put(this.spec.df.getMembers(i), i);
            } else {
                regularDisambiguationFunctions.put(this.spec.df.getMembers(i), i);
            }
            i = this.spec.disambiguationFunctions.nextSetBit(i + 1);
        }
        for (int statenum = 0; statenum < this.parseTable.size(); ++statenum) {
            BitSet unitedValidLA = new BitSet(Math.max(this.spec.terminals.length(), this.spec.nonterminals.length()));
            unitedValidLA.or(this.parseTable.getValidLA(statenum));
            unitedValidLA.or(this.layouts.getLayout(statenum));
            unitedValidLA.or(this.prefixes.getPrefixes(statenum));
            unitedValidLA.and(this.spec.terminals);
            for (int i2 = 0; i2 < this.scannerDFAAnnotations.size(); ++i2) {
                BitSet acceptSet = new BitSet(Math.max(this.spec.terminals.length(), this.spec.nonterminals.length()));
                this.disambiguateState(i2, unitedValidLA, acceptSet);
                int disambiguate = -1;
                if (acceptSet.cardinality() > 1) {
                    if (regularDisambiguationFunctions.containsKey(acceptSet)) {
                        disambiguate = (Integer)regularDisambiguationFunctions.get(acceptSet);
                    } else {
                        for (Map.Entry df : subsetDisambiguationFunctions.entrySet()) {
                            BitSet acceptSetCopy = (BitSet)acceptSet.clone();
                            acceptSetCopy.andNot((BitSet)df.getKey());
                            if (acceptSetCopy.cardinality() != 0) continue;
                            disambiguate = (Integer)df.getValue();
                            break;
                        }
                    }
                }
                if (acceptSet.cardinality() > 1 && disambiguate == -1) {
                    boolean allOneReduceAction = true;
                    byte type = -1;
                    int parameter = -1;
                    int t = acceptSet.nextSetBit(0);
                    while (t >= 0) {
                        if (type == -1) {
                            type = this.parseTable.getActionType(statenum, t);
                        }
                        if (parameter == -1) {
                            parameter = this.parseTable.getActionParameter(statenum, t);
                        }
                        if (type == 3 || type != this.parseTable.getActionType(statenum, t) || parameter != this.parseTable.getActionParameter(statenum, t)) {
                            allOneReduceAction = false;
                            break;
                        }
                        t = acceptSet.nextSetBit(t + 1);
                    }
                    if (type != 2) {
                        allOneReduceAction = false;
                    }
                    if (allOneReduceAction) continue;
                    if (!ambiguities.containsKey(acceptSet)) {
                        ambiguities.put(acceptSet, ambiguityCount++);
                        locations.add(new BitSet());
                        resolutions.add(0);
                    }
                    if (ambiguities.get(acceptSet) == null) continue;
                    int ambiguity = (Integer)ambiguities.get(acceptSet);
                    if (!unresolved.get(ambiguity)) {
                        ((BitSet)locations.get(ambiguity)).clear();
                    }
                    unresolved.set(ambiguity);
                    ((BitSet)locations.get(ambiguity)).set(statenum);
                    continue;
                }
                if (acceptSet.isEmpty() || this.scannerDFAAnnotations.getAcceptSet(i2).cardinality() <= 1) continue;
                if (!ambiguities.containsKey(this.scannerDFAAnnotations.getAcceptSet(i2))) {
                    ambiguities.put(this.scannerDFAAnnotations.getAcceptSet(i2), ambiguityCount++);
                    locations.add(new BitSet());
                    if (acceptSet.cardinality() == 1) {
                        resolutions.add(-1);
                    } else {
                        resolutions.add(disambiguate);
                    }
                }
                if (ambiguities.get(this.scannerDFAAnnotations.getAcceptSet(i2)) == null || unresolved.get((Integer)ambiguities.get(this.scannerDFAAnnotations.getAcceptSet(i2)))) continue;
                int ambiguity = (Integer)ambiguities.get(this.scannerDFAAnnotations.getAcceptSet(i2));
                ((BitSet)locations.get(ambiguity)).set(statenum);
            }
        }
        BitSet[] ambiguitiesA = new BitSet[ambiguities.keySet().size()];
        Iterator i2 = ambiguities.keySet().iterator();
        while (i2.hasNext()) {
            BitSet ambiguity;
            ambiguitiesA[((Integer)ambiguities.get((Object)ambiguity)).intValue()] = ambiguity = (BitSet)i2.next();
        }
        BitSet[] locationsA = new BitSet[locations.size()];
        locations.toArray(locationsA);
        int[] resolutionsA = new int[resolutions.size()];
        for (int i3 = 0; i3 < resolutions.size(); ++i3) {
            resolutionsA[i3] = (Integer)resolutions.get(i3);
        }
        return new LexicalAmbiguities(unresolved, ambiguitiesA, locationsA, resolutionsA);
    }

    private void disambiguateState(int scannerState, BitSet unitedValidLA, BitSet finalAcceptSet) {
        finalAcceptSet.or(unitedValidLA);
        finalAcceptSet.and(this.scannerDFAAnnotations.getAcceptSet(scannerState));
    }
}

