/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.cs.melt.copper.legacy.compiletime.auxiliary;

import edu.umn.cs.melt.copper.runtime.auxiliary.Pair;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.TreeSet;

public class CharacterRange
implements Comparable<CharacterRange> {
    Pair<Character, Character> range;
    private static final int BEGINS = 1;
    private static final int ENDS = 2;
    private static final int BOTH = 3;

    public CharacterRange(char singleChar) {
        this.range = Pair.cons(Character.valueOf(singleChar), Character.valueOf(singleChar));
    }

    public CharacterRange(char least, char greatest) {
        this.range = Pair.cons(Character.valueOf(least), Character.valueOf(greatest));
    }

    public char firstChar() {
        return this.range.first().charValue();
    }

    public char charValue() {
        return this.firstChar();
    }

    public char lastChar() {
        return this.range.second().charValue();
    }

    public boolean isInRange(char toTest) {
        return toTest >= this.range.first().charValue() && toTest <= this.range.second().charValue();
    }

    public boolean contains(CharacterRange otherRange) {
        char f1 = this.firstChar();
        char f2 = otherRange.firstChar();
        char l1 = this.lastChar();
        char l2 = otherRange.lastChar();
        return f1 <= l2 && f2 <= l1;
    }

    public boolean isSingleChar() {
        return this.range.first() == this.range.second();
    }

    public boolean equals(Object rhs) {
        if (rhs == null || !(rhs instanceof CharacterRange)) {
            return false;
        }
        return this.range.first() == ((CharacterRange)rhs).range.first() && this.range.second() == ((CharacterRange)rhs).range.second();
    }

    public int hashCode() {
        if (this.isSingleChar()) {
            return this.firstChar();
        }
        return this.range.hashCode();
    }

    @Override
    public int compareTo(CharacterRange rhs) {
        int firstDiff = this.range.first().charValue() - rhs.range.first().charValue();
        if (firstDiff < 0) {
            return firstDiff - 1;
        }
        if (firstDiff > 0) {
            return firstDiff + 1;
        }
        if (this.size() < rhs.size()) {
            return -1;
        }
        if (this.size() > rhs.size()) {
            return 1;
        }
        return 0;
    }

    public int size() {
        return this.range.second().charValue() - this.range.first().charValue();
    }

    public String toString() {
        if (this.isSingleChar()) {
            return "[" + this.range.first() + "]";
        }
        return "[" + this.range.first() + "-" + this.range.second() + "]";
    }

    public static HashSet<CharacterRange> consolidateAdjacentRanges(Iterable<CharacterRange> origSet) {
        TreeSet<CharacterRange> original = new TreeSet<CharacterRange>();
        HashSet<CharacterRange> rv = new HashSet<CharacterRange>();
        for (CharacterRange cr : origSet) {
            original.add(cr);
        }
        CharacterRange current = null;
        for (CharacterRange cr : original) {
            if (current == null) {
                current = cr;
                continue;
            }
            if (cr.contains(current) || current.lastChar() + '\u0001' == cr.firstChar()) {
                current = new CharacterRange((char)Math.min(current.firstChar(), cr.firstChar()), (char)Math.max(current.lastChar(), cr.lastChar()));
                continue;
            }
            rv.add(current);
            current = cr;
        }
        rv.add(current);
        return rv;
    }

    public static Hashtable<CharacterRange, HashSet<CharacterRange>> eliminateOverlaps(Iterable<CharacterRange> origSet) {
        TreeSet<Character> sortedExtrema = new TreeSet<Character>();
        Hashtable<Character, Integer> extremumInfo = new Hashtable<Character, Integer>();
        Hashtable<CharacterRange, HashSet<CharacterRange>> rv = new Hashtable<CharacterRange, HashSet<CharacterRange>>();
        for (CharacterRange cr : origSet) {
            sortedExtrema.add(Character.valueOf(cr.firstChar()));
            sortedExtrema.add(Character.valueOf(cr.lastChar()));
            if (!extremumInfo.containsKey(Character.valueOf(cr.firstChar()))) {
                extremumInfo.put(Character.valueOf(cr.firstChar()), 1);
            } else if ((Integer)extremumInfo.get(Character.valueOf(cr.firstChar())) == 2) {
                extremumInfo.put(Character.valueOf(cr.firstChar()), 3);
            }
            if (!extremumInfo.containsKey(Character.valueOf(cr.lastChar()))) {
                extremumInfo.put(Character.valueOf(cr.lastChar()), 2);
                continue;
            }
            if ((Integer)extremumInfo.get(Character.valueOf(cr.lastChar())) != 1) continue;
            extremumInfo.put(Character.valueOf(cr.lastChar()), 3);
        }
        if (sortedExtrema.isEmpty()) {
            return rv;
        }
        Iterator it = sortedExtrema.iterator();
        char prev = ((Character)it.next()).charValue();
        if ((Integer)extremumInfo.get(Character.valueOf(prev)) == 3) {
            CharacterRange soleChar = new CharacterRange(prev);
            for (CharacterRange cr : origSet) {
                if (!cr.contains(soleChar)) continue;
                if (!rv.containsKey(soleChar)) {
                    rv.put(soleChar, new HashSet());
                }
                rv.get(soleChar).add(cr);
            }
        }
        while (it.hasNext()) {
            char central = ((Character)it.next()).charValue();
            CharacterRange cr0 = null;
            CharacterRange crN = null;
            char prevFirst = (Integer)extremumInfo.get(Character.valueOf(prev)) == 1 ? prev : (char)(prev + '\u0001');
            char prevLast = (Integer)extremumInfo.get(Character.valueOf(central)) == 2 ? central : (char)(central - '\u0001');
            if ((Integer)extremumInfo.get(Character.valueOf(central)) == 3) {
                crN = new CharacterRange(central);
            }
            if (prevFirst <= prevLast) {
                cr0 = new CharacterRange(prevFirst, prevLast);
            }
            for (CharacterRange cr : origSet) {
                if (cr0 != null && cr.contains(cr0)) {
                    if (!rv.containsKey(cr0)) {
                        rv.put(cr0, new HashSet());
                    }
                    rv.get(cr0).add(cr);
                }
                if (crN == null || !cr.contains(crN)) continue;
                if (!rv.containsKey(crN)) {
                    rv.put(crN, new HashSet());
                }
                rv.get(crN).add(cr);
            }
            prev = central;
        }
        return rv;
    }

    public static HashSet<CharacterRange> rangify(char ... characters) {
        HashSet<CharacterRange> rv = new HashSet<CharacterRange>();
        if (characters.length == 0) {
            return rv;
        }
        TreeSet<Character> sortedChars = new TreeSet<Character>();
        for (char c : characters) {
            sortedChars.add(Character.valueOf(c));
        }
        char rangeStartChar = characters[0];
        char previousChar = '\u0000';
        char currentChar = '\u0001';
        Iterator iterator = sortedChars.iterator();
        while (iterator.hasNext()) {
            char c;
            currentChar = c = ((Character)iterator.next()).charValue();
            if (rangeStartChar <= previousChar && previousChar + '\u0001' != currentChar) {
                rv.add(new CharacterRange(rangeStartChar, previousChar));
                rangeStartChar = currentChar;
            }
            previousChar = currentChar;
        }
        rv.add(new CharacterRange(rangeStartChar, currentChar));
        return rv;
    }

    public static HashSet<CharacterRange> rangify(Iterable<Character> characters) {
        HashSet<CharacterRange> rv = new HashSet<CharacterRange>();
        if (!characters.iterator().hasNext()) {
            return rv;
        }
        TreeSet<Character> sortedChars = new TreeSet<Character>();
        for (char c : characters) {
            sortedChars.add(Character.valueOf(c));
        }
        char rangeStartChar = characters.iterator().next().charValue();
        char previousChar = '\u0000';
        char currentChar = '\u0001';
        Iterator iterator = sortedChars.iterator();
        while (iterator.hasNext()) {
            char c;
            currentChar = c = ((Character)iterator.next()).charValue();
            if (rangeStartChar <= previousChar && previousChar + '\u0001' != currentChar) {
                rv.add(new CharacterRange(rangeStartChar, previousChar));
                rangeStartChar = currentChar;
            }
            previousChar = currentChar;
        }
        rv.add(new CharacterRange(rangeStartChar, currentChar));
        return rv;
    }
}

