/*
 * Decompiled with CFR 0.152.
 */
package common;

import common.AppTypeRep;
import common.BaseTypeRep;
import common.ConsCell;
import common.DecoratedNode;
import common.FunctionTypeRep;
import common.Node;
import common.NodeFactory;
import common.OriginContext;
import common.OriginsUtil;
import common.RTTIManager;
import common.StringCatter;
import common.Terminal;
import common.Thunk;
import common.TypeRep;
import common.Typed;
import common.VarTypeRep;
import common.exceptions.ConsReifyTraceException;
import common.exceptions.ReifyTraceException;
import common.exceptions.SilverError;
import common.exceptions.SilverException;
import common.exceptions.SilverInternalError;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import silver.core.NAST;
import silver.core.NASTs;
import silver.core.NEither;
import silver.core.NLocation;
import silver.core.NMaybe;
import silver.core.NNamedAST;
import silver.core.NNamedASTs;
import silver.core.NOriginInfo;
import silver.core.NPair;
import silver.core.PanyAST;
import silver.core.PbooleanAST;
import silver.core.PconsAST;
import silver.core.PconsNamedAST;
import silver.core.PfloatAST;
import silver.core.PintegerAST;
import silver.core.Pjust;
import silver.core.Pleft;
import silver.core.PlistAST;
import silver.core.PnamedAST;
import silver.core.PnilAST;
import silver.core.PnilNamedAST;
import silver.core.PnonterminalAST;
import silver.core.Pnothing;
import silver.core.PoriginOriginInfo;
import silver.core.Pright;
import silver.core.PstringAST;
import silver.core.PterminalAST;

public final class Reflection {
    public static TypeRep getType(Object o) {
        if (o instanceof Integer) {
            return new BaseTypeRep("Integer");
        }
        if (o instanceof Float) {
            return new BaseTypeRep("Float");
        }
        if (o instanceof Boolean) {
            return new BaseTypeRep("Boolean");
        }
        if (o instanceof Typed) {
            return ((Typed)o).getType();
        }
        if (o instanceof Thunk) {
            throw new SilverInternalError("Runtime type of an unevaluated Thunk should never be demanded.");
        }
        throw new SilverError("Runtime type checking of object requires class " + o.getClass().getName() + " to implement Typed.");
    }

    public static NMaybe reflectTypeName(Object o) {
        String result;
        if (o instanceof Integer) {
            result = "Integer";
        } else if (o instanceof Float) {
            result = "Float";
        } else if (o instanceof Boolean) {
            result = "Boolean";
        } else if (o instanceof Typed) {
            result = ((Typed)o).getType().toString();
        } else {
            if (o instanceof Thunk) {
                throw new SilverInternalError("Runtime type of an unevaluated Thunk should never be demanded.");
            }
            return new Pnothing();
        }
        return new Pjust((Object)new StringCatter(result));
    }

    public static NAST reflect(ConsCell rules, Object o) {
        PoriginOriginInfo origin;
        PoriginOriginInfo poriginOriginInfo = origin = rules != null ? new PoriginOriginInfo((Object)OriginsUtil.SET_FROM_REFLECTION_OIT, o, (Object)rules, (Object)true) : null;
        if (o instanceof Node) {
            Node n = (Node)o;
            PnilAST children = new PnilAST((NOriginInfo)origin);
            for (int i = n.getNumberOfChildren() - 1; i >= 0; --i) {
                NAST value = Reflection.reflect(rules, n.getChild(i));
                children = new PconsAST((NOriginInfo)origin, (Object)value, (Object)children);
            }
            String[] annotationNames = n.getAnnoNames();
            PnilNamedAST annotations = new PnilNamedAST((NOriginInfo)origin);
            for (int i = annotationNames.length - 1; i >= 0; --i) {
                String name = annotationNames[i];
                NAST value = Reflection.reflect(rules, n.getAnno(name));
                annotations = new PconsNamedAST((NOriginInfo)origin, (Object)new PnamedAST((NOriginInfo)origin, (Object)new StringCatter(name), (Object)value), (Object)annotations);
            }
            return new PnonterminalAST((NOriginInfo)origin, (Object)new StringCatter(n.getName()), (Object)children, (Object)annotations);
        }
        if (o instanceof Terminal) {
            Terminal t = (Terminal)o;
            return new PterminalAST((NOriginInfo)origin, (Object)new StringCatter(t.getName()), (Object)t.lexeme, (Object)t.location);
        }
        if (o instanceof ConsCell) {
            return new PlistAST((NOriginInfo)origin, (Object)Reflection.reflectList(rules, (NOriginInfo)origin, (ConsCell)o));
        }
        if (o instanceof StringCatter) {
            return new PstringAST((NOriginInfo)origin, (Object)((StringCatter)o));
        }
        if (o instanceof Integer) {
            return new PintegerAST((NOriginInfo)origin, (Object)((Integer)o));
        }
        if (o instanceof Float) {
            return new PfloatAST((NOriginInfo)origin, (Object)((Float)o));
        }
        if (o instanceof Boolean) {
            return new PbooleanAST((NOriginInfo)origin, (Object)((Boolean)o));
        }
        return new PanyAST((NOriginInfo)origin, o);
    }

    private static NASTs reflectList(ConsCell rules, NOriginInfo origin, ConsCell l) {
        if (!l.nil()) {
            return new PconsAST(origin, (Object)Reflection.reflect(rules, l.head()), (Object)Reflection.reflectList(rules, origin, l.tail()));
        }
        return new PnilAST(origin);
    }

    public static NEither reifyChecked(ConsCell rules, TypeRep resultType, NAST ast) {
        try {
            return new Pright(Reflection.reify(rules, resultType, ast));
        }
        catch (SilverException e) {
            Throwable rootCause = SilverException.getRootCause(e);
            if (rootCause instanceof SilverError) {
                return new Pleft((Object)new StringCatter("Reification error at " + ReifyTraceException.getASTRepr(e) + ":\n" + rootCause.getMessage()));
            }
            throw e;
        }
    }

    public static Object reify(ConsCell rules, TypeRep resultType, NAST ast) {
        TypeRep givenType;
        if (ast instanceof PnonterminalAST) {
            String prodName = ((StringCatter)ast.getChild(0)).toString();
            ArrayList<NAST> childASTList = new ArrayList<NAST>(5);
            NASTs current = (NASTs)ast.getChild(1);
            while (!(current instanceof PnilAST)) {
                childASTList.add((NAST)current.getChild(0));
                current = (NASTs)current.getChild(1);
            }
            NAST[] childASTs = childASTList.toArray(new NAST[childASTList.size()]);
            class AnnotationEntry
            implements Comparable<AnnotationEntry> {
                public final String name;
                public final NAST ast;

                public AnnotationEntry(String name, NAST ast) {
                    this.name = name;
                    this.ast = ast;
                }

                @Override
                public int compareTo(AnnotationEntry other) {
                    return this.name.compareTo(other.name);
                }
            }
            ArrayList<AnnotationEntry> annotationASTList = new ArrayList<AnnotationEntry>();
            NNamedASTs current2 = (NNamedASTs)ast.getChild(2);
            while (!(current2 instanceof PnilNamedAST)) {
                NNamedAST item = (NNamedAST)current2.getChild(0);
                annotationASTList.add(new AnnotationEntry(item.getChild(0).toString(), (NAST)item.getChild(1)));
                current2 = (NNamedASTs)current2.getChild(1);
            }
            Collections.sort(annotationASTList);
            String[] annotationNames = new String[annotationASTList.size()];
            NAST[] annotationASTs = new NAST[annotationASTList.size()];
            for (int i = 0; i < annotationASTList.size(); ++i) {
                annotationNames[i] = ((AnnotationEntry)annotationASTList.get((int)i)).name;
                annotationASTs[i] = ((AnnotationEntry)annotationASTList.get((int)i)).ast;
            }
            RTTIManager.Prodleton<?> pton = RTTIManager.getProdleton(prodName);
            if (pton == null) {
                throw new SilverError("Undefined production " + prodName);
            }
            return pton.reify(ast, rules, resultType, childASTs, annotationNames, annotationASTs);
        }
        if (ast instanceof PterminalAST) {
            String terminalName = ((StringCatter)ast.getChild(0)).toString();
            StringCatter lexeme = (StringCatter)ast.getChild(1);
            NLocation location = (NLocation)ast.getChild(2);
            if (!TypeRep.unify(resultType, new BaseTypeRep(terminalName))) {
                throw new SilverError("reify is constructing " + resultType.toString() + ", but found terminal " + terminalName + " AST.");
            }
            RTTIManager.Terminalton<?> tton = RTTIManager.getTerminalton(terminalName);
            if (tton == null) {
                throw new SilverError("Undefined terminal " + terminalName);
            }
            return tton.construct(lexeme, location);
        }
        if (ast instanceof PlistAST) {
            VarTypeRep paramType = new VarTypeRep();
            if (!TypeRep.unify(resultType, new AppTypeRep(new BaseTypeRep("[]"), paramType))) {
                throw new SilverError("reify is constructing " + resultType.toString() + ", but found list AST.");
            }
            return Reflection.reifyList(rules, paramType, (NASTs)ast.getChild(0));
        }
        Object givenObject = ast.getChild(0);
        if (ast instanceof PstringAST) {
            givenType = new BaseTypeRep("String");
        } else if (ast instanceof PintegerAST) {
            givenType = new BaseTypeRep("Integer");
        } else if (ast instanceof PfloatAST) {
            givenType = new BaseTypeRep("Float");
        } else if (ast instanceof PbooleanAST) {
            givenType = new BaseTypeRep("Boolean");
        } else if (ast instanceof PanyAST) {
            givenType = Reflection.getType(givenObject);
        } else {
            throw new SilverInternalError("Unexpected AST production " + ast.getName());
        }
        if (!TypeRep.unify(resultType, givenType)) {
            throw new SilverError("reify is constructing " + resultType.toString() + ", but found " + givenType.toString() + " AST.");
        }
        return givenObject;
    }

    private static ConsCell reifyList(ConsCell rules, TypeRep resultParamType, NASTs asts) {
        if (asts instanceof PconsAST) {
            ConsCell tail;
            Object head;
            try {
                head = Reflection.reify(rules, resultParamType, (NAST)asts.getChild(0));
            }
            catch (SilverException e) {
                throw new ConsReifyTraceException(true, (Throwable)e);
            }
            try {
                tail = Reflection.reifyList(rules, resultParamType, (NASTs)asts.getChild(1));
            }
            catch (SilverException e) {
                throw new ConsReifyTraceException(false, (Throwable)e);
            }
            return new ConsCell(head, tail);
        }
        if (asts instanceof PnilAST) {
            return ConsCell.nil;
        }
        throw new SilverInternalError("Unexpected ASTs production " + asts.getName());
    }

    public static NEither applyAST(OriginContext ctx, NAST fn, ConsCell args, ConsCell namedArgs) {
        if (!(fn instanceof PanyAST) || !(fn.getChild(0) instanceof NodeFactory)) {
            return new Pleft((Object)new StringCatter("Expected a function AST"));
        }
        NodeFactory givenFn = (NodeFactory)fn.getChild(0);
        LinkedList<TypeRep> typeArgs = new LinkedList<TypeRep>();
        TypeRep a = givenFn.getType();
        while (a instanceof AppTypeRep) {
            typeArgs.add(0, ((AppTypeRep)a).arg);
            a = ((AppTypeRep)a).cons;
        }
        FunctionTypeRep fnType = (FunctionTypeRep)a;
        List params = typeArgs.subList(0, fnType.params);
        List namedParamTypes = typeArgs.subList(fnType.params, fnType.params + fnType.namedParams.length);
        ConsCell rules = ctx.rulesAsSilverList();
        ArrayList<Integer> argIndexList = new ArrayList<Integer>(5);
        ArrayList<Object> argList = new ArrayList<Object>(5);
        int i = 0;
        ConsCell current = args;
        while (!current.nil()) {
            if (i >= fnType.params) {
                return new Pleft((Object)new StringCatter("Expected only " + fnType.params + " arguments, but got " + args.length()));
            }
            NMaybe item = (NMaybe)current.head();
            if (item instanceof Pjust) {
                argIndexList.add(i);
                try {
                    argList.add(Reflection.reify(rules, (TypeRep)params.get(i), (NAST)item.getChild(0)));
                }
                catch (SilverException e) {
                    Throwable rootCause = SilverException.getRootCause(e);
                    if (rootCause instanceof SilverError) {
                        return new Pleft((Object)new StringCatter("Reification error in argument " + i + " at " + ReifyTraceException.getASTRepr(e) + ":\n" + rootCause.getMessage()));
                    }
                    throw e;
                }
            }
            ++i;
            current = current.tail();
        }
        if (i < fnType.params) {
            return new Pleft((Object)new StringCatter("Expected " + fnType.params + " arguments, but got only " + i));
        }
        ArrayList<Integer> convertedIndexList = new ArrayList<Integer>();
        ArrayList<Integer> suppliedIndexList = new ArrayList<Integer>();
        ArrayList<Object> namedArgList = new ArrayList<Object>();
        Object[] reorderedNamedArgs = new Object[fnType.namedParams.length];
        ConsCell current2 = namedArgs;
        while (!current2.nil()) {
            NPair entry = (NPair)current2.head();
            String name = entry.getAnno_silver_core_fst().toString();
            int index = Arrays.asList(fnType.namedParams).indexOf(name);
            if (index == -1) {
                return new Pleft((Object)new StringCatter("Unexpected named argument " + name));
            }
            NMaybe item = (NMaybe)entry.getAnno_silver_core_snd();
            if (item instanceof Pjust) {
                Object o;
                try {
                    o = Reflection.reify(rules, (TypeRep)namedParamTypes.get(index), (NAST)item.getChild(0));
                }
                catch (SilverException e) {
                    Throwable rootCause = SilverException.getRootCause(e);
                    if (rootCause instanceof SilverError) {
                        return new Pleft((Object)new StringCatter("Reification error in named argument " + name + " at " + ReifyTraceException.getASTRepr(e) + ":\n" + rootCause.getMessage()));
                    }
                    throw e;
                }
                suppliedIndexList.add(index);
                namedArgList.add(o);
                reorderedNamedArgs[index] = o;
            } else {
                convertedIndexList.add(index);
            }
            ++i;
            current2 = current2.tail();
        }
        Object result = argList.size() < fnType.params || namedArgList.size() < fnType.namedParams.length ? givenFn.invokePartial(argIndexList.stream().mapToInt(n -> n).toArray(), argList.toArray()).invokeNamedPartial(convertedIndexList.stream().mapToInt(n -> n).toArray(), suppliedIndexList.stream().mapToInt(n -> n).toArray(), namedArgList.toArray()) : givenFn.invoke(ctx, argList.toArray(), reorderedNamedArgs);
        return new Pright((Object)Reflection.reflect(rules, result));
    }

    public static NEither nativeSerialize(Object x) {
        try {
            ByteArrayOutputStream arr = new ByteArrayOutputStream(10000000);
            DataOutputStream o = new DataOutputStream(arr);
            o.writeBytes("SVB\u0000\n\u0000");
            ArrayList prodset = new ArrayList();
            Reflection.nSerGetProdSet(prodset, x);
            if (prodset.size() > 32768) {
                throw new NativeSerializationException("Too many productions for native serialize");
            }
            o.writeShort(prodset.size());
            for (RTTIManager.Prodleton<?> p : prodset) {
                o.writeUTF(p.getName());
                o.writeUTF(p.getTypeUnparse());
            }
            Reflection.nSerItem(o, prodset, x);
            return new Pright((Object)arr.toByteArray());
        }
        catch (NativeSerializationException e) {
            return new Pleft((Object)new StringCatter("Native serialize failed: " + e.toString()));
        }
        catch (Exception e) {
            String m = "Native serialize failed: Unknown error: " + e.toString();
            System.err.println(m);
            return new Pleft((Object)new StringCatter(m));
        }
    }

    public static void nSerGetProdSet(ArrayList<RTTIManager.Prodleton<?>> s, Object x) {
        block5: {
            block6: {
                block4: {
                    if (!(x instanceof Node)) break block4;
                    Node n = (Node)x;
                    if (s.indexOf(n.getProdleton()) == -1) {
                        s.add(n.getProdleton());
                    }
                    for (int i = 0; i < n.getNumberOfChildren(); ++i) {
                        Reflection.nSerGetProdSet(s, n.getChild(i));
                    }
                    String[] annotationNames = n.getAnnoNames();
                    for (int i = 0; i < annotationNames.length; ++i) {
                        String name = annotationNames[i];
                        Reflection.nSerGetProdSet(s, n.getAnno(name));
                    }
                    break block5;
                }
                if (!(x instanceof Terminal)) break block6;
                Reflection.nSerGetProdSet(s, ((Terminal)x).location);
                break block5;
            }
            if (!(x instanceof ConsCell)) break block5;
            for (ConsCell c = (ConsCell)x; c != ConsCell.nil; c = c.tail()) {
                Reflection.nSerGetProdSet(s, c.head());
            }
        }
    }

    public static void nSerItem(DataOutputStream o, ArrayList<RTTIManager.Prodleton<?>> s, Object x) throws IOException {
        if (x instanceof Node) {
            int i;
            Node n = (Node)x;
            o.writeByte(5);
            o.writeShort(s.indexOf(n.getProdleton()));
            String[] annotationNames = n.getAnnoNames();
            for (i = 0; i < n.getNumberOfChildren(); ++i) {
                Reflection.nSerItem(o, s, n.getChild(i));
            }
            for (i = 0; i < annotationNames.length; ++i) {
                String name = annotationNames[i];
                Reflection.nSerItem(o, s, n.getAnno(name));
            }
        } else if (x instanceof Terminal) {
            Terminal t = (Terminal)x;
            o.writeByte(6);
            o.writeUTF(t.getTerminalton().getName());
            o.writeUTF(t.lexeme.toString());
            Reflection.nSerItem(o, s, t.location);
        } else if (x instanceof ConsCell) {
            ConsCell c = (ConsCell)x;
            int listLen = c.length();
            if (listLen > 0x40000000 || listLen < 0) {
                throw new NativeSerializationException("List too long for native serialize");
            }
            if (listLen > 32768) {
                o.writeByte(8);
                o.writeInt(listLen);
            } else {
                o.writeByte(7);
                o.writeShort(listLen);
            }
            while (c != ConsCell.nil) {
                Reflection.nSerItem(o, s, c.head());
                c = c.tail();
            }
        } else if (x instanceof StringCatter) {
            o.writeByte(0);
            o.writeUTF(((StringCatter)x).toString());
        } else if (x instanceof Integer) {
            o.writeByte(1);
            o.writeInt((Integer)x);
        } else if (x instanceof Float) {
            o.writeByte(4);
            o.writeFloat(((Float)x).floatValue());
        } else if (x instanceof Boolean) {
            if (((Boolean)x).booleanValue()) {
                o.writeByte(3);
            } else {
                o.writeByte(2);
            }
        } else {
            if (x instanceof DecoratedNode) {
                throw new NativeSerializationException("Cannot serialize DecoratedNodes (prod " + x.toString() + ")");
            }
            throw new NativeSerializationException("Unserializable type encountered: " + x.toString());
        }
    }

    public static NEither nativeDeserialize(TypeRep expected, byte[] arr) {
        try {
            ByteArrayInputStream ins = new ByteArrayInputStream(arr);
            DataInputStream i = new DataInputStream(ins);
            byte[] header = "SVB\u0000\n\u0000".getBytes("ASCII");
            byte[] buf = new byte[6];
            i.readFully(buf, 0, 6);
            if (!Arrays.equals(header, buf)) {
                throw new NativeSerializationException("Not a SVB serialization");
            }
            int prodCount = i.readShort();
            ArrayList lookup = new ArrayList(prodCount);
            for (int c = 0; c < prodCount; ++c) {
                String name = i.readUTF();
                String opaqueTypeIdentifier = i.readUTF();
                RTTIManager.Prodleton<?> pton = RTTIManager.getProdleton(name);
                if (pton == null) {
                    throw new NativeSerializationException("Unknown production: " + name);
                }
                if (!pton.getTypeUnparse().equals(opaqueTypeIdentifier)) {
                    throw new NativeSerializationException("Production " + name + " changed type since serialization (from `" + opaqueTypeIdentifier + "` to `" + pton.getTypeUnparse() + "`)");
                }
                lookup.add(pton);
            }
            Object v = Reflection.nDeserItem(lookup, i);
            if (!TypeRep.unify(expected, Reflection.getType(v))) {
                return new Pleft((Object)new StringCatter("nativeDeserialize is constructing " + expected.toString() + ", but found " + Reflection.getType(v).toString()));
            }
            return new Pright(v);
        }
        catch (NativeSerializationException e) {
            return new Pleft((Object)new StringCatter("Native deserialize failed: " + e.toString()));
        }
        catch (IOException e) {
            String m = "Native deserialize failed: Unknown Error: " + e.toString();
            System.err.println(m);
            return new Pleft((Object)new StringCatter(m));
        }
    }

    public static Object nDeserItem(ArrayList<RTTIManager.Prodleton<?>> s, DataInputStream i) throws IOException {
        byte typeId = i.readByte();
        if (typeId == 5) {
            short orderedIndex = i.readShort();
            RTTIManager.Prodleton<?> pton = s.get(orderedIndex);
            int childCount = pton.getChildCount();
            Object[] children = new Object[childCount];
            for (int n = 0; n < childCount; ++n) {
                children[n] = Reflection.nDeserItem(s, i);
            }
            int annoCount = pton.getAnnoCount();
            Object[] annos = new Object[annoCount];
            for (int n = 0; n < annoCount; ++n) {
                annos[n] = Reflection.nDeserItem(s, i);
            }
            return pton.constructDirect(children, annos);
        }
        if (typeId == 6) {
            String name = i.readUTF();
            RTTIManager.Terminalton<?> tton = RTTIManager.getTerminalton(name);
            if (tton == null) {
                throw new NativeSerializationException("Can't find terminal " + name);
            }
            String lexeme = i.readUTF();
            Object location = Reflection.nDeserItem(s, i);
            return tton.construct(new StringCatter(lexeme), (NLocation)location);
        }
        if (typeId == 7 || typeId == 8) {
            int length = typeId == 7 ? i.readShort() : i.readInt();
            Object[] values = new Object[length];
            for (int c = 0; c < length; ++c) {
                values[c] = Reflection.nDeserItem(s, i);
            }
            ConsCell l = ConsCell.nil;
            for (int c = length - 1; c >= 0; --c) {
                l = new ConsCell(values[c], l);
            }
            return l;
        }
        if (typeId == 0) {
            return new StringCatter(i.readUTF());
        }
        if (typeId == 1) {
            return i.readInt();
        }
        if (typeId == 4) {
            return Float.valueOf(i.readFloat());
        }
        if (typeId == 3) {
            return true;
        }
        if (typeId == 2) {
            return false;
        }
        throw new NativeSerializationException("Unknown type id (" + Integer.toString(typeId) + ")");
    }

    private static class NativeSerializationException
    extends IOException {
        public NativeSerializationException(String x) {
            super(x);
        }
    }
}

