/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.cs.melt.copper.compiletime.lrdfa;

import edu.umn.cs.melt.copper.compiletime.auxiliary.SymbolTable;
import edu.umn.cs.melt.copper.compiletime.parsetable.LRParseTable;
import edu.umn.cs.melt.copper.compiletime.spec.grammarbeans.CopperASTBean;
import edu.umn.cs.melt.copper.compiletime.spec.numeric.PSSymbolTable;
import edu.umn.cs.melt.copper.compiletime.spec.numeric.ParserSpec;
import java.io.Serializable;
import java.util.BitSet;

public class TransparentPrefixes
implements Serializable {
    private static final long serialVersionUID = 253855265720270297L;
    protected BitSet[] prefixSets;
    protected BitSet[][] prefixMaps;

    public TransparentPrefixes(ParserSpec spec, LRParseTable parseTable) {
        this(spec.terminals.length(), parseTable.size());
    }

    public TransparentPrefixes(int terminalsLength, int parseTableSize) {
        this.prefixSets = new BitSet[parseTableSize];
        this.prefixMaps = new BitSet[parseTableSize][terminalsLength];
        for (int i = 0; i < parseTableSize; ++i) {
            this.prefixSets[i] = new BitSet();
        }
    }

    public BitSet getPrefixes(int state) {
        return this.prefixSets[state];
    }

    public BitSet getFollowingTerminals(int state, int prefix) {
        return this.prefixMaps[state][prefix];
    }

    public void initializePrefixMap(int state, int prefix) {
        if (this.prefixMaps[state][prefix] == null) {
            this.prefixMaps[state][prefix] = new BitSet();
        }
    }

    public String toString(SymbolTable<CopperASTBean> symbolTable) {
        StringBuffer rv = new StringBuffer();
        for (int state = 0; state < this.prefixSets.length; ++state) {
            rv.append("State ").append(state).append(":\n");
            int prefix = this.prefixSets[state].nextSetBit(0);
            while (prefix >= 0) {
                rv.append("  ").append(symbolTable.get(prefix).getDisplayName()).append(" -> ").append(PSSymbolTable.bitSetPrettyPrint(this.prefixMaps[state][prefix], symbolTable, "    ", 80)).append("\n");
                prefix = this.prefixSets[state].nextSetBit(prefix + 1);
            }
        }
        return rv.toString();
    }
}

