grammar silver:compiler:analysis:typechecking:core;

aspect production attributeDclInh
top::AGDcl ::= 'inherited' 'attribute' a::Name tl::BracketedOptTypeExprs '::' te::TypeExpr ';'
{
  top.errors <- te.errorsKindStar;
}

aspect production attributeDclSyn
top::AGDcl ::= 'synthesized' 'attribute' a::Name tl::BracketedOptTypeExprs '::' te::TypeExpr ';'
{
  top.errors <- te.errorsKindStar;
}

aspect production attributeDclTrans
top::AGDcl ::= 'translation' 'attribute' a::Name tl::BracketedOptTypeExprs '::' te::TypeExpr ';'
{
  top.errors <- te.errorsKindStar;

  local checkNT::TypeCheck = checkNonterminal(top.env, false, te.typerep);
  checkNT.downSubst = emptySubst();
  checkNT.finalSubst = emptySubst();
  
  top.errors <-
    if checkNT.typeerror
    then [err(top.location, "Translation attribute type must be a nonterminal.  Instead it is of type " ++ checkNT.leftpp)]
    else [];
}

