/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.cs.melt.copper.compiletime.auxiliary.counterexample;

import edu.umn.cs.melt.copper.compiletime.auxiliary.counterexample.ColoredStringBuilder;
import edu.umn.cs.melt.copper.compiletime.auxiliary.counterexample.Derivation;
import java.util.ArrayList;

public class Counterexample {
    public Derivation derivation1;
    public Derivation derivation2;
    private boolean isShiftReduce;
    private ArrayList<ColoredStringBuilder> sb1 = new ArrayList();
    private ArrayList<ColoredStringBuilder> sb2 = new ArrayList();

    public Counterexample(Derivation derivation1, Derivation derivation2, boolean isShiftReduce) {
        this.derivation1 = derivation1;
        this.derivation2 = derivation2;
        this.isShiftReduce = isShiftReduce;
        this.sb1.add(new ColoredStringBuilder());
        this.sb2.add(new ColoredStringBuilder());
    }

    public String toDot() {
        StringBuilder sb = new StringBuilder();
        sb.append("digraph G {\n");
        sb.append("subgraph cluster_0 {\n");
        sb.append("label=\"");
        sb.append(this.isShiftReduce ? "reduce derivation\";\n" : "first reduce derivation\";\n");
        sb.append(this.derivation1.toDot());
        sb.append("}\n");
        sb.append("subgraph cluster_1 {\n");
        sb.append("label=\"");
        sb.append(this.isShiftReduce ? "shift derivation\";\n" : "second reduce derivation\";\n");
        sb.append(this.derivation2.toDot());
        sb.append("}\n");
        sb.append("}");
        return sb.toString();
    }

    public String prettyPrint(boolean color) {
        StringBuilder sb = new StringBuilder();
        sb.append("Counterexample (2 parse trees that are the same until the conflict point, and may differ after):\n");
        sb.append(this.isShiftReduce ? "reduce derivation:\n" : "first reduce derivation:\n");
        this.derivation1.prettyPrint(this.sb1, 0, 0, color);
        for (ColoredStringBuilder s : this.sb1) {
            sb.append(s);
            sb.append('\n');
        }
        sb.append(this.isShiftReduce ? "shift derivation:\n" : "second reduce derivation:\n");
        this.derivation2.prettyPrint(this.sb2, 0, 0, color);
        for (ColoredStringBuilder s : this.sb2) {
            sb.append(s);
            sb.append('\n');
        }
        return sb.toString();
    }

    public String toString() {
        return this.prettyPrint(true);
    }
}

