/*
 * Decompiled with CFR 0.152.
 */
package common;

import common.BaseTypeRep;
import common.ConsCell;
import common.OriginContext;
import common.RandomGen;
import common.StringCatter;
import common.TypeRep;
import common.Typed;
import common.exceptions.SilverExit;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Writer;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import silver.core.NIOVal;
import silver.core.NRandomGen;
import silver.core.Pioval;
import silver.core.Pjust;
import silver.core.Pnothing;

public final class IOToken
implements Typed {
    public static final IOToken singleton = new IOToken();
    private static BufferedReader our_stdin = null;

    private IOToken() {
    }

    public NIOVal wrap(Object arg) {
        return new Pioval((Object)this, arg);
    }

    public Object identity(Object arg) {
        return arg;
    }

    public IOToken exit(int status) {
        throw new SilverExit(status);
    }

    public IOToken print(StringCatter str) {
        System.out.print(str.toString());
        return this;
    }

    public IOToken eprint(StringCatter str) {
        System.err.print(str.toString());
        return this;
    }

    public NIOVal readLineStdin() {
        try {
            String line;
            if (our_stdin == null) {
                our_stdin = new BufferedReader(new InputStreamReader(System.in));
            }
            if ((line = our_stdin.readLine()) == null) {
                return this.wrap(new Pnothing());
            }
            return this.wrap(new Pjust((Object)new StringCatter(line)));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public NIOVal mkdir(StringCatter filepath) {
        return this.wrap(new File(filepath.toString()).mkdirs());
    }

    public NIOVal system(StringCatter shell_command) {
        try {
            ProcessBuilder pb = new ProcessBuilder("bash", "-c", shell_command.toString());
            pb.inheritIO();
            Process p = pb.start();
            return this.wrap(p.waitFor());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public IOToken writeFile(StringCatter filename, StringCatter content) {
        return this.writeFileActual(filename, content, false);
    }

    public NIOVal readByteFile(StringCatter filename) {
        try {
            Path path = Paths.get(filename.toString(), new String[0]);
            byte[] data = Files.readAllBytes(path);
            return this.wrap(data);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public IOToken writeByteFile(StringCatter filename, byte[] content) {
        try {
            File outputFile = new File(filename.toString());
            FileOutputStream outputStream = new FileOutputStream(outputFile);
            outputStream.write(content);
            outputStream.flush();
            return this;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public IOToken appendFile(StringCatter filename, StringCatter content) {
        return this.writeFileActual(filename, content, true);
    }

    private IOToken writeFileActual(StringCatter filename, StringCatter content, boolean append) {
        try {
            BufferedWriter fout = new BufferedWriter(new FileWriter(filename.toString(), append));
            content.write(fout);
            ((Writer)fout).close();
            return this;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public NIOVal fileTime(StringCatter filename) {
        int modtime = (int)(new File(filename.toString()).lastModified() / 1000L);
        return this.wrap(modtime);
    }

    public NIOVal isFile(StringCatter filename) {
        return this.wrap(new File(filename.toString()).isFile());
    }

    public NIOVal isDirectory(StringCatter filename) {
        return this.wrap(new File(filename.toString()).isDirectory());
    }

    public NIOVal readFile(StringCatter filename) {
        try {
            byte[] b = Files.readAllBytes(Paths.get(filename.toString(), new String[0]));
            return this.wrap(new StringCatter(new String(b)));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public NIOVal cwd() {
        return this.wrap(new StringCatter(System.getProperty("user.dir")));
    }

    public NIOVal envVar(StringCatter env_var) {
        String result = System.getenv(env_var.toString());
        if (result == null) {
            result = "";
        }
        return this.wrap(new StringCatter(result));
    }

    public NIOVal listContents(StringCatter filename) {
        try {
            File f = new File(filename.toString());
            String[] files = f.list();
            ConsCell result = ConsCell.nil;
            if (files != null) {
                for (String file : files) {
                    result = new ConsCell(new StringCatter(file), result);
                }
            }
            return this.wrap(result);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public NIOVal deleteFile(StringCatter filename) {
        return this.wrap(new File(filename.toString()).delete());
    }

    public NIOVal deleteFiles(ConsCell files) {
        boolean result = true;
        while (!files.nil()) {
            StringCatter f = (StringCatter)files.head();
            result = result && new File(f.toString()).delete();
            files = files.tail();
        }
        return this.wrap(result);
    }

    public NIOVal deleteDirFiles(StringCatter dir) {
        try {
            File dirf = new File(dir.toString());
            String[] files = dirf.list();
            boolean result = true;
            if (files != null) {
                for (String filename : files) {
                    File file = new File(dirf, filename);
                    if (!file.isFile()) continue;
                    result = result && file.delete();
                }
            }
            return this.wrap(result);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public IOToken deleteTree(StringCatter path) {
        IOToken.deleteTreeRecursive(Paths.get(path.toString(), new String[0]));
        return this;
    }

    private static void deleteTreeRecursive(Path f) {
        block19: {
            if (!Files.exists(f, LinkOption.NOFOLLOW_LINKS)) {
                return;
            }
            if (f.toAbsolutePath().normalize().toString().length() < 9) {
                throw new RuntimeException("Canary against deleting things we shouldn't. Tried to delete path: " + f);
            }
            try {
                if (Files.isSymbolicLink(f)) {
                    Files.delete(f);
                    break block19;
                }
                if (Files.isDirectory(f, new LinkOption[0])) {
                    try (DirectoryStream<Path> stream = Files.newDirectoryStream(f);){
                        for (Path child : stream) {
                            IOToken.deleteTreeRecursive(child);
                        }
                        break block19;
                    }
                }
                Files.delete(f);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public IOToken copyFile(StringCatter from, StringCatter to) {
        Path src = Paths.get(from.toString(), new String[0]);
        Path dst = Paths.get(to.toString(), new String[0]);
        try {
            if (Files.isDirectory(dst, new LinkOption[0])) {
                dst = dst.resolve(src.getFileName());
            }
            Files.copy(src, dst, new CopyOption[0]);
            return this;
        }
        catch (IOException io) {
            throw new RuntimeException(io);
        }
    }

    public IOToken touchFile(StringCatter filename) {
        IOToken.setFileTime(filename, IOToken.currentTime());
        return this;
    }

    public IOToken touchFiles(ConsCell files) {
        while (!files.nil()) {
            IOToken.setFileTime((StringCatter)files.head(), IOToken.currentTime());
            files = files.tail();
        }
        return this;
    }

    private static void setFileTime(StringCatter filename, int time) {
        new File(filename.toString()).setLastModified((long)time * 1000L);
    }

    private static int currentTime() {
        return (int)(System.currentTimeMillis() / 1000L);
    }

    public NIOVal runRandomGen(OriginContext ctx, NRandomGen r) {
        return this.wrap(RandomGen.runRandomGen(ctx, r));
    }

    @Override
    public TypeRep getType() {
        return new BaseTypeRep("silver:core:IO");
    }
}

