/*
 * Decompiled with CFR 0.152.
 */
package common;

import common.ConsCell;
import common.Node;
import common.OriginsUtil;
import common.StringCatter;
import common.Thunk;
import common.Tracked;
import silver.core.NOriginInfo;
import silver.core.NOriginNote;
import silver.core.PoriginOriginInfo;
import silver.core.PotherOriginInfo;

public final class OriginContext {
    public final Variety variety;
    public final Node lhs;
    public final NOriginNote[] rules;
    public static final OriginContext ENTRY_CONTEXT = new OriginContext(Variety.MAINFUNCTION, null, null);
    public static final OriginContext FFI_CONTEXT = new OriginContext(Variety.FFI, null, null);
    public static final OriginContext PARSERACTION_CONTEXT = new OriginContext(Variety.PARSERACTION, null, null);
    public static final OriginContext GLOBAL_CONTEXT = new OriginContext(Variety.GLOBAL, null, null);

    private OriginContext(Variety variety, Node lhs, NOriginNote[] rules) {
        this.variety = variety;
        this.lhs = lhs;
        this.rules = rules;
    }

    public OriginContext(Node lhs, NOriginNote[] rules) {
        this(Variety.NORMAL, lhs, rules);
    }

    public OriginContext(OriginContext old, NOriginNote[] newRules) {
        this(old.variety, old.lhs, OriginContext.mergeRulesArr(old.rules, newRules));
    }

    private static NOriginNote[] mergeRulesArr(NOriginNote[] a, NOriginNote[] b) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        NOriginNote[] result = new NOriginNote[a.length + b.length];
        System.arraycopy(a, 0, result, 0, a.length);
        System.arraycopy(b, 0, result, a.length, b.length);
        return result;
    }

    public ConsCell rulesAsSilverList() {
        if (this.rules == null) {
            return ConsCell.nil;
        }
        ConsCell res = ConsCell.nil;
        for (int i = this.rules.length - 1; i != -1; --i) {
            res = new ConsCell(this.rules[i], res);
        }
        return res;
    }

    public NOriginInfo makeNewConstructionOrigin(boolean isContractum) {
        switch (this.variety) {
            case NORMAL: {
                return new PoriginOriginInfo((Object)OriginsUtil.SET_AT_CONSTRUCTION_OIT, (Object)this.lhs, (Object)this.rulesAsSilverList(), (Object)isContractum);
            }
            case MAINFUNCTION: {
                return new PotherOriginInfo((Object)OriginsUtil.SET_FROM_ENTRY_OIT, (Object)new StringCatter("Main Function"), (Object)this.rulesAsSilverList());
            }
            case FFI: {
                return new PotherOriginInfo((Object)OriginsUtil.SET_FROM_FFI_OIT, (Object)new StringCatter("Called from FFI"), (Object)this.rulesAsSilverList());
            }
            case PARSERACTION: {
                return new PotherOriginInfo((Object)OriginsUtil.SET_FROM_PARSER_ACTION_OIT, (Object)new StringCatter("Called inside a parser action block"), (Object)this.rulesAsSilverList());
            }
            case GLOBAL: {
                return new PotherOriginInfo((Object)OriginsUtil.SET_IN_GLOBAL_OIT, (Object)new StringCatter("Built in a global"), (Object)this.rulesAsSilverList());
            }
        }
        throw new RuntimeException("Impossible state: this.variety not recognized.");
    }

    public <T extends Tracked> T attrAccessCopy(T arg) {
        switch (this.variety) {
            case NORMAL: {
                return (T)((Tracked)arg.copy(this.lhs, this.rulesAsSilverList()));
            }
        }
        return arg;
    }

    public <T> T attrAccessCopyPoly(T arg) {
        if (arg instanceof Tracked) {
            return (T)this.attrAccessCopy((Tracked)arg);
        }
        return arg;
    }

    public Object attrAccessCopyPolyThunk(Object t) {
        if (t instanceof Thunk) {
            return new Thunk<Object>(() -> this.attrAccessCopyPoly(((Thunk)t).eval()));
        }
        return this.attrAccessCopyPoly(t);
    }

    public static enum Variety {
        NORMAL,
        MAINFUNCTION,
        FFI,
        PARSERACTION,
        GLOBAL;

    }
}

