/*
 * Decompiled with CFR 0.152.
 */
package common;

import common.BaseTypeRep;
import common.DecoratedNode;
import common.Lazy;
import common.StringCatter;
import common.TopNode;
import common.Tracked;
import common.Typed;
import edu.umn.cs.melt.copper.runtime.engines.semantics.VirtualLocation;
import silver.core.Alocation;
import silver.core.Init;
import silver.core.NLocation;
import silver.core.NOriginInfo;
import silver.core.Ploc;
import silver.core.PparsedOriginInfo;

public abstract class Terminal
implements Typed {
    public final StringCatter lexeme;
    public final NLocation location;

    public Terminal(String lexeme, VirtualLocation vl, int index, int endIndex) {
        this.lexeme = new StringCatter(lexeme);
        int line = vl.getLine();
        int column = vl.getColumn();
        vl.defaultUpdate(lexeme);
        this.location = new Ploc((Object)new StringCatter(vl.getFileName()), (Object)line, (Object)column, (Object)vl.getLine(), (Object)vl.getColumn(), (Object)index, (Object)endIndex);
    }

    public Terminal(StringCatter lexeme, NLocation location) {
        this.lexeme = lexeme;
        this.location = location;
    }

    private Object getFromLoc(int syn) {
        DecoratedNode d = this.location.decorate((DecoratedNode)TopNode.singleton, (Lazy[])null);
        return d.synthesized(syn);
    }

    public Integer getLine() {
        return (Integer)this.getFromLoc(Init.silver_core_line__ON__silver_core_Location);
    }

    public Integer getColumn() {
        return (Integer)this.getFromLoc(Init.silver_core_column__ON__silver_core_Location);
    }

    public StringCatter getFilename() {
        return (StringCatter)this.getFromLoc(Init.silver_core_filename__ON__silver_core_Location);
    }

    public Integer getStartOffset() {
        return (Integer)this.getFromLoc(Init.silver_core_index__ON__silver_core_Location);
    }

    public Integer getEndOffset() {
        return (Integer)this.getFromLoc(Init.silver_core_endIndex__ON__silver_core_Location);
    }

    public static NLocation span(NLocation a, NLocation b) {
        DecoratedNode x = a.decorate((DecoratedNode)TopNode.singleton, (Lazy[])null);
        DecoratedNode y = b.decorate((DecoratedNode)TopNode.singleton, (Lazy[])null);
        return new Ploc(x.synthesized(Init.silver_core_filename__ON__silver_core_Location), x.synthesized(Init.silver_core_line__ON__silver_core_Location), x.synthesized(Init.silver_core_column__ON__silver_core_Location), y.synthesized(Init.silver_core_endLine__ON__silver_core_Location), y.synthesized(Init.silver_core_endColumn__ON__silver_core_Location), x.synthesized(Init.silver_core_index__ON__silver_core_Location), y.synthesized(Init.silver_core_endIndex__ON__silver_core_Location));
    }

    public static NLocation createSpan(Object[] children, VirtualLocation l, int index) {
        if (children.length == 0) {
            return new Ploc((Object)new StringCatter(l.getFileName()), (Object)l.getLine(), (Object)l.getColumn(), (Object)l.getLine(), (Object)l.getColumn(), (Object)index, (Object)index);
        }
        if (children.length == 1) {
            return Terminal.extractLocation(children[0]);
        }
        return Terminal.span(Terminal.extractLocation(children[0]), Terminal.extractLocation(children[children.length - 1]));
    }

    public static NLocation extractLocation(Object o) {
        NOriginInfo oi;
        if (o instanceof Terminal) {
            return ((Terminal)o).location;
        }
        if (o instanceof Alocation) {
            return ((Alocation)o).getAnno_silver_core_location();
        }
        if (o instanceof Tracked && (oi = ((Tracked)o).getOrigin()) != null && oi instanceof PparsedOriginInfo) {
            return ((PparsedOriginInfo)oi).getChild_source();
        }
        throw new RuntimeException("Attempting to extract location from locationless object: " + o.toString());
    }

    public abstract String getName();

    public abstract String[] getLexerClasses();

    @Override
    public final BaseTypeRep getType() {
        return new BaseTypeRep(this.getName());
    }
}

