/*
 * Decompiled with CFR 0.152.
 */
package common.javainterop;

import common.ConsCell;
import common.StringCatter;
import java.util.AbstractCollection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class ConsCellCollection<T>
extends AbstractCollection<T> {
    private ConsCell start;

    public ConsCellCollection(ConsCell start) {
        this.start = start;
    }

    @Override
    public Iterator<T> iterator() {
        return new ConsCellIterator(this.start);
    }

    @Override
    public int size() {
        return this.start.length();
    }

    public static ConsCell fromIterator(Iterator<?> i) {
        if (!i.hasNext()) {
            return ConsCell.nil;
        }
        return new ConsCell(i.next(), ConsCellCollection.fromIterator(i));
    }

    public static ConsCell fromReverseIterator(Iterator<?> i) {
        ConsCell ret = ConsCell.nil;
        while (i.hasNext()) {
            ret = new ConsCell(i.next(), ret);
        }
        return ret;
    }

    public static ConsCell fromList(List<?> l) {
        ListIterator<?> i = l.listIterator(l.size());
        ConsCell ret = ConsCell.nil;
        while (i.hasPrevious()) {
            ret = new ConsCell(i.previous(), ret);
        }
        return ret;
    }

    public static ConsCell fromStringList(List<String> l) {
        return ConsCellCollection.fromIterator(l.stream().map(StringCatter::new).iterator());
    }

    public static class ConsCellIterator<T>
    implements Iterator<T> {
        private ConsCell elem;

        public ConsCellIterator(ConsCell elemt) {
            this.elem = elemt;
        }

        @Override
        public boolean hasNext() {
            return !this.elem.nil();
        }

        @Override
        public T next() {
            Object fst = this.elem.head();
            this.elem = this.elem.tail();
            return (T)fst;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Mutation of ConsCell iterators is not supported!");
        }
    }
}

