/*
 * Decompiled with CFR 0.152.
 */
package common;

import common.DecoratedNode;
import common.IOToken;
import common.exceptions.SilverInternalError;
import common.javainterop.ConsCellCollection;
import edu.umn.cs.melt.copper.compiletime.dumpers.XMLSpecDumper;
import edu.umn.cs.melt.copper.compiletime.logging.CompilerLogger;
import edu.umn.cs.melt.copper.compiletime.pipeline.AuxiliaryMethods;
import edu.umn.cs.melt.copper.compiletime.pipeline.UniversalProcessParameters;
import edu.umn.cs.melt.copper.compiletime.spec.grammarbeans.CharacterSetRegex;
import edu.umn.cs.melt.copper.compiletime.spec.grammarbeans.CopperElementName;
import edu.umn.cs.melt.copper.compiletime.spec.grammarbeans.CopperElementReference;
import edu.umn.cs.melt.copper.compiletime.spec.grammarbeans.DisambiguationFunction;
import edu.umn.cs.melt.copper.compiletime.spec.grammarbeans.ExtendedParserBean;
import edu.umn.cs.melt.copper.compiletime.spec.grammarbeans.ExtensionGrammar;
import edu.umn.cs.melt.copper.compiletime.spec.grammarbeans.Grammar;
import edu.umn.cs.melt.copper.compiletime.spec.grammarbeans.GrammarElement;
import edu.umn.cs.melt.copper.compiletime.spec.grammarbeans.NonTerminal;
import edu.umn.cs.melt.copper.compiletime.spec.grammarbeans.OperatorAssociativity;
import edu.umn.cs.melt.copper.compiletime.spec.grammarbeans.ParserAttribute;
import edu.umn.cs.melt.copper.compiletime.spec.grammarbeans.ParserBean;
import edu.umn.cs.melt.copper.compiletime.spec.grammarbeans.Production;
import edu.umn.cs.melt.copper.compiletime.spec.grammarbeans.Regex;
import edu.umn.cs.melt.copper.compiletime.spec.grammarbeans.Terminal;
import edu.umn.cs.melt.copper.compiletime.spec.grammarbeans.TerminalClass;
import edu.umn.cs.melt.copper.compiletime.spec.grammarbeans.visitors.ParserSpecProcessor;
import edu.umn.cs.melt.copper.main.CopperDumpType;
import edu.umn.cs.melt.copper.main.CopperIOType;
import edu.umn.cs.melt.copper.main.CopperPipelineType;
import edu.umn.cs.melt.copper.main.ParserCompiler;
import edu.umn.cs.melt.copper.main.ParserCompilerParameters;
import edu.umn.cs.melt.copper.runtime.engines.semantics.VirtualLocation;
import edu.umn.cs.melt.copper.runtime.io.Location;
import edu.umn.cs.melt.copper.runtime.logging.CopperException;
import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashSet;
import silver.core.Init;
import silver.core.NIOVal;
import silver.core.NLocation;

public final class CopperUtil {
    private static Location svToCuLocation(NLocation locTerm) {
        DecoratedNode locTree = locTerm.decorate();
        String fileName = locTree.synthesized(Init.silver_core_filename__ON__silver_core_Location).toString();
        Integer line = (Integer)locTree.synthesized(Init.silver_core_line__ON__silver_core_Location);
        Integer column = (Integer)locTree.synthesized(Init.silver_core_column__ON__silver_core_Location);
        return new VirtualLocation(fileName, line.intValue(), column.intValue());
    }

    public static NIOVal compile(ParserBean parser, String packageName, String parserName, Boolean runMDA, String outFile, Boolean dumpHtml, String dumpHtmlTo, Boolean xmlDump, IOToken tok) {
        if (xmlDump.booleanValue()) {
            try {
                new XMLSpecDumper(parser).dump(CopperDumpType.XML_SPEC, System.out);
            }
            catch (IOException exc) {
                throw new SilverInternalError("Failed to dump XML for Copper specification", exc);
            }
        }
        ParserCompilerParameters params = new ParserCompilerParameters();
        params.setPackageName(packageName);
        params.setParserName(parserName);
        if (!runMDA.booleanValue()) {
            params.setOutputFile(new File(outFile));
            params.setOutputType(CopperIOType.FILE);
        }
        params.setUsePipeline(CopperPipelineType.GRAMMARBEANS);
        params.setRunMDA(runMDA.booleanValue());
        CompilerLogger logger = AuxiliaryMethods.getOrMakeLogger((UniversalProcessParameters)params);
        try {
            ParserSpecProcessor.normalizeParser((ParserBean)parser, (CompilerLogger)logger);
            return tok.wrap(ParserCompiler.compile((ParserBean)parser, (ParserCompilerParameters)params));
        }
        catch (CopperException exc) {
            throw new SilverInternalError("Failed to compile Copper specification", exc);
        }
    }

    public static CharacterSetRegex makeCharRange(String lo, String hi) {
        CharacterSetRegex re = new CharacterSetRegex();
        re.addRange(lo.charAt(0), hi.charAt(0));
        return re;
    }

    public static CharacterSetRegex makeSingleChar(String ch) {
        CharacterSetRegex re = new CharacterSetRegex();
        re.addLooseChar(ch.charAt(0));
        return re;
    }

    public static DisambiguationFunction makeDisambiguationFunction(NLocation location, String id, String code, ConsCellCollection<CopperElementReference> members, Boolean applicableToSubsets) {
        try {
            DisambiguationFunction f = new DisambiguationFunction();
            f.setLocation(CopperUtil.svToCuLocation(location));
            f.setName(id);
            f.setCode(code);
            HashSet memberSet = new HashSet();
            members.iterator().forEachRemaining(memberSet::add);
            f.setMembers(memberSet);
            f.setApplicableToSubsets(applicableToSubsets.booleanValue());
            return f;
        }
        catch (ParseException exc) {
            throw new SilverInternalError("Copper ParseException while constructing DisambiguationFunction", exc);
        }
    }

    public static CopperElementReference makeElementReference(NLocation location, String grammarName, String name) {
        try {
            return CopperElementReference.ref((CopperElementName)CopperElementName.newName((String)grammarName), (String)name, (Location)CopperUtil.svToCuLocation(location));
        }
        catch (ParseException exc) {
            throw new SilverInternalError("Copper ParseException while constructing ElementReference", exc);
        }
    }

    public static ExtendedParserBean makeExtendedParserBean(NLocation location, String id, String pp, CopperElementReference startSymbol, ConsCellCollection<CopperElementReference> startLayout, String parserClassAuxCode, String parserInitCode, String preambleCode, Grammar hostGrammar, Grammar extGrammar) {
        try {
            ExtendedParserBean parserBean = new ExtendedParserBean();
            parserBean.setLocation(CopperUtil.svToCuLocation(location));
            parserBean.setName(id);
            parserBean.setDisplayName(pp);
            parserBean.setUnitary(false);
            parserBean.setStartSymbol(startSymbol);
            HashSet startLayoutSet = new HashSet();
            startLayout.iterator().forEachRemaining(startLayoutSet::add);
            parserBean.setStartLayout(startLayoutSet);
            parserBean.setParserClassAuxCode(parserClassAuxCode);
            parserBean.setParserInitCode(parserInitCode);
            parserBean.setPreambleCode(preambleCode);
            parserBean.addGrammar(hostGrammar);
            parserBean.addGrammar(extGrammar);
            parserBean.setHostGrammar(hostGrammar);
            return parserBean;
        }
        catch (CopperException exc) {
            throw new SilverInternalError("CopperException while constructing ExtendedParserBean", exc);
        }
        catch (ParseException exc) {
            throw new SilverInternalError("Copper ParseException while constructing ExtendedParserBean", exc);
        }
    }

    public static ExtensionGrammar makeExtensionGrammar(NLocation location, String id, ConsCellCollection<GrammarElement> grammarElements, ConsCellCollection<CopperElementReference> markingTerminals, ConsCellCollection<CopperElementReference> bridgeProductions, ConsCellCollection<CopperElementReference> glueDisambiguationFunctions) {
        try {
            ExtensionGrammar grammar = new ExtensionGrammar();
            grammar.setLocation(CopperUtil.svToCuLocation(location));
            grammar.setName(id);
            grammarElements.iterator().forEachRemaining(ele -> {
                try {
                    grammar.addGrammarElement(ele);
                }
                catch (CopperException exc) {
                    throw new SilverInternalError("CopperException while adding elements to ExtensionGrammar", exc);
                }
            });
            for (CopperElementReference name : markingTerminals) {
                grammar.addMarkingTerminal(name.getName());
            }
            for (CopperElementReference name : bridgeProductions) {
                grammar.addBridgeProduction(name.getName());
            }
            for (CopperElementReference name : glueDisambiguationFunctions) {
                grammar.addGlueDisambiguationFunction(name.getName());
            }
            return grammar;
        }
        catch (ParseException exc) {
            throw new SilverInternalError("Copper ParseException while constructing ExtensionGrammar", exc);
        }
    }

    public static Grammar makeGrammar(NLocation location, String id, ConsCellCollection<GrammarElement> grammarElements) {
        try {
            Grammar grammar = new Grammar();
            grammar.setLocation(CopperUtil.svToCuLocation(location));
            grammar.setName(id);
            grammarElements.iterator().forEachRemaining(ele -> {
                try {
                    grammar.addGrammarElement(ele);
                }
                catch (CopperException exc) {
                    throw new SilverInternalError("CopperException while adding elements to Grammar", exc);
                }
            });
            return grammar;
        }
        catch (ParseException exc) {
            throw new SilverInternalError("Copper ParseException while constructing Grammar", exc);
        }
    }

    public static NonTerminal makeNonTerminal(NLocation location, String id, String pp, String type_) {
        try {
            NonTerminal nt = new NonTerminal();
            nt.setLocation(CopperUtil.svToCuLocation(location));
            nt.setName(id);
            nt.setDisplayName(pp);
            nt.setReturnType(type_);
            return nt;
        }
        catch (ParseException exc) {
            throw new SilverInternalError("Copper ParseException while constructing NonTerminal", exc);
        }
    }

    public static ParserBean makeParserBean(NLocation location, String id, String pp, CopperElementReference startSymbol, ConsCellCollection<CopperElementReference> startLayout, String parserClassAuxCode, String parserInitCode, String preambleCode, Grammar grammar) {
        try {
            ParserBean parserBean = new ParserBean();
            parserBean.setLocation(CopperUtil.svToCuLocation(location));
            parserBean.setName(id);
            parserBean.setDisplayName(pp);
            parserBean.setUnitary(true);
            parserBean.setStartSymbol(startSymbol);
            HashSet startLayoutSet = new HashSet();
            startLayout.iterator().forEachRemaining(startLayoutSet::add);
            parserBean.setStartLayout(startLayoutSet);
            parserBean.setParserClassAuxCode(parserClassAuxCode);
            parserBean.setParserInitCode(parserInitCode);
            parserBean.setPreambleCode(preambleCode);
            parserBean.addGrammar(grammar);
            return parserBean;
        }
        catch (CopperException exc) {
            throw new SilverInternalError("CopperException while constructing ParserBean", exc);
        }
        catch (ParseException exc) {
            throw new SilverInternalError("Copper ParseException while constructing ParserBean", exc);
        }
    }

    public static ParserAttribute makeParserAttribute(NLocation location, String id, String type_, String code) {
        try {
            ParserAttribute attr = new ParserAttribute();
            attr.setLocation(CopperUtil.svToCuLocation(location));
            attr.setName(id);
            attr.setDisplayName(id);
            attr.setAttributeType(type_);
            attr.setCode(code);
            return attr;
        }
        catch (ParseException exc) {
            throw new SilverInternalError("Copper ParseException while constructing ParserAttribute", exc);
        }
    }

    public static Production makeProduction(NLocation location, String id, Integer precedence, CopperElementReference operator, String code, CopperElementReference lhs, ConsCellCollection<CopperElementReference> rhsConsList, ConsCellCollection<CopperElementReference> prodLayout) {
        try {
            Production prod = new Production();
            prod.setLocation(CopperUtil.svToCuLocation(location));
            prod.setName(id);
            prod.setDisplayName(id);
            if (precedence != null) {
                prod.setPrecedence(precedence);
            }
            prod.setOperator(operator);
            prod.setCode(code);
            prod.setLhs(lhs);
            ArrayList<CopperElementReference> rhs = new ArrayList<CopperElementReference>(rhsConsList);
            prod.setRhs(rhs);
            ArrayList<String> rhsVarNames = new ArrayList<String>();
            for (int i = 0; i < rhs.size(); ++i) {
                rhsVarNames.add(String.format("rhsVar_%d", i));
            }
            prod.setRhsVarNames(rhsVarNames);
            prod.setLayout(new HashSet<CopperElementReference>(prodLayout));
            return prod;
        }
        catch (ParseException exc) {
            throw new SilverInternalError("Copper ParseException while constructing Production", exc);
        }
    }

    public static Terminal makeTerminal(NLocation location, String id, String pp, Regex regex, Integer precedence, String associativity, String type_, String code, ConsCellCollection<CopperElementReference> classes, CopperElementReference prefix, ConsCellCollection<CopperElementReference> submits, ConsCellCollection<CopperElementReference> dominates) {
        try {
            Terminal terminal = new Terminal();
            terminal.setLocation(CopperUtil.svToCuLocation(location));
            terminal.setName(id);
            terminal.setDisplayName(pp);
            terminal.setRegex(regex);
            terminal.setOperatorPrecedence(precedence);
            switch (associativity) {
                case "left": {
                    terminal.setOperatorAssociativity(OperatorAssociativity.LEFT);
                    break;
                }
                case "right": {
                    terminal.setOperatorAssociativity(OperatorAssociativity.RIGHT);
                    break;
                }
                default: {
                    terminal.setOperatorAssociativity(OperatorAssociativity.NONASSOC);
                }
            }
            terminal.setReturnType(type_);
            terminal.setCode(code);
            classes.iterator().forEachRemaining(arg_0 -> ((Terminal)terminal).addTerminalClass(arg_0));
            terminal.setPrefix(prefix);
            submits.iterator().forEachRemaining(arg_0 -> ((Terminal)terminal).addSubmitsTo(arg_0));
            dominates.iterator().forEachRemaining(arg_0 -> ((Terminal)terminal).addDominates(arg_0));
            return terminal;
        }
        catch (ParseException exc) {
            throw new SilverInternalError("Copper ParseException while constructing Terminal", exc);
        }
    }

    public static TerminalClass makeTerminalClass(NLocation location, String id) {
        try {
            TerminalClass out = new TerminalClass();
            out.setLocation(CopperUtil.svToCuLocation(location));
            out.setName(id);
            return out;
        }
        catch (ParseException exc) {
            throw new SilverInternalError("Copper ParseException while constructing TerminalClass", exc);
        }
    }
}

