/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.cs.melt.copper.compiletime.skins.xml;

import edu.umn.cs.melt.copper.compiletime.logging.CompilerLevel;
import edu.umn.cs.melt.copper.compiletime.logging.CompilerLogger;
import edu.umn.cs.melt.copper.compiletime.logging.messages.GenericLocatedMessage;
import edu.umn.cs.melt.copper.compiletime.logging.messages.GenericMessage;
import edu.umn.cs.melt.copper.compiletime.skins.xml.VersionSpecificXMLSkinParser;
import edu.umn.cs.melt.copper.compiletime.spec.grammarbeans.CopperElementName;
import edu.umn.cs.melt.copper.compiletime.spec.grammarbeans.Grammar;
import edu.umn.cs.melt.copper.compiletime.spec.grammarbeans.ParserBean;
import edu.umn.cs.melt.copper.compiletime.spec.grammarbeans.visitors.ParserSpecProcessor;
import edu.umn.cs.melt.copper.runtime.auxiliary.Pair;
import edu.umn.cs.melt.copper.runtime.io.InputPosition;
import edu.umn.cs.melt.copper.runtime.logging.CopperException;
import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class XMLSkinParser
extends DefaultHandler {
    private ArrayList<Pair<String, Reader>> files;
    private CompilerLogger logger;
    private InputPosition loc;
    private Locator locator;
    private Hashtable<CopperElementName, Grammar> grammars = new Hashtable();
    private ArrayList<ParserBean> parsers = new ArrayList();
    private VersionSpecificXMLSkinParser versionSpecificParser = null;

    public XMLSkinParser(ArrayList<Pair<String, Reader>> files, CompilerLogger logger) throws IOException, CopperException {
        this.files = files;
        this.logger = logger;
    }

    public ParserBean parse() throws CopperException {
        boolean hasError;
        SAXParser parser;
        block15: {
            Schema schema;
            block14: {
                schema = null;
                SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
                URL schemaURL = this.getClass().getClassLoader().getResource("resources/edu/umn/cs/melt/copper/compiletime/XMLSkinSchema.xsd");
                if (schemaURL == null && this.logger.isLoggable(CompilerLevel.QUIET)) {
                    this.logger.logError(new GenericMessage(CompilerLevel.QUIET, "Cannot load XML skin schema. This generally means Copper was improperly built.", true, true));
                }
                try {
                    schema = schemaFactory.newSchema(schemaURL);
                }
                catch (SAXException ex) {
                    if (!this.logger.isLoggable(CompilerLevel.QUIET)) break block14;
                    this.logger.logError(new GenericMessage(CompilerLevel.QUIET, "Schema parse error: " + ex.getMessage(), true, true));
                }
            }
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(true);
            factory.setSchema(schema);
            parser = null;
            try {
                parser = factory.newSAXParser();
            }
            catch (SAXException ex) {
                if (this.logger.isLoggable(CompilerLevel.QUIET)) {
                    this.logger.log(new GenericMessage(CompilerLevel.QUIET, ex.getMessage(), true, false));
                }
            }
            catch (ParserConfigurationException ex) {
                if (!this.logger.isLoggable(CompilerLevel.QUIET)) break block15;
                this.logger.log(new GenericMessage(CompilerLevel.QUIET, ex.getMessage(), true, false));
            }
        }
        for (Pair<String, Reader> file : this.files) {
            try {
                this.loc = InputPosition.initialPos(file.first());
                InputSource s = new InputSource(file.second());
                parser.parse(s, (DefaultHandler)this);
            }
            catch (IOException ex) {
                if (!this.logger.isLoggable(CompilerLevel.QUIET)) continue;
                this.logger.log(new GenericLocatedMessage(CompilerLevel.QUIET, this.loc, ex.getMessage(), true, false));
            }
            catch (SAXException ex) {
                if (!this.logger.isLoggable(CompilerLevel.QUIET)) continue;
                this.logger.log(new GenericLocatedMessage(CompilerLevel.QUIET, this.loc, ex.getMessage(), true, false));
            }
        }
        if (this.parsers.size() > 1) {
            for (int i = 1; i < this.parsers.size(); ++i) {
                if (!this.logger.isLoggable(CompilerLevel.QUIET)) continue;
                this.logger.log(new GenericLocatedMessage(CompilerLevel.QUIET, (InputPosition)this.parsers.get(i).getLocation(), "Superfluous parser " + this.parsers.get(i).getDisplayName() + ": spec must contain exactly one parser element", true, false));
            }
        }
        this.logger.flush();
        boolean bl = hasError = !this.parsers.isEmpty() ? ParserSpecProcessor.normalizeParser(this.parsers.get(0), this.logger) : true;
        if (hasError) {
            return null;
        }
        return this.parsers.get(0);
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
        if (this.versionSpecificParser != null) {
            this.versionSpecificParser.setDocumentLocator(locator);
        }
    }

    @Override
    public void warning(SAXParseException ex) throws SAXParseException {
        this.loc = InputPosition.fromSAXLocator(this.loc, this.locator);
        throw ex;
    }

    @Override
    public void error(SAXParseException ex) throws SAXParseException {
        this.loc = InputPosition.fromSAXLocator(this.loc, this.locator);
        throw ex;
    }

    @Override
    public void fatalError(SAXParseException ex) throws SAXParseException {
        this.loc = InputPosition.fromSAXLocator(this.loc, this.locator);
        throw ex;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (this.versionSpecificParser == null) {
            if (VersionSpecificXMLSkinParser.versionSpecificParsers.containsKey(uri)) {
                try {
                    this.versionSpecificParser = VersionSpecificXMLSkinParser.versionSpecificParsers.get(uri).newInstance();
                    this.versionSpecificParser.init();
                    this.versionSpecificParser.grammars = this.grammars;
                    this.versionSpecificParser.loc = this.loc;
                    this.versionSpecificParser.logger = this.logger;
                    this.versionSpecificParser.setDocumentLocator(this.locator);
                    this.versionSpecificParser.parsers = this.parsers;
                }
                catch (IllegalAccessException ex) {
                    this.fatalError(new SAXParseException(ex.getMessage(), this.locator));
                }
                catch (InstantiationException ex) {
                    this.fatalError(new SAXParseException(ex.getMessage(), this.locator));
                }
            } else {
                this.fatalError(new SAXParseException("Unknown namespace: " + uri + ". Copper's XML skin schemas are misconfigured.", this.locator));
            }
        }
        this.versionSpecificParser.startElement(uri, localName, qName, attributes);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.versionSpecificParser != null) {
            this.versionSpecificParser.endElement(uri, localName, qName);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.versionSpecificParser != null) {
            this.versionSpecificParser.characters(ch, start, length);
        }
    }

    @Override
    public void endDocument() {
        this.versionSpecificParser = null;
    }
}

