/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.cs.melt.copper.compiletime.logging.messages;

import edu.umn.cs.melt.copper.compiletime.auxiliary.SymbolTable;
import edu.umn.cs.melt.copper.compiletime.logging.CompilerLevel;
import edu.umn.cs.melt.copper.compiletime.logging.CompilerLogMessage;
import edu.umn.cs.melt.copper.compiletime.spec.grammarbeans.CopperASTBean;
import edu.umn.cs.melt.copper.compiletime.spec.numeric.PSSymbolTable;
import java.util.BitSet;

public class OverlappingDisambiguationFunctionMessage
implements CompilerLogMessage {
    private SymbolTable<CopperASTBean> symbolTable;
    private int function1;
    private int function2;
    private BitSet intersect;

    public OverlappingDisambiguationFunctionMessage(SymbolTable<CopperASTBean> symbolTable, int function1, int function2, BitSet intersect) {
        this.symbolTable = symbolTable;
        this.function1 = function1;
        this.function2 = function2;
        this.intersect = intersect;
    }

    @Override
    public CompilerLevel getLevel() {
        return CompilerLevel.QUIET;
    }

    @Override
    public int getType() {
        return 11;
    }

    @Override
    public boolean isError() {
        return true;
    }

    @Override
    public boolean isFatalError() {
        return false;
    }

    @Override
    public String toString() {
        return "Disambiguation function " + this.symbolTable.get(this.function1).getDisplayName() + " (applicable to subsets) overlaps with " + this.symbolTable.get(this.function2).getDisplayName() + " for terminals\n" + PSSymbolTable.bitSetPrettyPrint(this.intersect, this.symbolTable, "   ", 80);
    }
}

