/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.cs.melt.copper.compiletime.spec.numeric;

import edu.umn.cs.melt.copper.compiletime.spec.numeric.Digraph;
import java.util.BitSet;
import java.util.Queue;

public class PrecedenceGraph
extends Digraph {
    public PrecedenceGraph(int vertexCount) {
        super(vertexCount);
    }

    public <T> BitSet partitionAcceptSet(Queue<BitSet> detectedCycles, BitSet acceptSet) {
        this.detectCycles(acceptSet, detectedCycles, null);
        if (!detectedCycles.isEmpty()) {
            return acceptSet;
        }
        BitSet acceptSetW = new BitSet(acceptSet.length());
        acceptSetW.or(acceptSet);
        BitSet rej = new BitSet(acceptSet.length());
        BitSet sources = new BitSet(acceptSet.length());
        BitSet culled = new BitSet(acceptSet.length());
        int i = acceptSetW.nextSetBit(0);
        while (i >= 0) {
            if (this.inDegrees[i] == 0) {
                sources.set(i);
            } else {
                int j = acceptSetW.nextSetBit(0);
                while (j >= 0 && !this.hasEdge(i, j)) {
                    j = acceptSetW.nextSetBit(j + 1);
                }
                if (j < 0) {
                    sources.set(i);
                }
            }
            i = acceptSetW.nextSetBit(i + 1);
        }
        while (!sources.isEmpty()) {
            int d;
            culled.clear();
            int t = sources.nextSetBit(0);
            while (t >= 0) {
                int u = acceptSetW.nextSetBit(0);
                while (u >= 0) {
                    if (this.hasEdge(u, t)) {
                        culled.set(u);
                    }
                    u = acceptSetW.nextSetBit(u + 1);
                }
                t = sources.nextSetBit(t + 1);
            }
            rej.or(culled);
            sources.clear();
            int c = culled.nextSetBit(0);
            while (c >= 0) {
                d = acceptSetW.nextSetBit(0);
                while (d >= 0) {
                    if (this.hasEdge(d, c)) {
                        sources.set(d);
                    }
                    d = acceptSetW.nextSetBit(d + 1);
                }
                acceptSetW.clear(c);
                c = culled.nextSetBit(c + 1);
            }
            t = sources.nextSetBit(0);
            while (t >= 0) {
                if (this.inDegrees[t] != 0) {
                    d = acceptSetW.nextSetBit(0);
                    while (d >= 0) {
                        if (this.hasEdge(t, d)) {
                            sources.clear(t);
                            break;
                        }
                        d = acceptSetW.nextSetBit(d + 1);
                    }
                }
                t = sources.nextSetBit(t + 1);
            }
        }
        return rej;
    }

    public BitSet getClosure(BitSet seed) {
        BitSet rv = new BitSet(this.vertexCount);
        rv.or(seed);
        int t = seed.nextSetBit(0);
        while (t >= 0) {
            for (int u = 0; u < this.vertexCount; ++u) {
                if (!this.hasEdge(t, u)) continue;
                rv.set(u);
            }
            t = seed.nextSetBit(t + 1);
        }
        return rv;
    }

    public String toString() {
        StringBuffer rv = new StringBuffer();
        rv.append("Adjacency matrix\n(read as column < row): \n");
        for (int i = 0; i < this.adjacencyMatrix.length; ++i) {
            rv.append("   ");
            for (int j = 0; j < this.adjacencyMatrix.length; ++j) {
                if (this.adjacencyMatrix[i][j]) {
                    rv.append("1 ");
                    continue;
                }
                rv.append("- ");
            }
            rv.append("\n");
        }
        return rv.toString();
    }
}

