/*
 * Decompiled with CFR 0.152.
 */
package zmq;

import java.nio.channels.SelectableChannel;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import zmq.Command;
import zmq.Config;
import zmq.Signaler;
import zmq.YPipe;

public class Mailbox {
    private final YPipe<Command> cpipe = new YPipe(Config.COMMAND_PIPE_GRANULARITY.getValue());
    private final Signaler signaler;
    private final Lock sync = new ReentrantLock();
    private boolean active;
    private final String name;

    public Mailbox(String name_) {
        this.signaler = new Signaler();
        Command cmd = this.cpipe.read();
        assert (cmd == null);
        this.active = false;
        this.name = name_;
    }

    public SelectableChannel get_fd() {
        return this.signaler.get_fd();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(Command cmd_) {
        boolean ok = false;
        this.sync.lock();
        try {
            this.cpipe.write(cmd_, false);
            ok = this.cpipe.flush();
        }
        finally {
            this.sync.unlock();
        }
        if (!ok) {
            this.signaler.send();
        }
    }

    public Command recv(long timeout_) {
        boolean rc;
        Command cmd_ = null;
        if (this.active) {
            cmd_ = this.cpipe.read();
            if (cmd_ != null) {
                return cmd_;
            }
            this.active = false;
            this.signaler.recv();
        }
        if (!(rc = this.signaler.wait_event(timeout_))) {
            return null;
        }
        this.active = true;
        cmd_ = this.cpipe.read();
        assert (cmd_ != null);
        return cmd_;
    }

    public void close() {
        this.sync.lock();
        this.sync.unlock();
        this.signaler.close();
    }

    public String toString() {
        return super.toString() + "[" + this.name + "]";
    }
}

