/*
 * Decompiled with CFR 0.152.
 */
package silver;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Map;

public class Compile {
    public static final String SILVERJAR = "silver.composed.Default.jar";
    public static final String SILVERRUNTIME = "SilverRuntime.jar";
    public static final String COPPERCOMPILER = "CopperCompiler.jar";
    public static final String COPPERRUNTIME = "CopperRuntime.jar";

    public static File find_home() {
        File jarsLocation;
        String result = System.getenv("SILVER_HOME");
        if (result == null || result.equals("")) {
            URI jarLocation;
            try {
                jarLocation = Compile.class.getProtectionDomain().getCodeSource().getLocation().toURI();
            }
            catch (Throwable t) {
                System.err.println("Could not find install location!\n");
                System.err.println("This is likely an installation problem.  If this error is expected due to an unusual environment setup, you may run silver.composed.Default.jar directly instead of going through RunSilver.jar\n");
                throw new RuntimeException("Failed to find install location.", t);
            }
            jarsLocation = new File(jarLocation).getParentFile();
        } else {
            jarsLocation = new File(new File(result), "jars");
        }
        File testFile = new File(jarsLocation, SILVERJAR);
        if (!testFile.exists()) {
            System.err.println("Could not find install location!\n");
            System.err.println("Tried " + jarsLocation.getPath() + " but couldn't find " + SILVERJAR);
            System.exit(1);
        }
        return jarsLocation;
    }

    public static void main(String[] args) throws MalformedURLException {
        Map svutil;
        Method svmain;
        File jarsLocation = Compile.find_home();
        File installRoot = jarsLocation.getParentFile();
        URL[] urls = new URL[]{new File(jarsLocation, COPPERCOMPILER).toURI().toURL(), new File(jarsLocation, COPPERRUNTIME).toURI().toURL(), new File(jarsLocation, SILVERRUNTIME).toURI().toURL(), new File(jarsLocation, SILVERJAR).toURI().toURL()};
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        cl = new URLClassLoader(urls, cl);
        try {
            svmain = Class.forName("silver.composed.Default.Main", true, cl).getMethod("main", String[].class);
            svutil = (Map)Class.forName("common.Util", true, cl).getField("environment").get(null);
        }
        catch (Throwable t) {
            System.err.println("Failed to find the appropriate classes to start Silver.\n");
            throw new RuntimeException("Couldn't start silver!", t);
        }
        svutil.put("SILVER_HOME", installRoot.getPath());
        try {
            svmain.invoke(null, new Object[]{args});
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("Silver runtime error", e);
        }
        catch (Throwable t) {
            System.err.println("Error invoking silver.  Installation problem?\n");
            throw new RuntimeException("Silver invocation error", t);
        }
    }
}

