/*
 * Decompiled with CFR 0.152.
 */
package org.ahocorasick.trie;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.LinkedBlockingDeque;
import org.ahocorasick.interval.IntervalTree;
import org.ahocorasick.interval.Intervalable;
import org.ahocorasick.trie.Emit;
import org.ahocorasick.trie.FragmentToken;
import org.ahocorasick.trie.MatchToken;
import org.ahocorasick.trie.State;
import org.ahocorasick.trie.Token;
import org.ahocorasick.trie.TrieConfig;
import org.ahocorasick.trie.handler.DefaultEmitHandler;
import org.ahocorasick.trie.handler.EmitHandler;

public class Trie {
    private TrieConfig trieConfig;
    private State rootState;

    private Trie(TrieConfig trieConfig) {
        this.trieConfig = trieConfig;
        this.rootState = new State();
    }

    private void addKeyword(String keyword) {
        if (keyword == null || keyword.length() == 0) {
            return;
        }
        State currentState = this.rootState;
        char[] cArray = keyword.toCharArray();
        int n = cArray.length;
        for (int i = 0; i < n; ++i) {
            Character character = Character.valueOf(cArray[i]);
            if (this.trieConfig.isCaseInsensitive()) {
                character = Character.valueOf(Character.toLowerCase(character.charValue()));
            }
            currentState = currentState.addState(character);
        }
        currentState.addEmit(this.trieConfig.isCaseInsensitive() ? keyword.toLowerCase() : keyword);
    }

    public Collection<Token> tokenize(String text) {
        ArrayList<Token> tokens = new ArrayList<Token>();
        Collection<Emit> collectedEmits = this.parseText(text);
        int lastCollectedPosition = -1;
        for (Emit emit : collectedEmits) {
            if (emit.getStart() - lastCollectedPosition > 1) {
                tokens.add(this.createFragment(emit, text, lastCollectedPosition));
            }
            tokens.add(this.createMatch(emit, text));
            lastCollectedPosition = emit.getEnd();
        }
        if (text.length() - lastCollectedPosition > 1) {
            tokens.add(this.createFragment(null, text, lastCollectedPosition));
        }
        return tokens;
    }

    private Token createFragment(Emit emit, String text, int lastCollectedPosition) {
        return new FragmentToken(text.substring(lastCollectedPosition + 1, emit == null ? text.length() : emit.getStart()));
    }

    private Token createMatch(Emit emit, String text) {
        return new MatchToken(text.substring(emit.getStart(), emit.getEnd() + 1), emit);
    }

    public Collection<Emit> parseText(CharSequence text) {
        DefaultEmitHandler emitHandler = new DefaultEmitHandler();
        this.parseText(text, emitHandler);
        List<Intervalable> collectedEmits = emitHandler.getEmits();
        if (this.trieConfig.isOnlyWholeWords()) {
            this.removePartialMatches(text, collectedEmits);
        }
        if (this.trieConfig.isOnlyWholeWordsWhiteSpaceSeparated()) {
            this.removePartialMatchesWhiteSpaceSeparated(text, collectedEmits);
        }
        if (!this.trieConfig.isAllowOverlaps()) {
            IntervalTree intervalTree = new IntervalTree(collectedEmits);
            intervalTree.removeOverlaps(collectedEmits);
        }
        return collectedEmits;
    }

    public boolean containsMatch(CharSequence text) {
        Emit firstMatch = this.firstMatch(text);
        return firstMatch != null;
    }

    public void parseText(CharSequence text, EmitHandler emitHandler) {
        State currentState = this.rootState;
        for (int position = 0; position < text.length(); ++position) {
            Character character = Character.valueOf(text.charAt(position));
            if (this.trieConfig.isCaseInsensitive()) {
                character = Character.valueOf(Character.toLowerCase(character.charValue()));
            }
            if (!this.storeEmits(position, currentState = this.getState(currentState, character), emitHandler) || !this.trieConfig.isStopOnHit()) continue;
            return;
        }
    }

    public Emit firstMatch(CharSequence text) {
        if (!this.trieConfig.isAllowOverlaps()) {
            Collection<Emit> parseText = this.parseText(text);
            if (parseText != null && !parseText.isEmpty()) {
                return parseText.iterator().next();
            }
        } else {
            State currentState = this.rootState;
            for (int position = 0; position < text.length(); ++position) {
                Collection<String> emitStrs;
                Character character = Character.valueOf(text.charAt(position));
                if (this.trieConfig.isCaseInsensitive()) {
                    character = Character.valueOf(Character.toLowerCase(character.charValue()));
                }
                if ((emitStrs = (currentState = this.getState(currentState, character)).emit()) == null || emitStrs.isEmpty()) continue;
                for (String emitStr : emitStrs) {
                    Emit emit = new Emit(position - emitStr.length() + 1, position, emitStr);
                    if (this.trieConfig.isOnlyWholeWords()) {
                        if (this.isPartialMatch(text, emit)) continue;
                        return emit;
                    }
                    return emit;
                }
            }
        }
        return null;
    }

    private boolean isPartialMatch(CharSequence searchText, Emit emit) {
        return emit.getStart() != 0 && Character.isAlphabetic(searchText.charAt(emit.getStart() - 1)) || emit.getEnd() + 1 != searchText.length() && Character.isAlphabetic(searchText.charAt(emit.getEnd() + 1));
    }

    private void removePartialMatches(CharSequence searchText, List<Emit> collectedEmits) {
        ArrayList<Emit> removeEmits = new ArrayList<Emit>();
        for (Emit emit : collectedEmits) {
            if (!this.isPartialMatch(searchText, emit)) continue;
            removeEmits.add(emit);
        }
        for (Emit removeEmit : removeEmits) {
            collectedEmits.remove(removeEmit);
        }
    }

    private void removePartialMatchesWhiteSpaceSeparated(CharSequence searchText, List<Emit> collectedEmits) {
        long size = searchText.length();
        ArrayList<Emit> removeEmits = new ArrayList<Emit>();
        for (Emit emit : collectedEmits) {
            if (!(emit.getStart() != 0 && !Character.isWhitespace(searchText.charAt(emit.getStart() - 1)) || (long)(emit.getEnd() + 1) != size && !Character.isWhitespace(searchText.charAt(emit.getEnd() + 1)))) continue;
            removeEmits.add(emit);
        }
        for (Emit removeEmit : removeEmits) {
            collectedEmits.remove(removeEmit);
        }
    }

    private State getState(State currentState, Character character) {
        State newCurrentState = currentState.nextState(character);
        while (newCurrentState == null) {
            currentState = currentState.failure();
            newCurrentState = currentState.nextState(character);
        }
        return newCurrentState;
    }

    private void constructFailureStates() {
        LinkedBlockingDeque<State> queue = new LinkedBlockingDeque<State>();
        for (State depthOneState : this.rootState.getStates()) {
            depthOneState.setFailure(this.rootState);
            queue.add(depthOneState);
        }
        while (!queue.isEmpty()) {
            State currentState = (State)queue.remove();
            for (Character transition : currentState.getTransitions()) {
                State targetState = currentState.nextState(transition);
                queue.add(targetState);
                State traceFailureState = currentState.failure();
                while (traceFailureState.nextState(transition) == null) {
                    traceFailureState = traceFailureState.failure();
                }
                State newFailureState = traceFailureState.nextState(transition);
                targetState.setFailure(newFailureState);
                targetState.addEmit(newFailureState.emit());
            }
        }
    }

    private boolean storeEmits(int position, State currentState, EmitHandler emitHandler) {
        boolean emitted = false;
        Collection<String> emits = currentState.emit();
        if (emits != null && !emits.isEmpty()) {
            for (String emit : emits) {
                emitHandler.emit(new Emit(position - emit.length() + 1, position, emit));
                emitted = true;
            }
        }
        return emitted;
    }

    public static TrieBuilder builder() {
        return new TrieBuilder();
    }

    public static class TrieBuilder {
        private TrieConfig trieConfig = new TrieConfig();
        private Trie trie = new Trie(this.trieConfig);

        private TrieBuilder() {
        }

        public TrieBuilder caseInsensitive() {
            this.trieConfig.setCaseInsensitive(true);
            return this;
        }

        public TrieBuilder removeOverlaps() {
            this.trieConfig.setAllowOverlaps(false);
            return this;
        }

        public TrieBuilder onlyWholeWords() {
            this.trieConfig.setOnlyWholeWords(true);
            return this;
        }

        public TrieBuilder onlyWholeWordsWhiteSpaceSeparated() {
            this.trieConfig.setOnlyWholeWordsWhiteSpaceSeparated(true);
            return this;
        }

        public TrieBuilder addKeyword(String keyword) {
            this.trie.addKeyword(keyword);
            return this;
        }

        public TrieBuilder stopOnHit() {
            this.trie.trieConfig.setStopOnHit(true);
            return this;
        }

        public Trie build() {
            this.trie.constructFailureStates();
            return this.trie;
        }
    }
}

